/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.sequences;

import java.util.random.RandomGenerator;
import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.math.rand.RandomVariates;
import org.cicirello.sequences.SequenceSampler;
import org.cicirello.sequences.SequenceSamplerUtils;
import org.cicirello.util.ArrayMinimumLengthEnforcer;

public final class SequenceReservoirSampler
implements SequenceSampler {
    private final RandomGenerator r;

    public SequenceReservoirSampler(RandomGenerator r) {
        this.r = r;
    }

    @Override
    public int[] nextSample(int[] source, int k, int[] target) {
        return SequenceReservoirSampler.sample(source, k, target, this.r);
    }

    @Override
    public long[] nextSample(long[] source, int k, long[] target) {
        return SequenceReservoirSampler.sample(source, k, target, this.r);
    }

    @Override
    public short[] nextSample(short[] source, int k, short[] target) {
        return SequenceReservoirSampler.sample(source, k, target, this.r);
    }

    @Override
    public byte[] nextSample(byte[] source, int k, byte[] target) {
        return SequenceReservoirSampler.sample(source, k, target, this.r);
    }

    @Override
    public double[] nextSample(double[] source, int k, double[] target) {
        return SequenceReservoirSampler.sample(source, k, target, this.r);
    }

    @Override
    public float[] nextSample(float[] source, int k, float[] target) {
        return SequenceReservoirSampler.sample(source, k, target, this.r);
    }

    @Override
    public char[] nextSample(char[] source, int k, char[] target) {
        return SequenceReservoirSampler.sample(source, k, target, this.r);
    }

    @Override
    public char[] nextSample(String source, int k, char[] target) {
        return SequenceReservoirSampler.sample(source, k, target, this.r);
    }

    @Override
    public <T> T[] nextSample(T[] source, int k, T[] target) {
        return SequenceReservoirSampler.sample(source, k, target, this.r);
    }

    public static int[] sample(int[] source, double p, RandomGenerator r) {
        return SequenceReservoirSampler.sample(source, RandomVariates.nextBinomial(source.length, p), null, r);
    }

    public static long[] sample(long[] source, double p, RandomGenerator r) {
        return SequenceReservoirSampler.sample(source, RandomVariates.nextBinomial(source.length, p), null, r);
    }

    public static short[] sample(short[] source, double p, RandomGenerator r) {
        return SequenceReservoirSampler.sample(source, RandomVariates.nextBinomial(source.length, p), null, r);
    }

    public static byte[] sample(byte[] source, double p, RandomGenerator r) {
        return SequenceReservoirSampler.sample(source, RandomVariates.nextBinomial(source.length, p), null, r);
    }

    public static double[] sample(double[] source, double p, RandomGenerator r) {
        return SequenceReservoirSampler.sample(source, RandomVariates.nextBinomial(source.length, p), null, r);
    }

    public static float[] sample(float[] source, double p, RandomGenerator r) {
        return SequenceReservoirSampler.sample(source, RandomVariates.nextBinomial(source.length, p), null, r);
    }

    public static char[] sample(char[] source, double p, RandomGenerator r) {
        return SequenceReservoirSampler.sample(source, RandomVariates.nextBinomial(source.length, p), null, r);
    }

    public static char[] sample(String source, double p, RandomGenerator r) {
        return SequenceReservoirSampler.sample(source, RandomVariates.nextBinomial(source.length(), p), null, r);
    }

    public static <T> T[] sample(T[] source, double p, RandomGenerator r) {
        return SequenceReservoirSampler.sample(source, RandomVariates.nextBinomial(source.length, p), null, r);
    }

    public static int[] sample(int[] source, int k, int[] target, RandomGenerator r) {
        SequenceSamplerUtils.validateK(k, source.length);
        target = ArrayMinimumLengthEnforcer.enforce(target, k);
        System.arraycopy(source, 0, target, 0, k);
        for (int i = k; i < source.length; ++i) {
            int j = RandomIndexer.nextInt(i + 1, r);
            if (j >= k) continue;
            target[j] = source[i];
        }
        return target;
    }

    public static long[] sample(long[] source, int k, long[] target, RandomGenerator r) {
        SequenceSamplerUtils.validateK(k, source.length);
        target = ArrayMinimumLengthEnforcer.enforce(target, k);
        System.arraycopy(source, 0, target, 0, k);
        for (int i = k; i < source.length; ++i) {
            int j = RandomIndexer.nextInt(i + 1, r);
            if (j >= k) continue;
            target[j] = source[i];
        }
        return target;
    }

    public static short[] sample(short[] source, int k, short[] target, RandomGenerator r) {
        SequenceSamplerUtils.validateK(k, source.length);
        target = ArrayMinimumLengthEnforcer.enforce(target, k);
        System.arraycopy(source, 0, target, 0, k);
        for (int i = k; i < source.length; ++i) {
            int j = RandomIndexer.nextInt(i + 1, r);
            if (j >= k) continue;
            target[j] = source[i];
        }
        return target;
    }

    public static byte[] sample(byte[] source, int k, byte[] target, RandomGenerator r) {
        SequenceSamplerUtils.validateK(k, source.length);
        target = ArrayMinimumLengthEnforcer.enforce(target, k);
        System.arraycopy(source, 0, target, 0, k);
        for (int i = k; i < source.length; ++i) {
            int j = RandomIndexer.nextInt(i + 1, r);
            if (j >= k) continue;
            target[j] = source[i];
        }
        return target;
    }

    public static char[] sample(char[] source, int k, char[] target, RandomGenerator r) {
        SequenceSamplerUtils.validateK(k, source.length);
        target = ArrayMinimumLengthEnforcer.enforce(target, k);
        System.arraycopy(source, 0, target, 0, k);
        for (int i = k; i < source.length; ++i) {
            int j = RandomIndexer.nextInt(i + 1, r);
            if (j >= k) continue;
            target[j] = source[i];
        }
        return target;
    }

    public static char[] sample(String source, int k, char[] target, RandomGenerator r) {
        return SequenceReservoirSampler.sample(source.toCharArray(), k, target, r);
    }

    public static double[] sample(double[] source, int k, double[] target, RandomGenerator r) {
        SequenceSamplerUtils.validateK(k, source.length);
        target = ArrayMinimumLengthEnforcer.enforce(target, k);
        System.arraycopy(source, 0, target, 0, k);
        for (int i = k; i < source.length; ++i) {
            int j = RandomIndexer.nextInt(i + 1, r);
            if (j >= k) continue;
            target[j] = source[i];
        }
        return target;
    }

    public static float[] sample(float[] source, int k, float[] target, RandomGenerator r) {
        SequenceSamplerUtils.validateK(k, source.length);
        target = ArrayMinimumLengthEnforcer.enforce(target, k);
        System.arraycopy(source, 0, target, 0, k);
        for (int i = k; i < source.length; ++i) {
            int j = RandomIndexer.nextInt(i + 1, r);
            if (j >= k) continue;
            target[j] = source[i];
        }
        return target;
    }

    public static <T> T[] sample(T[] source, int k, T[] target, RandomGenerator r) {
        SequenceSamplerUtils.validateK(k, source.length);
        target = SequenceSamplerUtils.allocateIfNecessary(source, k, target);
        System.arraycopy(source, 0, target, 0, k);
        for (int i = k; i < source.length; ++i) {
            int j = RandomIndexer.nextInt(i + 1, r);
            if (j >= k) continue;
            target[j] = source[i];
        }
        return target;
    }
}

