/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.math.rand;

import java.util.Random;
import java.util.SplittableRandom;
import java.util.concurrent.ThreadLocalRandom;
import org.cicirello.math.rand.BTPE;

public final class RandomVariates {
    private RandomVariates() {
    }

    public static int nextBinomial(int n, double p) {
        return BTPE.nextBinomial(n, p, ThreadLocalRandom.current());
    }

    public static int nextBinomial(int n, double p, Random r) {
        return BTPE.nextBinomial(n, p, r);
    }

    public static int nextBinomial(int n, double p, SplittableRandom r) {
        return BTPE.nextBinomial(n, p, r);
    }

    public static double nextCauchy(double median, double scale) {
        return median + RandomVariates.internalNextCauchy(scale, RandomVariates.internalNextTransformedU(ThreadLocalRandom.current(), ThreadLocalRandom.current().nextDouble()));
    }

    public static double nextCauchy(double scale) {
        return RandomVariates.internalNextCauchy(scale, RandomVariates.internalNextTransformedU(ThreadLocalRandom.current(), ThreadLocalRandom.current().nextDouble()));
    }

    public static double nextCauchy(double median, double scale, Random r) {
        return median + RandomVariates.internalNextCauchy(scale, RandomVariates.internalNextTransformedU(r, r.nextDouble()));
    }

    public static double nextCauchy(double scale, Random r) {
        return RandomVariates.internalNextCauchy(scale, RandomVariates.internalNextTransformedU(r, r.nextDouble()));
    }

    public static double nextCauchy(double median, double scale, SplittableRandom r) {
        return median + RandomVariates.internalNextCauchy(scale, RandomVariates.internalNextTransformedU(r, r.nextDouble()));
    }

    public static double nextCauchy(double scale, SplittableRandom r) {
        return RandomVariates.internalNextCauchy(scale, RandomVariates.internalNextTransformedU(r, r.nextDouble()));
    }

    static double internalNextCauchy(double scale, double u) {
        return scale * StrictMath.tan(Math.PI * u);
    }

    static double internalNextTransformedU(Random r, double u) {
        return u == 0.5 && r.nextBoolean() ? -0.5 : u;
    }

    static double internalNextTransformedU(SplittableRandom r, double u) {
        return u == 0.5 && r.nextBoolean() ? -0.5 : u;
    }
}

