/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.math.rand;

import java.util.Random;
import java.util.SplittableRandom;
import org.cicirello.math.MathFunctions;

final class BTPE {
    private static final ThreadLocal<BTPE> tl = new ThreadLocal();
    private int n;
    private double p;
    private double r;
    private double q;
    private double f_m;
    private int m;
    private double nr;
    private double nrq;
    private double p1;
    private double x_m;
    private double x_l;
    private double x_r;
    private double c;
    private double lambda_l;
    private double lambda_r;
    private double p2;
    private double p3;
    private double p4;
    private double nrqInv;
    private double s;
    private double a;
    private double pow0;
    private static final int BTPE_CUTOFF = 10;

    public static int nextBinomial(int n, double p, Random generator) {
        return BTPE.threadLocalInstance(n, p).next(generator);
    }

    public static int nextBinomial(int n, double p, SplittableRandom generator) {
        return BTPE.threadLocalInstance(n, p).next(generator);
    }

    private static BTPE threadLocalInstance(int n, double p) {
        BTPE btpe = tl.get();
        if (btpe == null) {
            btpe = new BTPE(n, p);
            tl.set(btpe);
        } else if (btpe.n != n || btpe.p != p) {
            btpe.init(n, p);
        }
        return btpe;
    }

    private BTPE(int n, double p) {
        this.init(n, p);
    }

    private void init(int n, double p) {
        this.n = n;
        this.p = p;
        if (p <= 0.5) {
            this.r = p;
            this.q = 1.0 - p;
        } else {
            this.q = p;
            this.r = 1.0 - p;
        }
        this.nr = (double)n * this.r;
        this.s = this.r / this.q;
        if (this.nr < 10.0) {
            this.a = (double)(n + 1) * this.s;
            this.pow0 = MathFunctions.pow(this.q, n);
        } else {
            this.f_m = this.nr + this.r;
            this.m = (int)this.f_m;
            this.nrq = this.nr * this.q;
            this.p1 = Math.floor(2.195 * Math.sqrt(this.nrq) - 4.6 * this.q) + 0.5;
            this.x_m = (double)this.m + 0.5;
            this.x_l = this.x_m - this.p1;
            this.x_r = this.x_m + this.p1;
            this.c = 0.134 + 20.5 / (15.3 + (double)this.m);
            this.a = (this.f_m - this.x_l) / (this.f_m - this.x_l * this.r);
            this.lambda_l = this.a * (1.0 + 0.5 * this.a);
            this.a = (this.x_r - this.f_m) / (this.x_r * this.q);
            this.lambda_r = this.a * (1.0 + 0.5 * this.a);
            this.p2 = this.p1 * (1.0 + this.c + this.c);
            this.p3 = this.p2 + this.c / this.lambda_l;
            this.p4 = this.p3 + this.c / this.lambda_r;
            this.nrqInv = 1.0 / this.nrq;
        }
    }

    private int next(Random generator) {
        int y;
        if (this.nr < 10.0) {
            double u = generator.nextDouble();
            int y2 = 0;
            for (double pow = this.pow0; u > pow; u -= pow, pow *= this.a / (double)(++y2) - this.s) {
            }
            return this.p > 0.5 ? this.n - y2 : y2;
        }
        while (true) {
            int k;
            double u = this.p4 * generator.nextDouble();
            double v = generator.nextDouble();
            if (u <= this.p1) {
                y = (int)(this.x_m - this.p1 * v + u);
                break;
            }
            if (u <= this.p2) {
                double x = this.x_l + (u - this.p1) / this.c;
                if ((v = v * this.c + 1.0 - Math.abs((double)this.m - x + 0.5) / this.p1) > 1.0) continue;
                y = (int)x;
            } else if (u <= this.p3) {
                y = (int)Math.floor(this.x_l + Math.log(v) / this.lambda_l);
                if (y < 0) continue;
                v = v * (u - this.p2) * this.lambda_l;
            } else {
                y = (int)Math.floor(this.x_r - Math.log(v) / this.lambda_r);
                if (y > this.n) continue;
                v = v * (u - this.p3) * this.lambda_r;
            }
            int n = k = this.m > y ? this.m - y : y - this.m;
            if (k <= 20 || (double)k >= this.nrq * 0.5 - 1.0) {
                this.a = this.s * (double)(this.n + 1);
                double f = 1.0;
                if (this.m < y) {
                    for (int i = this.m + 1; i <= y; ++i) {
                        f *= this.a / (double)i - this.s;
                    }
                } else if (this.m > y) {
                    for (int i = y + 1; i <= this.m; ++i) {
                        f /= this.a / (double)i - this.s;
                    }
                }
                if (!(v > f)) break;
                continue;
            }
            double rho = (double)k * this.nrqInv * (((double)k * ((double)k * 0.3333333333333333 + 0.625) + 0.16666666666666666) * this.nrqInv + 0.5);
            double t = (double)(-k * k) * (0.5 * this.nrqInv);
            this.a = Math.log(v);
            if (this.a < t - rho) break;
            if (this.a > t + rho) continue;
            int x1 = y + 1;
            int f1 = this.m + 1;
            int z = this.n + 1 - this.m;
            int w = this.n - y + 1;
            if (!(this.a > this.x_m * Math.log((double)f1 / (double)x1) + ((double)(this.n - this.m) + 0.5) * Math.log((double)z / (double)w) + (double)(y - this.m) * Math.log((double)w * this.r / ((double)x1 * this.q)) + this.stirlingApproximation(f1) + this.stirlingApproximation(z) + this.stirlingApproximation(x1) + this.stirlingApproximation(w))) break;
        }
        return this.p > 0.5 ? this.n - y : y;
    }

    private int next(SplittableRandom generator) {
        int y;
        if (this.nr < 10.0) {
            double u = generator.nextDouble();
            int y2 = 0;
            for (double pow = this.pow0; u > pow; u -= pow, pow *= this.a / (double)(++y2) - this.s) {
            }
            return this.p > 0.5 ? this.n - y2 : y2;
        }
        while (true) {
            int k;
            double u = this.p4 * generator.nextDouble();
            double v = generator.nextDouble();
            if (u <= this.p1) {
                y = (int)(this.x_m - this.p1 * v + u);
                break;
            }
            if (u <= this.p2) {
                double x = this.x_l + (u - this.p1) / this.c;
                if ((v = v * this.c + 1.0 - Math.abs((double)this.m - x + 0.5) / this.p1) > 1.0) continue;
                y = (int)x;
            } else if (u <= this.p3) {
                y = (int)Math.floor(this.x_l + Math.log(v) / this.lambda_l);
                if (y < 0) continue;
                v = v * (u - this.p2) * this.lambda_l;
            } else {
                y = (int)Math.floor(this.x_r - Math.log(v) / this.lambda_r);
                if (y > this.n) continue;
                v = v * (u - this.p3) * this.lambda_r;
            }
            int n = k = this.m > y ? this.m - y : y - this.m;
            if (k <= 20 || (double)k >= this.nrq * 0.5 - 1.0) {
                this.a = this.s * (double)(this.n + 1);
                double f = 1.0;
                if (this.m < y) {
                    for (int i = this.m + 1; i <= y; ++i) {
                        f *= this.a / (double)i - this.s;
                    }
                } else if (this.m > y) {
                    for (int i = y + 1; i <= this.m; ++i) {
                        f /= this.a / (double)i - this.s;
                    }
                }
                if (!(v > f)) break;
                continue;
            }
            double rho = (double)k * this.nrqInv * (((double)k * ((double)k * 0.3333333333333333 + 0.625) + 0.16666666666666666) * this.nrqInv + 0.5);
            double t = (double)(-k * k) * (0.5 * this.nrqInv);
            this.a = Math.log(v);
            if (this.a < t - rho) break;
            if (this.a > t + rho) continue;
            int x1 = y + 1;
            int f1 = this.m + 1;
            int z = this.n + 1 - this.m;
            int w = this.n - y + 1;
            if (!(this.a > this.x_m * Math.log((double)f1 / (double)x1) + ((double)(this.n - this.m) + 0.5) * Math.log((double)z / (double)w) + (double)(y - this.m) * Math.log((double)w * this.r / ((double)x1 * this.q)) + this.stirlingApproximation(f1) + this.stirlingApproximation(z) + this.stirlingApproximation(x1) + this.stirlingApproximation(w))) break;
        }
        return this.p > 0.5 ? this.n - y : y;
    }

    private double stirlingApproximation(int x) {
        int x2 = x * x;
        return (13860.0 - (462.0 - (132.0 - (99.0 - 140.0 / (double)x2) / (double)x2) / (double)x2) / (double)x2) / (double)x / 166320.0;
    }
}

