/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.math.rand;

import java.util.Random;
import java.util.SplittableRandom;
import java.util.concurrent.ThreadLocalRandom;
import org.cicirello.math.rand.RandomVariates;

public final class RandomIndexer {
    private RandomIndexer() {
    }

    public static int nextInt(int bound) {
        return RandomIndexer.nextInt(bound, ThreadLocalRandom.current());
    }

    public static int nextInt(int bound, SplittableRandom gen) {
        if (bound < 1) {
            throw new IllegalArgumentException("bound must be positive");
        }
        long product = (long)(gen.nextInt() & Integer.MAX_VALUE) * (long)bound;
        int low31 = (int)product & Integer.MAX_VALUE;
        if (low31 < bound) {
            int threshold = (Integer.MIN_VALUE - bound) % bound;
            while (low31 < threshold) {
                product = (long)(gen.nextInt() & Integer.MAX_VALUE) * (long)bound;
                low31 = (int)product & Integer.MAX_VALUE;
            }
        }
        return (int)(product >> 31);
    }

    public static int nextInt(int bound, Random gen) {
        if (bound < 1) {
            throw new IllegalArgumentException("bound must be positive");
        }
        long product = (long)(gen.nextInt() & Integer.MAX_VALUE) * (long)bound;
        int low31 = (int)product & Integer.MAX_VALUE;
        if (low31 < bound) {
            int threshold = (Integer.MIN_VALUE - bound) % bound;
            while (low31 < threshold) {
                product = (long)(gen.nextInt() & Integer.MAX_VALUE) * (long)bound;
                low31 = (int)product & Integer.MAX_VALUE;
            }
        }
        return (int)(product >> 31);
    }

    public static int nextBiasedInt(int bound) {
        if (bound < 1) {
            throw new IllegalArgumentException("bound must be positive");
        }
        return (int)((long)(ThreadLocalRandom.current().nextInt() & Integer.MAX_VALUE) * (long)bound >> 31);
    }

    public static int nextBiasedInt(int bound, SplittableRandom gen) {
        if (bound < 1) {
            throw new IllegalArgumentException("bound must be positive");
        }
        return (int)((long)(gen.nextInt() & Integer.MAX_VALUE) * (long)bound >> 31);
    }

    public static int nextBiasedInt(int bound, Random gen) {
        if (bound < 1) {
            throw new IllegalArgumentException("bound must be positive");
        }
        return (int)((long)(gen.nextInt() & Integer.MAX_VALUE) * (long)bound >> 31);
    }

    public static int[] sampleReservoir(int n, int k, int[] result) {
        return RandomIndexer.sampleReservoir(n, k, result, ThreadLocalRandom.current());
    }

    public static int[] sampleReservoir(int n, int k, int[] result, Random gen) {
        int i;
        if (k > n) {
            throw new IllegalArgumentException("k must be no greater than n");
        }
        if (result == null || result.length < k) {
            result = new int[k];
        }
        for (i = 0; i < k; ++i) {
            result[i] = i;
        }
        for (i = k; i < n; ++i) {
            int j = RandomIndexer.nextInt(i + 1, gen);
            if (j >= k) continue;
            result[j] = i;
        }
        return result;
    }

    public static int[] sampleReservoir(int n, int k, int[] result, SplittableRandom gen) {
        int i;
        if (k > n) {
            throw new IllegalArgumentException("k must be no greater than n");
        }
        if (result == null || result.length < k) {
            result = new int[k];
        }
        for (i = 0; i < k; ++i) {
            result[i] = i;
        }
        for (i = k; i < n; ++i) {
            int j = RandomIndexer.nextInt(i + 1, gen);
            if (j >= k) continue;
            result[j] = i;
        }
        return result;
    }

    public static int[] samplePool(int n, int k, int[] result) {
        return RandomIndexer.samplePool(n, k, result, ThreadLocalRandom.current());
    }

    public static int[] samplePool(int n, int k, int[] result, SplittableRandom gen) {
        if (k > n) {
            throw new IllegalArgumentException("k must be no greater than n");
        }
        if (result == null || result.length < k) {
            result = new int[k];
        }
        int[] pool = new int[n];
        for (int i = 0; i < n; ++i) {
            pool[i] = i;
        }
        int remaining = n;
        for (int i = 0; i < k; ++i) {
            int temp = RandomIndexer.nextInt(remaining, gen);
            result[i] = pool[temp];
            pool[temp] = pool[--remaining];
        }
        return result;
    }

    public static int[] samplePool(int n, int k, int[] result, Random gen) {
        if (k > n) {
            throw new IllegalArgumentException("k must be no greater than n");
        }
        if (result == null || result.length < k) {
            result = new int[k];
        }
        int[] pool = new int[n];
        for (int i = 0; i < n; ++i) {
            pool[i] = i;
        }
        int remaining = n;
        for (int i = 0; i < k; ++i) {
            int temp = RandomIndexer.nextInt(remaining, gen);
            result[i] = pool[temp];
            pool[temp] = pool[--remaining];
        }
        return result;
    }

    public static int[] sampleInsertion(int n, int k, int[] result) {
        return RandomIndexer.sampleInsertion(n, k, result, ThreadLocalRandom.current());
    }

    public static int[] sampleInsertion(int n, int k, int[] result, SplittableRandom gen) {
        if (k > n) {
            throw new IllegalArgumentException("k must be no greater than n");
        }
        if (result == null || result.length < k) {
            result = new int[k];
        }
        for (int i = 0; i < k; ++i) {
            int temp = RandomIndexer.nextInt(n - i, gen);
            for (int j = k - i; j < k && temp >= result[j]; ++temp, ++j) {
                result[j - 1] = result[j];
            }
            result[j - 1] = temp;
        }
        return result;
    }

    public static int[] sampleInsertion(int n, int k, int[] result, Random gen) {
        if (k > n) {
            throw new IllegalArgumentException("k must be no greater than n");
        }
        if (result == null || result.length < k) {
            result = new int[k];
        }
        for (int i = 0; i < k; ++i) {
            int temp = RandomIndexer.nextInt(n - i, gen);
            for (int j = k - i; j < k && temp >= result[j]; ++temp, ++j) {
                result[j - 1] = result[j];
            }
            result[j - 1] = temp;
        }
        return result;
    }

    public static int[] sample(int n, double p) {
        return RandomIndexer.sample(n, p, ThreadLocalRandom.current());
    }

    public static int[] sample(int n, double p, SplittableRandom r) {
        if (p <= 0.0) {
            return new int[0];
        }
        if (p >= 1.0) {
            int[] result = new int[n];
            for (int i = 0; i < n; ++i) {
                result[i] = i;
            }
            return result;
        }
        return RandomIndexer.sample(n, RandomVariates.nextBinomial(n, p, r), null, r);
    }

    public static int[] sample(int n, double p, Random r) {
        if (p <= 0.0) {
            return new int[0];
        }
        if (p >= 1.0) {
            int[] result = new int[n];
            for (int i = 0; i < n; ++i) {
                result[i] = i;
            }
            return result;
        }
        return RandomIndexer.sample(n, RandomVariates.nextBinomial(n, p, r), null, r);
    }

    public static int[] sample(int n, int k, int[] result) {
        if (k + k < n) {
            if (k * k < n) {
                return RandomIndexer.sampleInsertion(n, k, result, ThreadLocalRandom.current());
            }
            return RandomIndexer.samplePool(n, k, result, ThreadLocalRandom.current());
        }
        return RandomIndexer.sampleReservoir(n, k, result, ThreadLocalRandom.current());
    }

    public static int[] sample(int n, int k, int[] result, SplittableRandom gen) {
        if (k + k < n) {
            if (k * k < n) {
                return RandomIndexer.sampleInsertion(n, k, result, gen);
            }
            return RandomIndexer.samplePool(n, k, result, gen);
        }
        return RandomIndexer.sampleReservoir(n, k, result, gen);
    }

    public static int[] sample(int n, int k, int[] result, Random gen) {
        if (k + k < n) {
            if (k * k < n) {
                return RandomIndexer.sampleInsertion(n, k, result, gen);
            }
            return RandomIndexer.samplePool(n, k, result, gen);
        }
        return RandomIndexer.sampleReservoir(n, k, result, gen);
    }

    public static int[] nextIntPair(int n, int[] result) {
        return RandomIndexer.nextIntPair(n, result, ThreadLocalRandom.current());
    }

    public static int[] nextIntPair(int n, int[] result, SplittableRandom gen) {
        if (result == null || result.length < 2) {
            result = new int[]{RandomIndexer.nextInt(n, gen), RandomIndexer.nextInt(n - 1, gen)};
        }
        if (result[1] >= result[0]) {
            result[1] = result[1] + 1;
        }
        return result;
    }

    public static int[] nextIntPair(int n, int[] result, Random gen) {
        if (result == null || result.length < 2) {
            result = new int[]{RandomIndexer.nextInt(n, gen), RandomIndexer.nextInt(n - 1, gen)};
        }
        if (result[1] >= result[0]) {
            result[1] = result[1] + 1;
        }
        return result;
    }

    public static int[] nextIntTriple(int n, int[] result) {
        return RandomIndexer.nextIntTriple(n, result, ThreadLocalRandom.current());
    }

    public static int[] nextIntTriple(int n, int[] result, boolean sort) {
        return RandomIndexer.nextIntTriple(n, result, sort, ThreadLocalRandom.current());
    }

    public static int[] nextIntTriple(int n, int[] result, boolean sort, SplittableRandom gen) {
        if (result == null || result.length < 3) {
            result = new int[]{RandomIndexer.nextInt(n, gen), RandomIndexer.nextInt(n - 1, gen), RandomIndexer.nextInt(n - 2, gen)};
        }
        if (sort) {
            RandomIndexer.adjustSortTriple(result);
        } else {
            RandomIndexer.adjustTriple(result);
        }
        return result;
    }

    public static int[] nextIntTriple(int n, int[] result, boolean sort, Random gen) {
        if (result == null || result.length < 3) {
            result = new int[]{RandomIndexer.nextInt(n, gen), RandomIndexer.nextInt(n - 1, gen), RandomIndexer.nextInt(n - 2, gen)};
        }
        if (sort) {
            RandomIndexer.adjustSortTriple(result);
        } else {
            RandomIndexer.adjustTriple(result);
        }
        return result;
    }

    public static int[] nextIntTriple(int n, int[] result, SplittableRandom gen) {
        if (result == null || result.length < 3) {
            result = new int[]{RandomIndexer.nextInt(n, gen), RandomIndexer.nextInt(n - 1, gen), RandomIndexer.nextInt(n - 2, gen)};
        }
        RandomIndexer.adjustTriple(result);
        return result;
    }

    public static int[] nextIntTriple(int n, int[] result, Random gen) {
        if (result == null || result.length < 3) {
            result = new int[]{RandomIndexer.nextInt(n, gen), RandomIndexer.nextInt(n - 1, gen), RandomIndexer.nextInt(n - 2, gen)};
        }
        RandomIndexer.adjustTriple(result);
        return result;
    }

    public static boolean[] arrayMask(int n) {
        return RandomIndexer.arrayMask(n, ThreadLocalRandom.current());
    }

    public static boolean[] arrayMask(int n, SplittableRandom gen) {
        boolean[] result = new boolean[n];
        for (int i = 0; i < n; ++i) {
            result[i] = gen.nextBoolean();
        }
        return result;
    }

    public static boolean[] arrayMask(int n, Random gen) {
        boolean[] result = new boolean[n];
        for (int i = 0; i < n; ++i) {
            result[i] = gen.nextBoolean();
        }
        return result;
    }

    public static boolean[] arrayMask(int n, int k) {
        return RandomIndexer.arrayMask(n, k, (Random)ThreadLocalRandom.current());
    }

    public static boolean[] arrayMask(int n, int k, SplittableRandom gen) {
        boolean[] result;
        block3: {
            block2: {
                result = new boolean[n];
                if (k < n) break block2;
                for (int i = 0; i < n; ++i) {
                    result[i] = true;
                }
                break block3;
            }
            if (k <= 0) break block3;
            int[] indexes = RandomIndexer.sample(n, k, null, gen);
            for (int i = 0; i < k; ++i) {
                result[indexes[i]] = true;
            }
        }
        return result;
    }

    public static boolean[] arrayMask(int n, int k, Random gen) {
        boolean[] result;
        block3: {
            block2: {
                result = new boolean[n];
                if (k < n) break block2;
                for (int i = 0; i < n; ++i) {
                    result[i] = true;
                }
                break block3;
            }
            if (k <= 0) break block3;
            int[] indexes = RandomIndexer.sample(n, k, null, gen);
            for (int i = 0; i < k; ++i) {
                result[indexes[i]] = true;
            }
        }
        return result;
    }

    public static boolean[] arrayMask(int n, double p) {
        return RandomIndexer.arrayMask(n, p, (Random)ThreadLocalRandom.current());
    }

    public static boolean[] arrayMask(int n, double p, SplittableRandom gen) {
        boolean[] result;
        block3: {
            block2: {
                result = new boolean[n];
                if (!(p >= 1.0)) break block2;
                for (int i = 0; i < n; ++i) {
                    result[i] = true;
                }
                break block3;
            }
            if (!(p > 0.0)) break block3;
            int[] s = RandomIndexer.sample(n, p, gen);
            for (int i = 0; i < s.length; ++i) {
                result[s[i]] = true;
            }
        }
        return result;
    }

    public static boolean[] arrayMask(int n, double p, Random gen) {
        boolean[] result;
        block3: {
            block2: {
                result = new boolean[n];
                if (!(p >= 1.0)) break block2;
                for (int i = 0; i < n; ++i) {
                    result[i] = true;
                }
                break block3;
            }
            if (!(p > 0.0)) break block3;
            int[] s = RandomIndexer.sample(n, p, gen);
            for (int i = 0; i < s.length; ++i) {
                result[s[i]] = true;
            }
        }
        return result;
    }

    public static int[] nextWindowedIntPair(int n, int window, int[] result) {
        return RandomIndexer.nextWindowedIntPair(n, window, result, ThreadLocalRandom.current());
    }

    public static int[] nextWindowedIntPair(int n, int window, int[] result, SplittableRandom gen) {
        if (window >= n - 1) {
            return RandomIndexer.nextIntPair(n, result, gen);
        }
        if (result == null || result.length < 2) {
            result = new int[2];
        }
        int z1 = n - window;
        int z2 = z1 + z1;
        int i = RandomIndexer.nextInt(z2 + window - 1, gen);
        int j = RandomIndexer.nextInt(window, gen);
        RandomIndexer.setAndAdjustWindowedPair(result, i, j, z1, z2);
        return result;
    }

    public static int[] nextWindowedIntPair(int n, int window, int[] result, Random gen) {
        if (window >= n - 1) {
            return RandomIndexer.nextIntPair(n, result, gen);
        }
        if (result == null || result.length < 2) {
            result = new int[2];
        }
        int z1 = n - window;
        int z2 = z1 + z1;
        int i = RandomIndexer.nextInt(z2 + window - 1, gen);
        int j = RandomIndexer.nextInt(window, gen);
        RandomIndexer.setAndAdjustWindowedPair(result, i, j, z1, z2);
        return result;
    }

    public static int[] nextWindowedIntTriple(int n, int window, int[] result) {
        return RandomIndexer.nextWindowedIntTriple(n, window, result, ThreadLocalRandom.current());
    }

    public static int[] nextWindowedIntTriple(int n, int window, int[] result, boolean sort) {
        return RandomIndexer.nextWindowedIntTriple(n, window, result, sort, ThreadLocalRandom.current());
    }

    public static int[] nextWindowedIntTriple(int n, int window, int[] result, SplittableRandom gen) {
        if (window >= n - 1) {
            return RandomIndexer.nextIntTriple(n, result, gen);
        }
        if (result == null || result.length < 3) {
            result = new int[3];
        }
        int z1 = n - window;
        int z3 = 3 * z1;
        int i = RandomIndexer.nextInt(z3 + window - 2, gen);
        int j = RandomIndexer.nextInt(window, gen);
        int k = RandomIndexer.nextInt(window - 1, gen);
        RandomIndexer.setAndAdjustWindowedTriple(result, i, j, k, z1, z3);
        return result;
    }

    public static int[] nextWindowedIntTriple(int n, int window, int[] result, boolean sort, SplittableRandom gen) {
        if (window >= n - 1) {
            return RandomIndexer.nextIntTriple(n, result, sort, gen);
        }
        if (result == null || result.length < 3) {
            result = new int[3];
        }
        int z1 = n - window;
        int z3 = 3 * z1;
        int i = RandomIndexer.nextInt(z3 + window - 2, gen);
        int j = RandomIndexer.nextInt(window, gen);
        int k = RandomIndexer.nextInt(window - 1, gen);
        if (sort) {
            RandomIndexer.sortSetAndAdjustWindowedTriple(result, i, j, k, z1, z3);
        } else {
            RandomIndexer.setAndAdjustWindowedTriple(result, i, j, k, z1, z3);
        }
        return result;
    }

    public static int[] nextWindowedIntTriple(int n, int window, int[] result, Random gen) {
        if (window >= n - 1) {
            return RandomIndexer.nextIntTriple(n, result, gen);
        }
        if (result == null || result.length < 3) {
            result = new int[3];
        }
        int z1 = n - window;
        int z3 = 3 * z1;
        int i = RandomIndexer.nextInt(z3 + window - 2, gen);
        int j = RandomIndexer.nextInt(window, gen);
        int k = RandomIndexer.nextInt(window - 1, gen);
        RandomIndexer.setAndAdjustWindowedTriple(result, i, j, k, z1, z3);
        return result;
    }

    public static int[] nextWindowedIntTriple(int n, int window, int[] result, boolean sort, Random gen) {
        if (window >= n - 1) {
            return RandomIndexer.nextIntTriple(n, result, sort, gen);
        }
        if (result == null || result.length < 3) {
            result = new int[3];
        }
        int z1 = n - window;
        int z3 = 3 * z1;
        int i = RandomIndexer.nextInt(z3 + window - 2, gen);
        int j = RandomIndexer.nextInt(window, gen);
        int k = RandomIndexer.nextInt(window - 1, gen);
        if (sort) {
            RandomIndexer.sortSetAndAdjustWindowedTriple(result, i, j, k, z1, z3);
        } else {
            RandomIndexer.setAndAdjustWindowedTriple(result, i, j, k, z1, z3);
        }
        return result;
    }

    private static void adjustTriple(int[] result) {
        if (result[1] >= result[0]) {
            result[1] = result[1] + 1;
            if (result[2] >= result[0]) {
                result[2] = result[2] + 1;
                if (result[2] >= result[1]) {
                    result[2] = result[2] + 1;
                }
            }
        } else if (result[2] >= result[1]) {
            result[2] = result[2] + 1;
            if (result[2] >= result[0]) {
                result[2] = result[2] + 1;
            }
        }
    }

    private static void adjustSortTriple(int[] result) {
        int temp;
        if (result[1] >= result[0]) {
            result[1] = result[1] + 1;
        } else {
            temp = result[0];
            result[0] = result[1];
            result[1] = temp;
        }
        if (result[2] >= result[0]) {
            result[2] = result[2] + 1;
            if (result[2] >= result[1]) {
                result[2] = result[2] + 1;
            } else {
                temp = result[1];
                result[1] = result[2];
                result[2] = temp;
            }
        } else {
            temp = result[2];
            result[2] = result[1];
            result[1] = result[0];
            result[0] = temp;
        }
    }

    private static void setAndAdjustWindowedPair(int[] result, int i, int j, int z1, int z2) {
        if (i < z2) {
            if ((i & 1) == 0) {
                result[0] = i >> 1;
                result[1] = result[0] + 1 + j;
            } else {
                result[1] = i >> 1;
                result[0] = result[1] + 1 + j;
            }
        } else {
            result[0] = (i -= z1) >= (j += z1) ? i + 1 : i;
            result[1] = j;
        }
    }

    private static void setAndAdjustWindowedTriple(int[] result, int i, int j, int k, int z1, int z3) {
        if (k >= j) {
            ++k;
        }
        if (i < z3) {
            int q = i / 3;
            int r = i % 3;
            result[r] = q;
            if (r == 0) {
                result[1] = q + 1 + j;
                result[2] = q + 1 + k;
            } else if (r == 1) {
                result[0] = q + 1 + j;
                result[2] = q + 1 + k;
            } else {
                result[0] = q + 1 + j;
                result[1] = q + 1 + k;
            }
        } else {
            i = i - z3 + z1;
            if ((j += z1) < (k += z1)) {
                if (i >= j && ++i >= k) {
                    // empty if block
                }
            } else if (i >= k && ++i >= j) {
                ++i;
            }
            result[0] = ++i;
            result[1] = j;
            result[2] = k;
        }
    }

    private static void sortSetAndAdjustWindowedTriple(int[] result, int i, int j, int k, int z1, int z3) {
        if (k >= j) {
            ++k;
        } else {
            int t = j;
            j = k;
            k = t;
        }
        if (i < z3) {
            int q;
            result[0] = q = i / 3;
            result[1] = q + 1 + j;
            result[2] = q + 1 + k;
        } else {
            i = i - z3 + z1;
            k += z1;
            if (i >= (j += z1)) {
                result[0] = j;
                if (++i >= k) {
                    result[1] = k;
                    result[2] = ++i;
                } else {
                    result[1] = i;
                    result[2] = k;
                }
            } else {
                result[0] = i;
                result[1] = j;
                result[2] = k;
            }
        }
    }
}

