/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.math.rand;

import java.util.concurrent.ThreadLocalRandom;
import java.util.random.RandomGenerator;

public final class PolarGaussian {
    private static final ThreadLocal<Double> nextG = new ThreadLocal();

    private PolarGaussian() {
    }

    public static double nextGaussian(double sigma) {
        return sigma * PolarGaussian.nextGaussian(ThreadLocalRandom.current());
    }

    public static double nextGaussian(double sigma, RandomGenerator r) {
        return sigma * PolarGaussian.nextGaussian(r);
    }

    public static double nextGaussian() {
        return PolarGaussian.nextGaussian(ThreadLocalRandom.current());
    }

    public static double nextGaussian(RandomGenerator r) {
        Double next = nextG.get();
        if (next != null) {
            nextG.set(null);
            return next;
        }
        double v1 = 0.0;
        double v2 = 0.0;
        double s = 0.0;
        while (s >= 1.0 || s == 0.0) {
            v1 = 2.0 * r.nextDouble() - 1.0;
            v2 = 2.0 * r.nextDouble() - 1.0;
            s = v1 * v1 + v2 * v2;
        }
        double m = StrictMath.sqrt(-2.0 * StrictMath.log(s) / s);
        nextG.set(v2 * m);
        return v1 * m;
    }
}

