/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.math.rand;

import java.util.random.RandomGenerator;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.math.rand.RandomVariates;

public class EnhancedRandomGenerator
implements RandomGenerator {
    private final RandomGenerator generator;

    public EnhancedRandomGenerator() {
        this(RandomGenerator.getDefault());
    }

    public EnhancedRandomGenerator(RandomGenerator generator) {
        this.generator = generator;
    }

    public EnhancedRandomGenerator(String algorithmName) {
        this(RandomGenerator.of(algorithmName));
    }

    public static EnhancedRandomGenerator getDefault() {
        return new EnhancedRandomGenerator();
    }

    public static EnhancedRandomGenerator of(String algorithmName) {
        return new EnhancedRandomGenerator(algorithmName);
    }

    public final boolean[] arrayMask(int n) {
        return RandomIndexer.arrayMask(n, this.generator);
    }

    public final boolean[] arrayMask(int n, int k) {
        return RandomIndexer.arrayMask(n, k, this.generator);
    }

    public final boolean[] arrayMask(int n, double p) {
        return RandomIndexer.arrayMask(n, p, this.generator);
    }

    public final int nextBiasedInt(int bound) {
        return RandomIndexer.nextBiasedInt(bound, this.generator);
    }

    public final int nextBinomial(int n, double p) {
        return RandomVariates.nextBinomial(n, p, this.generator);
    }

    public final double nextCauchy(double scale) {
        return RandomVariates.nextCauchy(scale, this.generator);
    }

    public final double nextCauchy(double median, double scale) {
        return RandomVariates.nextCauchy(median, scale, this.generator);
    }

    public final double nextGaussian(double stddev) {
        return RandomVariates.nextGaussian(stddev, this.generator);
    }

    public final int[] nextIntPair(int n, int[] result) {
        return RandomIndexer.nextIntPair(n, result, this.generator);
    }

    public final int[] nextIntTriple(int n, int[] result) {
        return RandomIndexer.nextIntTriple(n, result, this.generator);
    }

    public final int[] nextIntTriple(int n, int[] result, boolean sort) {
        return RandomIndexer.nextIntTriple(n, result, sort, this.generator);
    }

    public final int[] nextWindowedIntPair(int n, int window, int[] result) {
        return RandomIndexer.nextWindowedIntPair(n, window, result, this.generator);
    }

    public final int[] nextWindowedIntTriple(int n, int window, int[] result) {
        return RandomIndexer.nextWindowedIntTriple(n, window, result, this.generator);
    }

    public final int[] nextWindowedIntTriple(int n, int window, int[] result, boolean sort) {
        return RandomIndexer.nextWindowedIntTriple(n, window, result, sort, this.generator);
    }

    public final int[] sample(int n, double p) {
        return RandomIndexer.sample(n, p, this.generator);
    }

    public final int[] sample(int n, int k, int[] result) {
        return RandomIndexer.sample(n, k, result, this.generator);
    }

    public final int[] sampleInsertion(int n, int k, int[] result) {
        return RandomIndexer.sampleInsertion(n, k, result, this.generator);
    }

    public final int[] samplePool(int n, int k, int[] result) {
        return RandomIndexer.samplePool(n, k, result, this.generator);
    }

    public final int[] sampleReservoir(int n, int k, int[] result) {
        return RandomIndexer.sampleReservoir(n, k, result, this.generator);
    }

    @Override
    public final double nextGaussian() {
        return RandomVariates.nextGaussian(this.generator);
    }

    @Override
    public final double nextGaussian(double mean, double stddev) {
        return mean + RandomVariates.nextGaussian(stddev, this.generator);
    }

    @Override
    public final int nextInt(int bound) {
        return RandomIndexer.nextInt(bound, this.generator);
    }

    @Override
    public final int nextInt(int origin, int bound) {
        return origin + RandomIndexer.nextInt(bound - origin, this.generator);
    }

    @Override
    public final IntStream ints(int randomNumberOrigin, int randomNumberBound) {
        return IntStream.generate(() -> this.nextInt(randomNumberOrigin, randomNumberBound)).sequential();
    }

    @Override
    public final IntStream ints(long streamSize, int randomNumberOrigin, int randomNumberBound) {
        return IntStream.generate(() -> this.nextInt(randomNumberOrigin, randomNumberBound)).sequential().limit(streamSize);
    }

    @Override
    public final DoubleStream doubles() {
        return this.generator.doubles();
    }

    @Override
    public final DoubleStream doubles(double randomNumberOrigin, double randomNumberBound) {
        return this.generator.doubles(randomNumberOrigin, randomNumberBound);
    }

    @Override
    public final DoubleStream doubles(long streamSize) {
        return this.generator.doubles(streamSize);
    }

    @Override
    public final DoubleStream doubles(long streamSize, double randomNumberOrigin, double randomNumberBound) {
        return this.generator.doubles(streamSize, randomNumberOrigin, randomNumberBound);
    }

    @Override
    public final IntStream ints() {
        return this.generator.ints();
    }

    @Override
    public final IntStream ints(long streamSize) {
        return this.generator.ints(streamSize);
    }

    @Override
    public final LongStream longs() {
        return this.generator.longs();
    }

    @Override
    public final LongStream longs(long randomNumberOrigin, long randomNumberBound) {
        return this.generator.longs(randomNumberOrigin, randomNumberBound);
    }

    @Override
    public final LongStream longs(long streamSize) {
        return this.generator.longs(streamSize);
    }

    @Override
    public final LongStream longs(long streamSize, long randomNumberOrigin, long randomNumberBound) {
        return this.generator.longs(streamSize, randomNumberOrigin, randomNumberBound);
    }

    @Override
    public final boolean nextBoolean() {
        return this.generator.nextBoolean();
    }

    @Override
    public final void nextBytes(byte[] bytes) {
        this.generator.nextBytes(bytes);
    }

    @Override
    public final double nextDouble() {
        return this.generator.nextDouble();
    }

    @Override
    public final double nextDouble(double bound) {
        return this.generator.nextDouble(bound);
    }

    @Override
    public final double nextDouble(double origin, double bound) {
        return this.generator.nextDouble(origin, bound);
    }

    @Override
    public final double nextExponential() {
        return this.generator.nextExponential();
    }

    @Override
    public final float nextFloat() {
        return this.generator.nextFloat();
    }

    @Override
    public final float nextFloat(float bound) {
        return this.generator.nextFloat(bound);
    }

    @Override
    public final float nextFloat(float origin, float bound) {
        return this.generator.nextFloat(origin, bound);
    }

    @Override
    public final int nextInt() {
        return this.generator.nextInt();
    }

    @Override
    public final long nextLong() {
        return this.generator.nextLong();
    }

    @Override
    public final long nextLong(long bound) {
        return this.generator.nextLong(bound);
    }

    @Override
    public final long nextLong(long origin, long bound) {
        return this.generator.nextLong(origin, bound);
    }
}

