/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.math.rand;

import java.util.random.RandomGenerator;
import java.util.stream.Stream;
import org.cicirello.math.rand.EnhancedLeapableGenerator;

public class EnhancedArbitrarilyJumpableGenerator
extends EnhancedLeapableGenerator
implements RandomGenerator.ArbitrarilyJumpableGenerator {
    private final RandomGenerator.ArbitrarilyJumpableGenerator generator;

    public EnhancedArbitrarilyJumpableGenerator(RandomGenerator.ArbitrarilyJumpableGenerator generator) {
        super(generator);
        this.generator = generator;
    }

    public EnhancedArbitrarilyJumpableGenerator(String algorithmName) {
        this(RandomGenerator.ArbitrarilyJumpableGenerator.of(algorithmName));
    }

    public static EnhancedArbitrarilyJumpableGenerator of(String algorithmName) {
        return new EnhancedArbitrarilyJumpableGenerator(algorithmName);
    }

    @Override
    public EnhancedArbitrarilyJumpableGenerator copy() {
        return new EnhancedArbitrarilyJumpableGenerator(this.generator.copy());
    }

    @Override
    public final EnhancedArbitrarilyJumpableGenerator copyAndJump(double distance) {
        EnhancedArbitrarilyJumpableGenerator c = this.copy();
        this.jump(distance);
        return c;
    }

    @Override
    public final void jump(double distance) {
        this.generator.jump(distance);
    }

    @Override
    public final void jumpPowerOfTwo(int logDistance) {
        this.generator.jumpPowerOfTwo(logDistance);
    }

    public final Stream<EnhancedArbitrarilyJumpableGenerator> ejumps(double distance) {
        return this.generator.jumps(distance).map(gen -> new EnhancedArbitrarilyJumpableGenerator((RandomGenerator.ArbitrarilyJumpableGenerator)gen));
    }

    public final Stream<EnhancedArbitrarilyJumpableGenerator> ejumps(long streamSize, double distance) {
        return this.generator.jumps(streamSize, distance).map(gen -> new EnhancedArbitrarilyJumpableGenerator((RandomGenerator.ArbitrarilyJumpableGenerator)gen));
    }

    @Override
    public final Stream<RandomGenerator.ArbitrarilyJumpableGenerator> jumps(double distance) {
        return this.generator.jumps(distance).map(gen -> new EnhancedArbitrarilyJumpableGenerator((RandomGenerator.ArbitrarilyJumpableGenerator)gen));
    }

    @Override
    public final Stream<RandomGenerator.ArbitrarilyJumpableGenerator> jumps(long streamSize, double distance) {
        return this.generator.jumps(streamSize, distance).map(gen -> new EnhancedArbitrarilyJumpableGenerator((RandomGenerator.ArbitrarilyJumpableGenerator)gen));
    }
}

