/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.math.rand;

import java.util.random.RandomGenerator;
import java.util.stream.Stream;
import org.cicirello.math.rand.EnhancedRandomGenerator;
import org.cicirello.math.rand.EnhancedStreamableGenerator;

public class EnhancedJumpableGenerator
extends EnhancedStreamableGenerator
implements RandomGenerator.JumpableGenerator {
    private final RandomGenerator.JumpableGenerator generator;

    public EnhancedJumpableGenerator(RandomGenerator.JumpableGenerator generator) {
        super(generator);
        this.generator = generator;
    }

    public EnhancedJumpableGenerator(String algorithmName) {
        this(RandomGenerator.JumpableGenerator.of(algorithmName));
    }

    public static EnhancedJumpableGenerator of(String algorithmName) {
        return new EnhancedJumpableGenerator(algorithmName);
    }

    @Override
    public EnhancedJumpableGenerator copy() {
        return new EnhancedJumpableGenerator(this.generator.copy());
    }

    @Override
    public final EnhancedJumpableGenerator copyAndJump() {
        EnhancedJumpableGenerator c = this.copy();
        this.jump();
        return c;
    }

    @Override
    public final void jump() {
        this.generator.jump();
    }

    @Override
    public final double jumpDistance() {
        return this.generator.jumpDistance();
    }

    public final Stream<EnhancedRandomGenerator> ejumps() {
        return this.generator.jumps().map(gen -> new EnhancedRandomGenerator((RandomGenerator)gen));
    }

    public final Stream<EnhancedRandomGenerator> ejumps(long streamSize) {
        return this.generator.jumps(streamSize).map(gen -> new EnhancedRandomGenerator((RandomGenerator)gen));
    }

    @Override
    public final Stream<RandomGenerator> jumps() {
        return this.generator.jumps().map(gen -> new EnhancedRandomGenerator((RandomGenerator)gen));
    }

    @Override
    public final Stream<RandomGenerator> jumps(long streamSize) {
        return this.generator.jumps(streamSize).map(gen -> new EnhancedRandomGenerator((RandomGenerator)gen));
    }
}

