/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.math.la;

public final class MatrixOps {
    private MatrixOps() {
    }

    public static int[][] transposeSquareMatrixInline(int[][] matrix) {
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = i + 1; j < matrix[i].length; ++j) {
                int temp = matrix[i][j];
                matrix[i][j] = matrix[j][i];
                matrix[j][i] = temp;
            }
        }
        return matrix;
    }

    public static double[][] transposeSquareMatrixInline(double[][] matrix) {
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = i + 1; j < matrix[i].length; ++j) {
                double temp = matrix[i][j];
                matrix[i][j] = matrix[j][i];
                matrix[j][i] = temp;
            }
        }
        return matrix;
    }

    public static int[][] sum(int[][] A, int[][] B, int[][] C) {
        if (C == null) {
            C = A.length > 0 ? new int[A.length][A[0].length] : new int[0][0];
        }
        for (int i = 0; i < C.length; ++i) {
            for (int j = 0; j < C[i].length; ++j) {
                C[i][j] = A[i][j] + B[i][j];
            }
        }
        return C;
    }

    public static double[][] sum(double[][] A, double[][] B, double[][] C) {
        if (C == null) {
            C = A.length > 0 ? new double[A.length][A[0].length] : new double[0][0];
        }
        for (int i = 0; i < C.length; ++i) {
            for (int j = 0; j < C[i].length; ++j) {
                C[i][j] = A[i][j] + B[i][j];
            }
        }
        return C;
    }

    public static int[][] sum(int[][] A, int[][] B) {
        return MatrixOps.sum(A, B, null);
    }

    public static double[][] sum(double[][] A, double[][] B) {
        return MatrixOps.sum(A, B, null);
    }

    public static int[][] difference(int[][] A, int[][] B, int[][] C) {
        if (C == null) {
            C = A.length > 0 ? new int[A.length][A[0].length] : new int[0][0];
        }
        for (int i = 0; i < C.length; ++i) {
            for (int j = 0; j < C[i].length; ++j) {
                C[i][j] = A[i][j] - B[i][j];
            }
        }
        return C;
    }

    public static double[][] difference(double[][] A, double[][] B, double[][] C) {
        if (C == null) {
            C = A.length > 0 ? new double[A.length][A[0].length] : new double[0][0];
        }
        for (int i = 0; i < C.length; ++i) {
            for (int j = 0; j < C[i].length; ++j) {
                C[i][j] = A[i][j] - B[i][j];
            }
        }
        return C;
    }

    public static int[][] difference(int[][] A, int[][] B) {
        return MatrixOps.difference(A, B, null);
    }

    public static double[][] difference(double[][] A, double[][] B) {
        return MatrixOps.difference(A, B, null);
    }

    public static int[][] product(int[][] A, int[][] B, int[][] C) {
        if (C == null) {
            C = B.length > 0 ? new int[A.length][B[0].length] : new int[0][0];
        }
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < B[0].length; ++j) {
                C[i][j] = 0;
                for (int k = 0; k < B.length; ++k) {
                    C[i][j] = C[i][j] + A[i][k] * B[k][j];
                }
            }
        }
        return C;
    }

    public static double[][] product(double[][] A, double[][] B, double[][] C) {
        if (C == null) {
            C = B.length > 0 ? new double[A.length][B[0].length] : new double[0][0];
        }
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < B[0].length; ++j) {
                C[i][j] = 0.0;
                for (int k = 0; k < B.length; ++k) {
                    C[i][j] = C[i][j] + A[i][k] * B[k][j];
                }
            }
        }
        return C;
    }

    public static int[][] product(int[][] A, int[][] B) {
        return MatrixOps.product(A, B, null);
    }

    public static double[][] product(double[][] A, double[][] B) {
        return MatrixOps.product(A, B, null);
    }
}

