/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.math.rand;

import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import java.util.random.RandomGenerator;
import org.cicirello.math.rand.RandomSampler;
import org.cicirello.util.ArrayMinimumLengthEnforcer;

public final class RandomIndexer {
    private RandomIndexer() {
    }

    public static int nextInt(int bound) {
        return RandomIndexer.nextInt(bound, ThreadLocalRandom.current());
    }

    public static int nextInt(int origin, int bound) {
        return RandomIndexer.nextInt(origin, bound, ThreadLocalRandom.current());
    }

    public static int nextInt(int origin, int bound, RandomGenerator gen) {
        return origin + RandomIndexer.nextInt(bound - origin, gen);
    }

    public static int nextInt(int bound, RandomGenerator gen) {
        if (bound < 1) {
            throw new IllegalArgumentException("bound must be positive");
        }
        long product = (long)(gen.nextInt() & Integer.MAX_VALUE) * (long)bound;
        int low31 = (int)product & Integer.MAX_VALUE;
        if (low31 < bound) {
            int threshold = (Integer.MIN_VALUE - bound) % bound;
            while (low31 < threshold) {
                product = (long)(gen.nextInt() & Integer.MAX_VALUE) * (long)bound;
                low31 = (int)product & Integer.MAX_VALUE;
            }
        }
        return (int)(product >> 31);
    }

    public static int nextBiasedInt(int bound) {
        if (bound < 1) {
            throw new IllegalArgumentException("bound must be positive");
        }
        return (int)((long)(ThreadLocalRandom.current().nextInt() & Integer.MAX_VALUE) * (long)bound >> 31);
    }

    public static int nextBiasedInt(int origin, int bound) {
        return origin + RandomIndexer.nextBiasedInt(bound - origin);
    }

    public static int nextBiasedInt(int origin, int bound, RandomGenerator gen) {
        return origin + RandomIndexer.nextBiasedInt(bound - origin, gen);
    }

    public static int nextBiasedInt(int bound, RandomGenerator gen) {
        if (bound < 1) {
            throw new IllegalArgumentException("bound must be positive");
        }
        return (int)((long)(gen.nextInt() & Integer.MAX_VALUE) * (long)bound >> 31);
    }

    public static int[] nextIntPair(int n, int[] result) {
        return RandomIndexer.nextIntPair(n, result, ThreadLocalRandom.current());
    }

    public static int[] nextIntPair(int n, int[] result, RandomGenerator gen) {
        result = ArrayMinimumLengthEnforcer.enforce((int[])result, (int)2);
        result[0] = RandomIndexer.nextInt(n, gen);
        result[1] = RandomIndexer.nextInt(n - 1, gen);
        if (result[1] == result[0]) {
            result[1] = n - 1;
        }
        return result;
    }

    public static int[] nextIntTriple(int n, int[] result) {
        return RandomIndexer.nextIntTriple(n, result, ThreadLocalRandom.current());
    }

    public static int[] nextIntTriple(int n, int[] result, boolean sort) {
        return RandomIndexer.nextIntTriple(n, result, sort, ThreadLocalRandom.current());
    }

    public static int[] nextIntTriple(int n, int[] result, boolean sort, RandomGenerator gen) {
        result = ArrayMinimumLengthEnforcer.enforce((int[])result, (int)3);
        result[0] = RandomIndexer.nextInt(n, gen);
        result[1] = RandomIndexer.nextInt(n - 1, gen);
        result[2] = RandomIndexer.nextInt(n - 2, gen);
        if (sort) {
            RandomIndexer.adjustSortTriple(result);
        } else {
            RandomIndexer.adjustTriple(result);
        }
        return result;
    }

    public static int[] nextIntTriple(int n, int[] result, RandomGenerator gen) {
        result = ArrayMinimumLengthEnforcer.enforce((int[])result, (int)3);
        result[0] = RandomIndexer.nextInt(n, gen);
        result[1] = RandomIndexer.nextInt(n - 1, gen);
        result[2] = RandomIndexer.nextInt(n - 2, gen);
        RandomIndexer.adjustTriple(result);
        return result;
    }

    public static boolean[] arrayMask(int n) {
        return RandomIndexer.arrayMask(n, ThreadLocalRandom.current());
    }

    public static boolean[] arrayMask(int n, RandomGenerator gen) {
        boolean[] result = new boolean[n];
        for (int i = 0; i < n; ++i) {
            result[i] = gen.nextBoolean();
        }
        return result;
    }

    public static boolean[] arrayMask(int n, int k) {
        return RandomIndexer.arrayMask(n, k, (RandomGenerator)ThreadLocalRandom.current());
    }

    public static boolean[] arrayMask(int n, int k, RandomGenerator gen) {
        boolean[] result = new boolean[n];
        if (k >= n) {
            Arrays.fill(result, true);
        } else {
            int[] indexes = RandomSampler.sample(n, k, null, gen);
            for (int i = 0; i < k; ++i) {
                result[indexes[i]] = true;
            }
        }
        return result;
    }

    public static boolean[] arrayMask(int n, double p) {
        return RandomIndexer.arrayMask(n, p, (RandomGenerator)ThreadLocalRandom.current());
    }

    public static boolean[] arrayMask(int n, double p, RandomGenerator gen) {
        boolean[] result = new boolean[n];
        if (p >= 1.0) {
            Arrays.fill(result, true);
        } else {
            int[] s = RandomSampler.sample(n, p, gen);
            for (int i = 0; i < s.length; ++i) {
                result[s[i]] = true;
            }
        }
        return result;
    }

    public static int[] nextWindowedIntPair(int n, int window, int[] result) {
        return RandomIndexer.nextWindowedIntPair(n, window, result, ThreadLocalRandom.current());
    }

    public static int[] nextWindowedIntPair(int n, int window, int[] result, RandomGenerator gen) {
        if (window >= n - 1) {
            return RandomIndexer.nextIntPair(n, result, gen);
        }
        result = ArrayMinimumLengthEnforcer.enforce((int[])result, (int)2);
        int z1 = n - window;
        int z2 = z1 + z1;
        int i = RandomIndexer.nextInt(z2 + window - 1, gen);
        int j = RandomIndexer.nextInt(window, gen);
        RandomIndexer.setAndAdjustWindowedPair(result, i, j, z1, z2);
        return result;
    }

    public static int[] nextWindowedIntTriple(int n, int window, int[] result) {
        return RandomIndexer.nextWindowedIntTriple(n, window, result, ThreadLocalRandom.current());
    }

    public static int[] nextWindowedIntTriple(int n, int window, int[] result, boolean sort) {
        return RandomIndexer.nextWindowedIntTriple(n, window, result, sort, ThreadLocalRandom.current());
    }

    public static int[] nextWindowedIntTriple(int n, int window, int[] result, RandomGenerator gen) {
        if (window >= n - 1) {
            return RandomIndexer.nextIntTriple(n, result, gen);
        }
        result = ArrayMinimumLengthEnforcer.enforce((int[])result, (int)3);
        int z1 = n - window;
        int z3 = 3 * z1;
        int i = RandomIndexer.nextInt(z3 + window - 2, gen);
        int j = RandomIndexer.nextInt(window, gen);
        int k = RandomIndexer.nextInt(window - 1, gen);
        RandomIndexer.setAndAdjustWindowedTriple(result, i, j, k, z1, z3);
        return result;
    }

    public static int[] nextWindowedIntTriple(int n, int window, int[] result, boolean sort, RandomGenerator gen) {
        if (window >= n - 1) {
            return RandomIndexer.nextIntTriple(n, result, sort, gen);
        }
        result = ArrayMinimumLengthEnforcer.enforce((int[])result, (int)3);
        int z1 = n - window;
        int z3 = 3 * z1;
        int i = RandomIndexer.nextInt(z3 + window - 2, gen);
        int j = RandomIndexer.nextInt(window, gen);
        int k = RandomIndexer.nextInt(window - 1, gen);
        if (sort) {
            RandomIndexer.sortSetAndAdjustWindowedTriple(result, i, j, k, z1, z3);
        } else {
            RandomIndexer.setAndAdjustWindowedTriple(result, i, j, k, z1, z3);
        }
        return result;
    }

    private static boolean adjustIfNecessary(int[] result, int upper, int lower) {
        if (result[upper] >= result[lower]) {
            int n = upper;
            result[n] = result[n] + 1;
            return true;
        }
        return false;
    }

    private static void adjustTriple(int[] result) {
        if (RandomIndexer.adjustIfNecessary(result, 1, 0)) {
            RandomIndexer.adjustIfNecessary(result, 2, 0);
            RandomIndexer.adjustIfNecessary(result, 2, 1);
        } else {
            RandomIndexer.adjustIfNecessary(result, 2, 1);
            RandomIndexer.adjustIfNecessary(result, 2, 0);
        }
    }

    private static void adjustSortTriple(int[] result) {
        int temp;
        if (!RandomIndexer.adjustIfNecessary(result, 1, 0)) {
            temp = result[0];
            result[0] = result[1];
            result[1] = temp;
        }
        if (RandomIndexer.adjustIfNecessary(result, 2, 0)) {
            if (!RandomIndexer.adjustIfNecessary(result, 2, 1)) {
                temp = result[1];
                result[1] = result[2];
                result[2] = temp;
            }
        } else {
            temp = result[2];
            result[2] = result[1];
            result[1] = result[0];
            result[0] = temp;
        }
    }

    private static void setAndAdjustWindowedPair(int[] result, int i, int j, int z1, int z2) {
        if (i < z2) {
            int x = i & 1;
            result[x] = i >> 1;
            result[x ^ 1] = result[x] + 1 + j;
        } else {
            result[0] = (i -= z1) >= (j += z1) ? i + 1 : i;
            result[1] = j;
        }
    }

    private static int iAdjustmentWindowedTriple(int i, int lower, int higher) {
        if (i >= lower && ++i >= higher) {
            ++i;
        }
        return i;
    }

    private static void setAndAdjustWindowedTriple(int[] result, int i, int j, int k, int z1, int z3) {
        if (k >= j) {
            ++k;
        }
        if (i < z3) {
            int q = i / 3;
            int r = i % 3;
            result[r] = q;
            if (r < 2) {
                result[r ^ 1] = q + 1 + j;
                result[2] = q + 1 + k;
            } else {
                result[0] = q + 1 + j;
                result[1] = q + 1 + k;
            }
        } else {
            i = i - z3 + z1;
            result[0] = i = (j += z1) < (k += z1) ? RandomIndexer.iAdjustmentWindowedTriple(i, j, k) : RandomIndexer.iAdjustmentWindowedTriple(i, k, j);
            result[1] = j;
            result[2] = k;
        }
    }

    private static void sortSetAndAdjustWindowedTriple(int[] result, int i, int j, int k, int z1, int z3) {
        if (k >= j) {
            ++k;
        } else {
            int t = j;
            j = k;
            k = t;
        }
        if (i < z3) {
            int q;
            result[0] = q = i / 3;
            result[1] = q + 1 + j;
            result[2] = q + 1 + k;
        } else {
            i = i - z3 + z1;
            k += z1;
            if (i >= (j += z1)) {
                result[0] = j;
                if (++i >= k) {
                    result[1] = k;
                    result[2] = ++i;
                } else {
                    result[1] = i;
                    result[2] = k;
                }
            } else {
                result[0] = i;
                result[1] = j;
                result[2] = k;
            }
        }
    }
}

