/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.ds;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import org.cicirello.ds.Prioritizer;
import org.cicirello.ds.PriorityQueueNode;

final class FibonacciHeapDoubleNode<E> {
    PriorityQueueNode.Double<E> e;
    private FibonacciHeapDoubleNode<E> parent;
    private FibonacciHeapDoubleNode<E> child;
    private FibonacciHeapDoubleNode<E> left;
    private FibonacciHeapDoubleNode<E> right;
    private int degree;
    private boolean mark;

    public FibonacciHeapDoubleNode(PriorityQueueNode.Double<E> e) {
        this.e = e;
        this.singletonList();
    }

    public FibonacciHeapDoubleNode(PriorityQueueNode.Double<E> e, FibonacciHeapDoubleNode<E> list) {
        this.e = e;
        this.insertInto(list);
    }

    private FibonacciHeapDoubleNode(FibonacciHeapDoubleNode<E> other) {
        this.e = other.e.copy();
        this.degree = other.degree;
        this.mark = other.mark;
    }

    private FibonacciHeapDoubleNode(FibonacciHeapDoubleNode<E> other, FibonacciHeapDoubleNode<E> toTheLeft) {
        this(other);
        this.left = toTheLeft;
    }

    final FibonacciHeapDoubleNode<E> copy() {
        return this.copyList(this, null);
    }

    private FibonacciHeapDoubleNode<E> copyList(FibonacciHeapDoubleNode<E> x, FibonacciHeapDoubleNode<E> p) {
        FibonacciHeapDoubleNode<E> y = new FibonacciHeapDoubleNode<E>(x);
        y.parent = p;
        if (x.child != null) {
            y.child = this.copyList(x.child, y);
        }
        FibonacciHeapDoubleNode<E> rightOf = y;
        FibonacciHeapDoubleNode<E> next = x.right;
        while (next != x) {
            rightOf.right = new FibonacciHeapDoubleNode<E>(next, rightOf);
            rightOf.right.parent = p;
            if (next.child != null) {
                rightOf.right.child = this.copyList(next.child, rightOf.right);
            }
            next = next.right;
            rightOf = rightOf.right;
        }
        rightOf.right = y;
        y.left = rightOf;
        return y;
    }

    final FibonacciHeapDoubleNode<E> parent() {
        return this.parent;
    }

    final void singletonList() {
        this.left = this.right = this;
    }

    final void insertInto(FibonacciHeapDoubleNode<E> list) {
        this.right = list.right;
        this.left = list;
        list.right = list.right.left = this;
    }

    final void insertListInto(FibonacciHeapDoubleNode<E> list) {
        list.right.left = this.left;
        this.left.right = list.right;
        list.right = this;
        this.left = list;
    }

    final void clearParentReferences() {
        FibonacciHeapDoubleNode<E> next = this;
        while (next.parent != null) {
            next.parent = null;
            next = next.right;
        }
    }

    final void cascadingCut(FibonacciHeapDoubleNode<E> root) {
        FibonacciHeapDoubleNode<E> z = this.parent;
        if (z != null) {
            if (!this.mark) {
                this.mark = true;
            } else {
                this.cut(z, root);
                z.cascadingCut(root);
            }
        }
    }

    final void cut(FibonacciHeapDoubleNode<E> y, FibonacciHeapDoubleNode<E> root) {
        if (y.degree > 1) {
            y.child = this.right;
            this.left.right = this.right;
            this.right.left = this.left;
            --y.degree;
        } else {
            y.child = null;
            y.degree = 0;
        }
        this.insertInto(root);
        this.parent = null;
        this.mark = false;
    }

    final FibonacciHeapDoubleNode<E> find(Object element) {
        NodeIterator iter = new NodeIterator(this);
        while (iter.hasNext()) {
            Object n = iter.next();
            if (!((FibonacciHeapDoubleNode)n).e.element.equals(element)) continue;
            return n;
        }
        return null;
    }

    static <T> FibonacciHeapDoubleNode<T> find(FibonacciHeapDoubleNode<T> start, Object element) {
        return start == null ? null : start.find(element);
    }

    final FibonacciHeapDoubleNode<E> removeSelf() {
        FibonacciHeapDoubleNode<E> min;
        if (this.child != null) {
            this.child.clearParentReferences();
            this.child.insertListInto(this);
        }
        this.left.right = min = this.right;
        min.left = this.left;
        return min;
    }

    static final class NodeIterator<E2>
    implements Iterator<FibonacciHeapDoubleNode<E2>> {
        private final Deque<FibonacciHeapDoubleNode<E2>> stack = new ArrayDeque<FibonacciHeapDoubleNode<E2>>();

        public NodeIterator(FibonacciHeapDoubleNode<E2> root) {
            if (root != null) {
                this.stack.push(root);
                FibonacciHeapDoubleNode next = root.right;
                while (next != root) {
                    this.stack.push(next);
                    next = next.right;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return !this.stack.isEmpty();
        }

        @Override
        public FibonacciHeapDoubleNode<E2> next() {
            FibonacciHeapDoubleNode<E2> current = this.stack.pop();
            if (current.degree > 0) {
                this.stack.push(current.child);
                FibonacciHeapDoubleNode next = current.child.right;
                for (int i = 1; i < current.degree; ++i) {
                    this.stack.push(next);
                    next = next.right;
                }
            }
            return current;
        }
    }

    static final class FibonacciHeapDoubleIterator<E2>
    implements Iterator<PriorityQueueNode.Double<E2>> {
        private final NodeIterator<E2> iter;

        public FibonacciHeapDoubleIterator(FibonacciHeapDoubleNode<E2> root) {
            this.iter = new NodeIterator<E2>(root);
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public PriorityQueueNode.Double<E2> next() {
            return ((FibonacciHeapDoubleNode)this.iter.next()).e;
        }
    }

    static final class Consolidator<E2> {
        private final FibonacciHeapDoubleNode<E2>[] rootsByDegrees;
        private static final double INV_LOG_GOLDEN_RATIO = 2.0780869212350273;
        private final Prioritizer compare;

        Consolidator(Prioritizer compare) {
            this.compare = compare;
            this.rootsByDegrees = this.nodeArrayAllocate(45);
        }

        private FibonacciHeapDoubleNode<E2>[] nodeArrayAllocate(int n) {
            FibonacciHeapDoubleNode[] array = new FibonacciHeapDoubleNode[n];
            return array;
        }

        final FibonacciHeapDoubleNode<E2> consolidate(FibonacciHeapDoubleNode<E2> min, int size) {
            int dn = (int)(Math.log(size) * 2.0780869212350273);
            FibonacciHeapDoubleNode<Object> w = min;
            w.left.right = null;
            do {
                FibonacciHeapDoubleNode<E2> x = w;
                w = w.right;
                x.right = null;
                x.left = null;
                int d = x.degree;
                while (this.rootsByDegrees[d] != null) {
                    FibonacciHeapDoubleNode<E2> y = this.rootsByDegrees[d];
                    if (this.compare.comesBefore(y.e.value, x.e.value)) {
                        FibonacciHeapDoubleNode<E2> temp = x;
                        x = y;
                        y = temp;
                    }
                    this.fibHeapLink(y, x);
                    this.rootsByDegrees[d] = null;
                    ++d;
                }
                this.rootsByDegrees[d] = x;
            } while (w != null);
            min = null;
            for (int i = 0; i <= dn; ++i) {
                if (this.rootsByDegrees[i] == null) continue;
                if (min == null) {
                    this.rootsByDegrees[i].singletonList();
                    min = this.rootsByDegrees[i];
                } else {
                    this.rootsByDegrees[i].insertInto(min);
                    if (this.compare.comesBefore(this.rootsByDegrees[i].e.value, min.e.value)) {
                        min = this.rootsByDegrees[i];
                    }
                }
                this.rootsByDegrees[i] = null;
            }
            return min;
        }

        private void fibHeapLink(FibonacciHeapDoubleNode<E2> y, FibonacciHeapDoubleNode<E2> x) {
            if (x.degree > 0) {
                y.insertInto(x.child);
                y.parent = x;
                ++x.degree;
            } else {
                y.singletonList();
                x.child = y;
                y.parent = x;
                x.degree = 1;
            }
            y.mark = false;
        }
    }
}

