/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.math.rand;

import java.util.SplittableRandom;
import java.util.random.RandomGenerator;
import java.util.stream.Stream;
import org.cicirello.math.rand.EnhancedRandomGenerator;

public class EnhancedStreamableGenerator
extends EnhancedRandomGenerator
implements RandomGenerator.StreamableGenerator {
    private final RandomGenerator.StreamableGenerator generator;

    public EnhancedStreamableGenerator() {
        this(new SplittableRandom());
    }

    public EnhancedStreamableGenerator(long seed) {
        this(new SplittableRandom(seed));
    }

    public EnhancedStreamableGenerator(RandomGenerator.StreamableGenerator generator) {
        super(generator);
        this.generator = generator;
    }

    public EnhancedStreamableGenerator(String algorithmName) {
        this(RandomGenerator.StreamableGenerator.of(algorithmName));
    }

    public static EnhancedStreamableGenerator of(String algorithmName) {
        return new EnhancedStreamableGenerator(algorithmName);
    }

    public final Stream<EnhancedRandomGenerator> erngs() {
        return this.generator.rngs().map(gen -> new EnhancedRandomGenerator((RandomGenerator)gen));
    }

    public final Stream<EnhancedRandomGenerator> erngs(long streamSize) {
        return this.generator.rngs(streamSize).map(gen -> new EnhancedRandomGenerator((RandomGenerator)gen));
    }

    @Override
    public final Stream<RandomGenerator> rngs() {
        return this.generator.rngs().map(gen -> new EnhancedRandomGenerator((RandomGenerator)gen));
    }

    @Override
    public final Stream<RandomGenerator> rngs(long streamSize) {
        return this.generator.rngs(streamSize).map(gen -> new EnhancedRandomGenerator((RandomGenerator)gen));
    }
}

