/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.ds;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.cicirello.ds.FibonacciHeapDoubleNode;
import org.cicirello.ds.MaxOrder;
import org.cicirello.ds.MergeablePriorityQueueDouble;
import org.cicirello.ds.MinOrder;
import org.cicirello.ds.Prioritizer;
import org.cicirello.ds.PriorityQueueNode;
import org.cicirello.util.Copyable;

public final class FibonacciHeapDouble<E>
implements MergeablePriorityQueueDouble<E, FibonacciHeapDouble<E>>,
Copyable<FibonacciHeapDouble<E>> {
    private final Prioritizer compare;
    private final double extreme;
    private int size;
    private FibonacciHeapDoubleNode<E> min;
    private final FibonacciHeapDoubleNode.Consolidator<E> consolidator;
    private HashMap<E, FibonacciHeapDoubleNode<E>> index;

    private FibonacciHeapDouble(Prioritizer compare) {
        this.compare = compare;
        this.extreme = compare.comesBefore(0, 1) ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        this.consolidator = new FibonacciHeapDoubleNode.Consolidator(compare);
        this.index = new HashMap();
    }

    private FibonacciHeapDouble(Collection<PriorityQueueNode.Double<E>> initialElements, Prioritizer compare) {
        this(compare);
        for (PriorityQueueNode.Double<E> element : initialElements) {
            if (this.offer(element)) continue;
            throw new IllegalArgumentException("initialElements contains duplicates");
        }
    }

    private FibonacciHeapDouble(FibonacciHeapDouble<E> other) {
        this(other.compare);
        this.size = other.size;
        this.min = other.min != null ? other.min.copy() : null;
        this.index = new HashMap();
        FibonacciHeapDoubleNode.NodeIterator<E> iter = new FibonacciHeapDoubleNode.NodeIterator<E>(this.min);
        while (iter.hasNext()) {
            Object node = iter.next();
            this.index.put((E)((FibonacciHeapDoubleNode)node).e.element, (FibonacciHeapDoubleNode<E>)node);
        }
    }

    @Override
    public FibonacciHeapDouble<E> copy() {
        return new FibonacciHeapDouble<E>(this);
    }

    public static <E> FibonacciHeapDouble<E> createMinHeap() {
        return new FibonacciHeapDouble<E>(new MinOrder());
    }

    public static <E> FibonacciHeapDouble<E> createMinHeap(Collection<PriorityQueueNode.Double<E>> initialElements) {
        return new FibonacciHeapDouble<E>(initialElements, new MinOrder());
    }

    public static <E> FibonacciHeapDouble<E> createMaxHeap() {
        return new FibonacciHeapDouble<E>(new MaxOrder());
    }

    public static <E> FibonacciHeapDouble<E> createMaxHeap(Collection<PriorityQueueNode.Double<E>> initialElements) {
        return new FibonacciHeapDouble<E>(initialElements, new MaxOrder());
    }

    @Override
    public boolean change(E element, double priority) {
        FibonacciHeapDoubleNode<E> node = this.index.get(element);
        if (node != null) {
            if (this.compare.comesBefore(priority, node.e.value)) {
                this.internalPromote(node, priority);
                return true;
            }
            if (this.compare.comesBefore(node.e.value, priority)) {
                this.internalDemote(node, priority);
                return true;
            }
            return false;
        }
        return this.offer(element, priority);
    }

    @Override
    public void clear() {
        this.size = 0;
        this.min = null;
        this.index = new HashMap();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof PriorityQueueNode.Double) {
            PriorityQueueNode.Double pair = (PriorityQueueNode.Double)o;
            return this.index.containsKey(pair.element);
        }
        return this.index.containsKey(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (o instanceof PriorityQueueNode.Double) {
                PriorityQueueNode.Double pair = (PriorityQueueNode.Double)o;
                if (this.index.containsKey(pair.element)) continue;
                return false;
            }
            if (this.index.containsKey(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean demote(E element, double priority) {
        FibonacciHeapDoubleNode<E> node = this.index.get(element);
        if (node != null && this.compare.comesBefore(node.e.value, priority)) {
            this.internalDemote(node, priority);
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof FibonacciHeapDouble) {
            FibonacciHeapDouble casted = (FibonacciHeapDouble)other;
            if (this.size != casted.size) {
                return false;
            }
            if (this.compare.comesBefore(0, 1) != casted.compare.comesBefore(0, 1)) {
                return false;
            }
            Iterator<PriorityQueueNode.Double<E>> iter = this.iterator();
            Iterator<PriorityQueueNode.Double<E>> otherIter = casted.iterator();
            while (iter.hasNext()) {
                if (iter.next().equals(otherIter.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (PriorityQueueNode.Double<E> e : this) {
            h = 31 * h + Double.hashCode(e.value);
            h = 31 * h + e.element.hashCode();
        }
        return h;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<PriorityQueueNode.Double<E>> iterator() {
        return new FibonacciHeapDoubleNode.FibonacciHeapDoubleIterator<E>(this.min);
    }

    @Override
    public boolean merge(FibonacciHeapDouble<E> other) {
        if (this.compare.comesBefore(0, 1) != other.compare.comesBefore(0, 1)) {
            throw new IllegalArgumentException("this and other follow different priority-order");
        }
        if (other.size > 0) {
            this.index.putAll(other.index);
            other.min.insertListInto(this.min);
            if (this.compare.comesBefore(other.min.e.value, this.min.e.value)) {
                this.min = other.min;
            }
            this.size += other.size;
            other.clear();
            return true;
        }
        return false;
    }

    @Override
    public boolean offer(E element, double priority) {
        if (this.index.containsKey(element)) {
            return false;
        }
        this.internalOffer(new PriorityQueueNode.Double<E>(element, priority));
        return true;
    }

    @Override
    public boolean offer(PriorityQueueNode.Double<E> pair) {
        if (this.index.containsKey(pair.element)) {
            return false;
        }
        this.internalOffer((PriorityQueueNode.Double<E>)pair.copy());
        return true;
    }

    @Override
    public E peekElement() {
        return (E)(this.min != null ? this.min.e.element : null);
    }

    @Override
    public PriorityQueueNode.Double<E> peek() {
        return this.min != null ? this.min.e : null;
    }

    @Override
    public double peekPriority() {
        return this.min != null ? this.min.e.value : this.extreme;
    }

    @Override
    public double peekPriority(E element) {
        FibonacciHeapDoubleNode<E> node = this.index.get(element);
        return node != null ? node.e.value : this.extreme;
    }

    @Override
    public E pollElement() {
        Object min = this.poll();
        return (E)(min != null ? ((PriorityQueueNode.Double)min).element : null);
    }

    @Override
    public PriorityQueueNode.Double<E> poll() {
        PriorityQueueNode.Double result = null;
        if (this.size == 1) {
            PriorityQueueNode.Double pair = this.min.e;
            this.min = null;
            this.size = 0;
            result = pair;
            this.index.remove(result.element);
        } else if (this.size > 1) {
            FibonacciHeapDoubleNode<E> z = this.min;
            this.min = this.min.removeSelf();
            this.min = this.consolidator.consolidate(this.min, this.size);
            --this.size;
            result = z.e;
            this.index.remove(result.element);
        }
        return result;
    }

    @Override
    public boolean promote(E element, double priority) {
        FibonacciHeapDoubleNode<E> node = this.index.get(element);
        if (node != null && this.compare.comesBefore(priority, node.e.value)) {
            this.internalPromote(node, priority);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        FibonacciHeapDoubleNode<E> node = null;
        if (o instanceof PriorityQueueNode.Double) {
            PriorityQueueNode.Double pair = (PriorityQueueNode.Double)o;
            node = this.index.get(pair.element);
        } else {
            node = this.index.get(o);
        }
        if (node == null) {
            return false;
        }
        this.internalPromote(node, this.compare.comesBefore(this.min.e.value - 1.0, this.min.e.value) ? this.min.e.value - 1.0 : this.min.e.value + 1.0);
        this.poll();
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        HashSet<Object> discardThese = PriorityQueueNode.Double.toSet(c);
        ArrayList<PriorityQueueNode.Double<E>> keepList = new ArrayList<PriorityQueueNode.Double<E>>();
        for (PriorityQueueNode.Double<E> e : this) {
            if (discardThese.contains(e.element)) continue;
            keepList.add(e);
        }
        if (keepList.size() < this.size) {
            this.clear();
            for (PriorityQueueNode.Double<E> e : keepList) {
                this.internalOffer(e);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        HashSet<Object> keepThese = PriorityQueueNode.Double.toSet(c);
        ArrayList<PriorityQueueNode.Double<E>> keepList = new ArrayList<PriorityQueueNode.Double<E>>(keepThese.size());
        for (PriorityQueueNode.Double<E> e : this) {
            if (!keepThese.contains(e.element)) continue;
            keepList.add(e);
        }
        if (keepList.size() < this.size) {
            this.clear();
            for (PriorityQueueNode.Double<E> e : keepList) {
                this.internalOffer(e);
            }
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size];
        int i = 0;
        Iterator<PriorityQueueNode.Double<E>> iterator = this.iterator();
        while (iterator.hasNext()) {
            PriorityQueueNode.Double<E> e;
            array[i] = e = iterator.next();
            ++i;
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        T[] result = array.length >= this.size ? array : (Object[])Array.newInstance(array.getClass().getComponentType(), this.size);
        int i = 0;
        Iterator<PriorityQueueNode.Double<E>> iterator = this.iterator();
        while (iterator.hasNext()) {
            PriorityQueueNode.Double<E> e;
            PriorityQueueNode.Double<E> nextElement = e = iterator.next();
            result[i] = nextElement;
            ++i;
        }
        if (result.length > this.size) {
            result[this.size] = null;
        }
        return result;
    }

    private void internalOffer(PriorityQueueNode.Double<E> pair) {
        if (this.min == null) {
            this.min = new FibonacciHeapDoubleNode<E>(pair);
            this.size = 1;
            this.index.put(pair.element, this.min);
        } else {
            FibonacciHeapDoubleNode<E> added = new FibonacciHeapDoubleNode<E>(pair, this.min);
            if (this.compare.comesBefore(pair.value, this.min.e.value)) {
                this.min = added;
            }
            ++this.size;
            this.index.put(pair.element, added);
        }
    }

    private void internalPromote(FibonacciHeapDoubleNode<E> x, double priority) {
        x.e.value = priority;
        FibonacciHeapDoubleNode<E> y = x.parent();
        if (y != null && this.compare.comesBefore(priority, y.e.value)) {
            x.cut(y, this.min);
            y.cascadingCut(this.min);
        }
        if (this.compare.comesBefore(priority, this.min.e.value)) {
            this.min = x;
        }
    }

    private void internalDemote(FibonacciHeapDoubleNode<E> x, double priority) {
        this.internalPromote(x, this.compare.comesBefore(this.min.e.value - 1.0, this.min.e.value) ? this.min.e.value - 1.0 : this.min.e.value + 1.0);
        this.poll();
        x.e.value = priority;
        this.internalOffer(x.e);
    }
}

