/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.ds;

import java.util.Arrays;
import org.cicirello.ds.IntPriorityQueue;
import org.cicirello.util.Copyable;

public class IntBinaryHeap
implements IntPriorityQueue,
Copyable<IntBinaryHeap> {
    private final int[] heap;
    private final int[] index;
    private final int[] value;
    private final boolean[] in;
    private int size;

    private IntBinaryHeap(int n) {
        this.heap = new int[n];
        this.index = new int[n];
        this.value = new int[n];
        this.in = new boolean[n];
    }

    private IntBinaryHeap(IntBinaryHeap other) {
        this.heap = (int[])other.heap.clone();
        this.index = (int[])other.index.clone();
        this.value = (int[])other.value.clone();
        this.in = (boolean[])other.in.clone();
        this.size = other.size;
    }

    @Override
    public IntBinaryHeap copy() {
        return new IntBinaryHeap(this);
    }

    @Override
    public boolean change(int element, int priority) {
        if (!this.in[element]) {
            this.internalOffer(element, priority);
            return true;
        }
        return this.internalPromote(element, priority) || this.internalDemote(element, priority);
    }

    @Override
    public final void clear() {
        if (this.size > 0) {
            Arrays.fill(this.in, false);
            this.size = 0;
        }
    }

    @Override
    public final boolean contains(int element) {
        return this.in[element];
    }

    public static IntBinaryHeap createMaxHeap(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("domain must be positive");
        }
        return new Max(n);
    }

    public static IntBinaryHeap createMinHeap(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("domain must be positive");
        }
        return new IntBinaryHeap(n);
    }

    @Override
    public boolean demote(int element, int priority) {
        return this.in[element] && this.internalDemote(element, priority);
    }

    @Override
    public final int domain() {
        return this.index.length;
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean offer(int element, int priority) {
        if (this.in[element]) {
            return false;
        }
        this.internalOffer(element, priority);
        return true;
    }

    @Override
    public final int peek() {
        return this.heap[0];
    }

    @Override
    public int peekPriority() {
        return this.value[this.heap[0]];
    }

    @Override
    public int peekPriority(int element) {
        return this.value[element];
    }

    @Override
    public final int poll() {
        int min = this.heap[0];
        this.in[min] = false;
        --this.size;
        if (this.size > 0) {
            this.heap[0] = this.heap[this.size];
            this.index[this.heap[0]] = 0;
            this.percolateDown(0);
        }
        return min;
    }

    @Override
    public boolean promote(int element, int priority) {
        return this.in[element] && this.internalPromote(element, priority);
    }

    @Override
    public final int size() {
        return this.size;
    }

    private void internalOffer(int element, int priority) {
        this.heap[this.size] = element;
        this.index[this.heap[this.size]] = this.size;
        this.value[element] = priority;
        this.in[element] = true;
        this.percolateUp(this.size);
        ++this.size;
    }

    private boolean internalPromote(int element, int priority) {
        if (priority < this.value[element]) {
            this.value[element] = priority;
            this.percolateUp(this.index[element]);
            return true;
        }
        return false;
    }

    private boolean internalDemote(int element, int priority) {
        if (priority > this.value[element]) {
            this.value[element] = priority;
            this.percolateDown(this.index[element]);
            return true;
        }
        return false;
    }

    private void percolateDown(int i) {
        int left;
        while ((left = (i << 1) + 1) < this.size) {
            int right;
            int smallest = i;
            if (this.value[this.heap[left]] < this.value[this.heap[i]]) {
                smallest = left;
            }
            if ((right = left + 1) < this.size && this.value[this.heap[right]] < this.value[this.heap[smallest]]) {
                smallest = right;
            }
            if (smallest == i) break;
            int temp = this.heap[i];
            this.heap[i] = this.heap[smallest];
            this.index[this.heap[i]] = i;
            this.heap[smallest] = temp;
            this.index[this.heap[smallest]] = smallest;
            i = smallest;
        }
    }

    private void percolateUp(int i) {
        int parent;
        while (i > 0 && this.value[this.heap[parent = i - 1 >> 1]] > this.value[this.heap[i]]) {
            int temp = this.heap[i];
            this.heap[i] = this.heap[parent];
            this.index[this.heap[i]] = i;
            this.heap[parent] = temp;
            this.index[this.heap[parent]] = parent;
            i = parent;
        }
    }

    private static final class Max
    extends IntBinaryHeap {
        private Max(int n) {
            super(n);
        }

        private Max(Max other) {
            super(other);
        }

        @Override
        public Max copy() {
            return new Max(this);
        }

        @Override
        public boolean change(int element, int priority) {
            return super.change(element, -priority);
        }

        @Override
        public boolean demote(int element, int priority) {
            return super.demote(element, -priority);
        }

        @Override
        public boolean offer(int element, int priority) {
            return super.offer(element, -priority);
        }

        @Override
        public int peekPriority() {
            return -super.peekPriority();
        }

        @Override
        public int peekPriority(int element) {
            return -super.peekPriority(element);
        }

        @Override
        public boolean promote(int element, int priority) {
            return super.promote(element, -priority);
        }
    }
}

