/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.math.rand;

import java.util.random.RandomGenerator;
import org.cicirello.math.MathFunctions;

abstract class Binomial {
    private static final int BTPE_CUTOFF = 10;
    private static final ThreadLocal<Binomial> tl = new ThreadLocal();

    Binomial() {
    }

    public static int nextBinomial(int n, double p, RandomGenerator generator) {
        return Binomial.threadLocalInstance(n, p).next(generator);
    }

    static Binomial createInstance(int n, double p) {
        return (double)n * Math.min(p, 1.0 - p) < 10.0 ? new InverseTransform(n, p) : new BTPE(n, p);
    }

    abstract int next(RandomGenerator var1);

    abstract boolean consistentWith(int var1, double var2);

    private static Binomial threadLocalInstance(int n, double p) {
        Binomial bin = tl.get();
        if (bin == null || !bin.consistentWith(n, p)) {
            bin = Binomial.createInstance(n, p);
            tl.set(bin);
        }
        return bin;
    }

    private static class InverseTransform
    extends Binomial {
        private final int n;
        private final double p;
        private final double s;
        private final double a;
        private final double pow0;

        private InverseTransform(int n, double p) {
            double q;
            double r;
            this.n = n;
            this.p = p;
            if (p <= 0.5) {
                r = p;
                q = 1.0 - p;
            } else {
                q = p;
                r = 1.0 - p;
            }
            this.s = r / q;
            this.a = (double)(n + 1) * this.s;
            this.pow0 = MathFunctions.pow(q, n);
        }

        @Override
        final boolean consistentWith(int n, double p) {
            return this.n == n && this.p == p;
        }

        @Override
        final int next(RandomGenerator generator) {
            double u = generator.nextDouble();
            int y = 0;
            for (double pow = this.pow0; u > pow; u -= pow, pow *= this.a / (double)(++y) - this.s) {
            }
            return this.p > 0.5 ? this.n - y : y;
        }
    }

    private static class BTPE
    extends Binomial {
        private final int n;
        private final double p;
        private final double r;
        private final double q;
        private final double s;
        private final int m;
        private final double nrq;
        private final double p1;
        private final double x_m;
        private final double x_l;
        private final double x_r;
        private final double c;
        private final double lambda_l;
        private final double lambda_r;
        private final double p2;
        private final double p3;
        private final double p4;
        private final double nrqInv;

        private BTPE(int n, double p) {
            this.n = n;
            this.p = p;
            if (p <= 0.5) {
                this.r = p;
                this.q = 1.0 - p;
            } else {
                this.q = p;
                this.r = 1.0 - p;
            }
            double nr = (double)n * this.r;
            this.s = this.r / this.q;
            double f_m = nr + this.r;
            this.m = (int)f_m;
            this.nrq = nr * this.q;
            this.p1 = Math.floor(2.195 * Math.sqrt(this.nrq) - 4.6 * this.q) + 0.5;
            this.x_m = (double)this.m + 0.5;
            this.x_l = this.x_m - this.p1;
            this.x_r = this.x_m + this.p1;
            this.c = 0.134 + 20.5 / (15.3 + (double)this.m);
            double a = (f_m - this.x_l) / (f_m - this.x_l * this.r);
            this.lambda_l = a * (1.0 + 0.5 * a);
            a = (this.x_r - f_m) / (this.x_r * this.q);
            this.lambda_r = a * (1.0 + 0.5 * a);
            this.p2 = this.p1 * (1.0 + this.c + this.c);
            this.p3 = this.p2 + this.c / this.lambda_l;
            this.p4 = this.p3 + this.c / this.lambda_r;
            this.nrqInv = 1.0 / this.nrq;
        }

        @Override
        final boolean consistentWith(int n, double p) {
            return this.n == n && this.p == p;
        }

        @Override
        final int next(RandomGenerator generator) {
            int y;
            while (true) {
                double a;
                int k;
                double u = generator.nextDouble(this.p4);
                double v = generator.nextDouble();
                if (u <= this.p1) {
                    y = (int)(this.x_m - this.p1 * v + u);
                    break;
                }
                if (u <= this.p2) {
                    double x = this.x_l + (u - this.p1) / this.c;
                    if ((v = v * this.c + 1.0 - Math.abs((double)this.m - x + 0.5) / this.p1) > 1.0) continue;
                    y = (int)x;
                } else if (u <= this.p3) {
                    y = (int)Math.floor(this.x_l + Math.log(v) / this.lambda_l);
                    if (y < 0) continue;
                    v = v * (u - this.p2) * this.lambda_l;
                } else {
                    y = (int)Math.floor(this.x_r - Math.log(v) / this.lambda_r);
                    if (y > this.n) continue;
                    v = v * (u - this.p3) * this.lambda_r;
                }
                int n = k = this.m > y ? this.m - y : y - this.m;
                if (k <= 20 || (double)k >= this.nrq * 0.5 - 1.0) {
                    a = this.s * (double)(this.n + 1);
                    double f = 1.0;
                    if (this.m < y) {
                        for (int i = this.m + 1; i <= y; ++i) {
                            f *= a / (double)i - this.s;
                        }
                    } else if (this.m > y) {
                        for (int i = y + 1; i <= this.m; ++i) {
                            f /= a / (double)i - this.s;
                        }
                    }
                    if (!(v > f)) break;
                    continue;
                }
                double rho = (double)k * this.nrqInv * (((double)k * ((double)k * 0.3333333333333333 + 0.625) + 0.16666666666666666) * this.nrqInv + 0.5);
                double t = (double)(-k * k) * (0.5 * this.nrqInv);
                a = Math.log(v);
                if (a < t - rho) break;
                if (a > t + rho) continue;
                int x1 = y + 1;
                int f1 = this.m + 1;
                int z = this.n + 1 - this.m;
                int w = this.n - y + 1;
                if (!(a > this.x_m * Math.log((double)f1 / (double)x1) + ((double)(this.n - this.m) + 0.5) * Math.log((double)z / (double)w) + (double)(y - this.m) * Math.log((double)w * this.r / ((double)x1 * this.q)) + this.stirlingApproximation(f1) + this.stirlingApproximation(z) + this.stirlingApproximation(x1) + this.stirlingApproximation(w))) break;
            }
            return this.p > 0.5 ? this.n - y : y;
        }

        private double stirlingApproximation(int x) {
            int x2 = x * x;
            return (13860.0 - (462.0 - (132.0 - (99.0 - 140.0 / (double)x2) / (double)x2) / (double)x2) / (double)x2) / (double)x / 166320.0;
        }
    }
}

