/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.math.rand;

import java.util.concurrent.ThreadLocalRandom;
import java.util.random.RandomGenerator;
import org.cicirello.math.rand.Binomial;
import org.cicirello.math.rand.ZigguratGaussian;

public final class RandomVariates {
    private RandomVariates() {
    }

    public static int nextBinomial(int n, double p) {
        return Binomial.nextBinomial(n, p, ThreadLocalRandom.current());
    }

    public static int nextBinomial(int n, double p, RandomGenerator r) {
        return Binomial.nextBinomial(n, p, r);
    }

    public static double nextCauchy(double median, double scale) {
        return median + RandomVariates.internalNextCauchy(scale, RandomVariates.internalNextTransformedU(ThreadLocalRandom.current(), ThreadLocalRandom.current().nextDouble()));
    }

    public static double nextCauchy(double scale) {
        return RandomVariates.internalNextCauchy(scale, RandomVariates.internalNextTransformedU(ThreadLocalRandom.current(), ThreadLocalRandom.current().nextDouble()));
    }

    public static double nextCauchy(double median, double scale, RandomGenerator r) {
        return median + RandomVariates.internalNextCauchy(scale, RandomVariates.internalNextTransformedU(r, r.nextDouble()));
    }

    public static double nextCauchy(double scale, RandomGenerator r) {
        return RandomVariates.internalNextCauchy(scale, RandomVariates.internalNextTransformedU(r, r.nextDouble()));
    }

    public static double nextGaussian(double mu, double sigma) {
        return mu + ZigguratGaussian.nextGaussian(sigma);
    }

    public static double nextGaussian(double mu, double sigma, RandomGenerator r) {
        return mu + ZigguratGaussian.nextGaussian(sigma, r);
    }

    public static double nextGaussian(double sigma) {
        return ZigguratGaussian.nextGaussian(sigma);
    }

    public static double nextGaussian(double sigma, RandomGenerator r) {
        return ZigguratGaussian.nextGaussian(sigma, r);
    }

    public static double nextGaussian() {
        return ZigguratGaussian.nextGaussian();
    }

    public static double nextGaussian(RandomGenerator r) {
        return ZigguratGaussian.nextGaussian(r);
    }

    static double internalNextCauchy(double scale, double u) {
        return scale * StrictMath.tan(Math.PI * u);
    }

    static double internalNextTransformedU(RandomGenerator r, double u) {
        return u == 0.5 && r.nextBoolean() ? -0.5 : u;
    }
}

