/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.util;

import java.util.Arrays;

public final class DoubleArray {
    private final double[] array;
    private int size;

    public DoubleArray(int length) {
        this.array = new double[length];
    }

    public DoubleArray(double[] array) {
        this.array = array;
    }

    public void add(double element) {
        this.array[this.size] = element;
        ++this.size;
    }

    public void add(int index, double element) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("index is out of bounds");
        }
        System.arraycopy(this.array, index, this.array, index + 1, this.array.length - index - 1);
        this.array[index] = element;
        ++this.size;
    }

    public double[] array() {
        return this.array;
    }

    public void clear() {
        this.size = 0;
    }

    public boolean contains(double element) {
        for (int i = 0; i < this.size; ++i) {
            if (this.array[i] != element) continue;
            return true;
        }
        return false;
    }

    public double get(int index) {
        if (index < this.size) {
            return this.array[index];
        }
        throw new IndexOutOfBoundsException("index is out of bounds");
    }

    public int indexOf(double element) {
        for (int i = 0; i < this.size; ++i) {
            if (this.array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int lastIndexOf(double element) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public int length() {
        return this.array.length;
    }

    public double remove(int index) {
        if (index < this.size) {
            double element = this.array[index];
            --this.size;
            System.arraycopy(this.array, index + 1, this.array, index, this.array.length - index - 1);
            return element;
        }
        throw new IndexOutOfBoundsException("index is out of bounds");
    }

    public void set(int index, double element) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index is out of bounds");
        }
        this.array[index] = element;
    }

    public int size() {
        return this.size;
    }

    public void sort() {
        Arrays.sort(this.array, 0, this.size);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof DoubleArray) {
            DoubleArray o = (DoubleArray)other;
            return this.size == o.size && this.array == o.array;
        }
        return false;
    }

    public int hashCode() {
        int h = 0;
        for (int i = 0; i < this.size; ++i) {
            h = 31 * h + Double.hashCode(this.array[i]);
        }
        return h;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("[");
        if (this.size > 0) {
            s.append(this.array[0]);
            for (int i = 1; i < this.size; ++i) {
                s.append(", ");
                s.append(this.array[i]);
            }
        }
        s.append("]");
        return s.toString();
    }
}

