/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.util;

import java.util.Arrays;

public final class IntegerArray {
    private final int[] array;
    private int size;

    public IntegerArray(int length) {
        this.array = new int[length];
    }

    public IntegerArray(int[] array) {
        this.array = array;
    }

    public void add(int element) {
        this.array[this.size] = element;
        ++this.size;
    }

    public void add(int index, int element) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("index is out of bounds");
        }
        System.arraycopy(this.array, index, this.array, index + 1, this.array.length - index - 1);
        this.array[index] = element;
        ++this.size;
    }

    public int[] array() {
        return this.array;
    }

    public void clear() {
        this.size = 0;
    }

    public boolean contains(int element) {
        for (int i = 0; i < this.size; ++i) {
            if (this.array[i] != element) continue;
            return true;
        }
        return false;
    }

    public int get(int index) {
        if (index < this.size) {
            return this.array[index];
        }
        throw new IndexOutOfBoundsException("index is out of bounds");
    }

    public int indexOf(int element) {
        for (int i = 0; i < this.size; ++i) {
            if (this.array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int lastIndexOf(int element) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public int length() {
        return this.array.length;
    }

    public int remove(int index) {
        if (index < this.size) {
            int element = this.array[index];
            --this.size;
            System.arraycopy(this.array, index + 1, this.array, index, this.array.length - index - 1);
            return element;
        }
        throw new IndexOutOfBoundsException("index is out of bounds");
    }

    public void set(int index, int element) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index is out of bounds");
        }
        this.array[index] = element;
    }

    public int size() {
        return this.size;
    }

    public void sort() {
        Arrays.sort(this.array, 0, this.size);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof IntegerArray) {
            IntegerArray o = (IntegerArray)other;
            return this.size == o.size && this.array == o.array;
        }
        return false;
    }

    public int hashCode() {
        int h = 0;
        for (int i = 0; i < this.size; ++i) {
            h = 31 * h + this.array[i];
        }
        return h;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("[");
        if (this.size > 0) {
            s.append(this.array[0]);
            for (int i = 1; i < this.size; ++i) {
                s.append(", ");
                s.append(this.array[i]);
            }
        }
        s.append("]");
        return s.toString();
    }
}

