/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.math;

public final class MathFunctions {
    private static final double[] STIRLING_EXPANSION_LN_GAMMA = new double[]{8.116141674705085E-4, -5.950619042843014E-4, 7.936503404577169E-4, -0.002777777777300997, 0.08333333333333319};
    private static final double[] POLY_APPROX_2 = new double[]{-1378.2515256912086, -38801.631513463784, -331612.9927388712, -1162370.974927623, -1721737.0082083966, -853555.6642457654};
    private static final double[] POLY_APPROX_3 = new double[]{1.0, -351.81570143652345, -17064.210665188115, -220528.59055385445, -1139334.4436798252, -2532523.0717758294, -2018891.4143353277};

    private MathFunctions() {
    }

    public static double betai(double a, double b, double x) {
        double bt;
        if (x < 0.0 || x > 1.0) {
            throw new IllegalArgumentException("x must be in [0.0, 1.0]");
        }
        double d = bt = x == 0.0 || x == 1.0 ? 0.0 : Math.exp(MathFunctions.logGamma(a + b) - MathFunctions.logGamma(a) - MathFunctions.logGamma(b) + a * Math.log(x) + b * Math.log(1.0 - x));
        if (x < (a + 1.0) / (a + b + 2.0)) {
            return bt * MathFunctions.betacf(a, b, x) / a;
        }
        return 1.0 - bt * MathFunctions.betacf(b, a, 1.0 - x) / b;
    }

    public static double pow(double a, int b) {
        if (b >= 0) {
            double c = 1.0;
            while (b > 0) {
                if ((b & 1) == 1) {
                    c *= a;
                }
                b >>= 1;
                a *= a;
            }
            return c;
        }
        return 1.0 / MathFunctions.pow(a, -b);
    }

    public static double logGamma(double n) {
        if (!Double.isFinite(n)) {
            return n;
        }
        if (n >= 2.556348E305) {
            return Double.POSITIVE_INFINITY;
        }
        if (n <= -2.556348E305) {
            return Double.NEGATIVE_INFINITY;
        }
        if (n < -34.0) {
            if (n < -4.5035996273704955E15) {
                return Double.POSITIVE_INFINITY;
            }
            double p = (long)(n = -n);
            if (p == n) {
                return Double.POSITIVE_INFINITY;
            }
            double z = n - p;
            if (z > 0.5) {
                z = (p += 1.0) - n;
            }
            z = n * Math.sin(z * Math.PI);
            double LOG_PI = 1.1447298858494002;
            return 1.1447298858494002 - Math.log(z) - MathFunctions.logGamma(n);
        }
        if (n < 13.0) {
            double z = 1.0;
            int p = 0;
            double u = n;
            while (u >= 3.0) {
                u = n + (double)(--p);
                z *= u;
            }
            while (u < 2.0) {
                if (u == 0.0) {
                    return Double.POSITIVE_INFINITY;
                }
                z /= u;
                u = n + (double)(++p);
            }
            if (z < 0.0) {
                z = -z;
            }
            if (u == 2.0) {
                return Math.log(z);
            }
            return Math.log(z) + (n += (double)(p -= 2)) * MathFunctions.evaluatePolynomial(n, POLY_APPROX_2) / MathFunctions.evaluatePolynomial(n, POLY_APPROX_3);
        }
        double LOG_SQRT_PI2 = 0.9189385332046727;
        double q = (n - 0.5) * Math.log(n) - n + 0.9189385332046727;
        if (n > 1.0E8) {
            return q;
        }
        double p = 1.0 / (n * n);
        q = n >= 1000.0 ? (q += ((7.936507936507937E-4 * p - 0.002777777777777778) * p + 0.08333333333333333) / n) : (q += MathFunctions.evaluatePolynomial(p, STIRLING_EXPANSION_LN_GAMMA) / n);
        return q;
    }

    private static double betacf(double a, double b, double x) {
        int m;
        double d;
        int MAXIT = 100;
        double EPSILON = 3.0E-7;
        double qab = a + b;
        double qap = a + 1.0;
        double qam = a - 1.0;
        double c = 1.0;
        double h = d = 1.0 / MathFunctions.adjustIfTooSmall(1.0 - qab * x / qap);
        for (m = 1; m <= 100; ++m) {
            int m2 = m << 1;
            double aa = (double)m * (b - (double)m) * x / ((qam + (double)m2) * (a + (double)m2));
            d = 1.0 / MathFunctions.adjustIfTooSmall(1.0 + aa * d);
            c = MathFunctions.adjustIfTooSmall(1.0 + aa / c);
            h *= d * c;
            aa = -(a + (double)m) * (qab + (double)m) * x / ((a + (double)m2) * (qap + (double)m2));
            d = 1.0 / MathFunctions.adjustIfTooSmall(1.0 + aa * d);
            c = MathFunctions.adjustIfTooSmall(1.0 + aa / c);
            double del = d * c;
            h *= del;
            if (Math.abs(del - 1.0) < 3.0E-7) break;
        }
        if (m > 100) {
            throw new ArithmeticException("Failed to converge.");
        }
        return h;
    }

    private static double adjustIfTooSmall(double x) {
        double FPMIN = 1.0E-30;
        return Math.abs(x) < 1.0E-30 ? 1.0E-30 : x;
    }

    private static double evaluatePolynomial(double x, double[] polynomial) {
        double result = polynomial[0];
        for (int i = 1; i < polynomial.length; ++i) {
            result = result * x + polynomial[i];
        }
        return result;
    }
}

