/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.math.rand;

import java.util.random.RandomGenerator;
import java.util.stream.Stream;
import org.cicirello.math.rand.EnhancedJumpableGenerator;

public class EnhancedLeapableGenerator
extends EnhancedJumpableGenerator
implements RandomGenerator.LeapableGenerator {
    private final RandomGenerator.LeapableGenerator generator;

    public EnhancedLeapableGenerator(RandomGenerator.LeapableGenerator generator) {
        super(generator);
        this.generator = generator;
    }

    public EnhancedLeapableGenerator(String algorithmName) {
        this(RandomGenerator.LeapableGenerator.of(algorithmName));
    }

    public static EnhancedLeapableGenerator of(String algorithmName) {
        return new EnhancedLeapableGenerator(algorithmName);
    }

    @Override
    public EnhancedLeapableGenerator copy() {
        return new EnhancedLeapableGenerator(this.generator.copy());
    }

    @Override
    public final EnhancedLeapableGenerator copyAndLeap() {
        EnhancedLeapableGenerator c = this.copy();
        this.leap();
        return c;
    }

    @Override
    public final void leap() {
        this.generator.leap();
    }

    @Override
    public final double leapDistance() {
        return this.generator.leapDistance();
    }

    public final Stream<EnhancedJumpableGenerator> eleaps() {
        return this.generator.leaps().map(gen -> new EnhancedJumpableGenerator((RandomGenerator.JumpableGenerator)gen));
    }

    public final Stream<EnhancedJumpableGenerator> eleaps(long streamSize) {
        return this.generator.leaps(streamSize).map(gen -> new EnhancedJumpableGenerator((RandomGenerator.JumpableGenerator)gen));
    }

    @Override
    public final Stream<RandomGenerator.JumpableGenerator> leaps() {
        return this.generator.leaps().map(gen -> new EnhancedJumpableGenerator((RandomGenerator.JumpableGenerator)gen));
    }

    @Override
    public final Stream<RandomGenerator.JumpableGenerator> leaps(long streamSize) {
        return this.generator.leaps(streamSize).map(gen -> new EnhancedJumpableGenerator((RandomGenerator.JumpableGenerator)gen));
    }
}

