/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.math.la;

public final class JacobiDiagonalization {
    public static final double EPSILON = 1.0E-5;
    public static final int MAX_ITERATIONS = 10000000;
    private double[][] a;
    private final int N;
    private double[][] eigenvectors;
    private double[] eigenvalues;

    public JacobiDiagonalization(int[][] matrix) {
        if (matrix.length != matrix[0].length) {
            throw new IllegalArgumentException("Must be a square matrix.");
        }
        this.N = matrix.length;
        this.a = new double[this.N][this.N];
        for (int i = 0; i < this.N; ++i) {
            for (int j = 0; j < this.N; ++j) {
                this.a[i][j] = matrix[i][j];
            }
        }
    }

    public JacobiDiagonalization(double[][] matrix) {
        if (matrix.length != matrix[0].length) {
            throw new IllegalArgumentException("Must be a square matrix.");
        }
        this.N = matrix.length;
        this.a = new double[this.N][this.N];
        for (int i = 0; i < this.N; ++i) {
            for (int j = 0; j < this.N; ++j) {
                this.a[i][j] = matrix[i][j];
            }
        }
    }

    public double[][] eigenvectors() {
        if (this.eigenvectors == null) {
            return null;
        }
        double[][] result = new double[this.eigenvectors.length][];
        for (int i = 0; i < this.eigenvectors.length; ++i) {
            result[i] = (double[])this.eigenvectors[i].clone();
        }
        return result;
    }

    public double[] eigenvalues() {
        return this.eigenvalues != null ? (double[])this.eigenvalues.clone() : null;
    }

    public boolean compute() {
        return this.compute(1.0E-5, 10000000);
    }

    public boolean compute(double epsilon) {
        return this.compute(epsilon, 10000000);
    }

    public boolean compute(int maxIters) {
        return this.compute(1.0E-5, maxIters);
    }

    public boolean compute(double epsilon, int maxIters) {
        for (int i = 0; i < maxIters; ++i) {
            if (!this.oneIteration(epsilon)) continue;
            return true;
        }
        return false;
    }

    private boolean oneIteration(double epsilon) {
        int i;
        double cos_theta;
        int i2;
        int p = -1;
        int q = -1;
        double a_pq = 0.0;
        double sumOffDiagonal = 0.0;
        for (i2 = 0; i2 < this.N; ++i2) {
            for (int j = 0; j < this.N; ++j) {
                if (i2 == j) continue;
                double absAij = Math.abs(this.a[i2][j]);
                if (absAij > 0.0 && absAij < epsilon) {
                    this.a[i2][j] = 0.0;
                    absAij = 0.0;
                }
                if (p < 0 || absAij > a_pq) {
                    p = i2;
                    q = j;
                    a_pq = absAij;
                }
                sumOffDiagonal += absAij;
            }
        }
        if (sumOffDiagonal == 0.0) {
            if (this.eigenvalues == null) {
                this.eigenvalues = new double[this.N];
                for (i2 = 0; i2 < this.N; ++i2) {
                    this.eigenvalues[i2] = this.a[i2][i2];
                }
            }
            if (this.eigenvectors == null) {
                this.eigenvectors = this.copy(this.a);
            }
            return true;
        }
        double f = -a_pq;
        double g = 0.5 * (this.a[p][p] - this.a[q][q]);
        double g_sign = g < 0.0 ? -1.0 : 1.0;
        double h = g_sign * f / Math.sqrt(f * f + g * g);
        double sin_theta = h / Math.sqrt(2.0 * (1.0 + Math.sqrt(1.0 - h * h)));
        double e_pp = cos_theta = Math.sqrt(1.0 - sin_theta * sin_theta);
        double e_qq = cos_theta;
        double e_pq = sin_theta;
        double e_qp = -sin_theta;
        if (this.eigenvectors == null) {
            this.eigenvectors = new double[this.N][this.N];
            for (int i3 = 0; i3 < this.N; ++i3) {
                this.eigenvectors[i3][i3] = 1.0;
            }
            double d = cos_theta;
            this.eigenvectors[q][q] = d;
            this.eigenvectors[p][p] = d;
            this.eigenvectors[p][q] = sin_theta;
            this.eigenvectors[q][p] = -sin_theta;
        } else {
            double[][] temp = new double[this.N][2];
            for (i = 0; i < this.N; ++i) {
                temp[i][0] = this.eigenvectors[i][p] * e_pp + this.eigenvectors[i][q] * e_qp;
                temp[i][1] = this.eigenvectors[i][p] * e_pq + this.eigenvectors[i][q] * e_qq;
            }
            for (i = 0; i < this.N; ++i) {
                this.eigenvectors[i][p] = temp[i][0];
                this.eigenvectors[i][q] = temp[i][1];
            }
        }
        double[][] temp = new double[this.N][2];
        for (i = 0; i < this.N; ++i) {
            temp[i][0] = this.a[i][p] * e_pp + this.a[i][q] * e_qp;
            temp[i][1] = this.a[i][p] * e_pq + this.a[i][q] * e_qq;
        }
        for (i = 0; i < this.N; ++i) {
            this.a[i][p] = temp[i][0];
            this.a[i][q] = temp[i][1];
        }
        for (i = 0; i < this.N; ++i) {
            temp[i][0] = this.a[p][i] * e_pp + this.a[q][i] * e_qp;
            temp[i][1] = this.a[p][i] * e_pq + this.a[q][i] * e_qq;
        }
        for (i = 0; i < this.N; ++i) {
            this.a[p][i] = temp[i][0];
            this.a[q][i] = temp[i][1];
        }
        if (this.eigenvalues == null) {
            this.eigenvalues = new double[this.N];
        }
        for (i = 0; i < this.N; ++i) {
            this.eigenvalues[i] = this.a[i][i];
        }
        return false;
    }

    private double[][] copy(double[][] array) {
        double[][] result = new double[array.length][];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (double[])array[i].clone();
        }
        return result;
    }
}

