/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.math.rand;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.random.RandomGenerator;
import org.cicirello.math.rand.Binomial;
import org.cicirello.math.rand.ZigguratGaussian;

public final class RandomVariates {
    private static final RandomGenerator gaussianThreadLocalRandom = new RandomGenerator(){

        @Override
        public long nextLong() {
            return ThreadLocalRandom.current().nextLong();
        }
    };

    private RandomVariates() {
    }

    public static int nextBinomial(int n, double p) {
        return Binomial.nextBinomial(n, p, ThreadLocalRandom.current());
    }

    public static int nextBinomial(int n, double p, RandomGenerator r) {
        return Binomial.nextBinomial(n, p, r);
    }

    public static double nextCauchy(double median, double scale) {
        return median + RandomVariates.internalNextCauchy(scale, RandomVariates.internalNextTransformedU(ThreadLocalRandom.current(), ThreadLocalRandom.current().nextDouble()));
    }

    public static double nextCauchy(double scale) {
        return RandomVariates.internalNextCauchy(scale, RandomVariates.internalNextTransformedU(ThreadLocalRandom.current(), ThreadLocalRandom.current().nextDouble()));
    }

    public static double nextCauchy(double median, double scale, RandomGenerator r) {
        return median + RandomVariates.internalNextCauchy(scale, RandomVariates.internalNextTransformedU(r, r.nextDouble()));
    }

    public static double nextCauchy(double scale, RandomGenerator r) {
        return RandomVariates.internalNextCauchy(scale, RandomVariates.internalNextTransformedU(r, r.nextDouble()));
    }

    public static double nextGaussian(double mu, double sigma) {
        return gaussianThreadLocalRandom.nextGaussian(mu, sigma);
    }

    public static double nextGaussian(double mu, double sigma, RandomGenerator r) {
        return r instanceof Random ? mu + sigma * ZigguratGaussian.nextGaussian(r) : r.nextGaussian(mu, sigma);
    }

    public static double nextGaussian(double sigma) {
        return gaussianThreadLocalRandom.nextGaussian(0.0, sigma);
    }

    public static double nextGaussian(double sigma, RandomGenerator r) {
        return r instanceof Random ? sigma * ZigguratGaussian.nextGaussian(r) : r.nextGaussian(0.0, sigma);
    }

    public static double nextGaussian() {
        return gaussianThreadLocalRandom.nextGaussian();
    }

    public static double nextGaussian(RandomGenerator r) {
        return r instanceof Random ? ZigguratGaussian.nextGaussian(r) : r.nextGaussian();
    }

    static double internalNextCauchy(double scale, double u) {
        return scale * StrictMath.tan(Math.PI * u);
    }

    static double internalNextTransformedU(RandomGenerator r, double u) {
        return u == 0.5 && r.nextBoolean() ? -0.5 : u;
    }
}

