/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.math.rand;

import java.util.random.RandomGenerator;

final class ZigguratGaussian {
    private static final double PARAM_R = 3.44428647676;
    private static final double HALF_PARAM_R = 1.72214323838;
    private static final double PARAM_R_INV = 0.2903358959097643;
    private static final double[] ytab = new double[]{1.0, 0.963598623011, 0.936280813353, 0.913041104253, 0.892278506696, 0.873239356919, 0.855496407634, 0.838778928349, 0.822902083699, 0.807732738234, 0.793171045519, 0.779139726505, 0.765577436082, 0.752434456248, 0.739669787677, 0.727249120285, 0.715143377413, 0.703327646455, 0.691780377035, 0.68048276891, 0.669418297233, 0.65857233912, 0.647931876189, 0.637485254896, 0.62722199145, 0.617132611532, 0.607208517467, 0.597441877296, 0.587825531465, 0.578352913803, 0.569017984198, 0.559815170911, 0.550739320877, 0.541785656682, 0.532949739145, 0.524227434628, 0.515614886373, 0.507108489253, 0.498704867478, 0.490400854812, 0.482193476986, 0.47407993601, 0.466057596125, 0.458123971214, 0.450276713467, 0.442513603171, 0.434832539473, 0.427231532022, 0.419708693379, 0.41226223212, 0.404890446548, 0.397591718955, 0.390364510382, 0.383207355816, 0.376118859788, 0.369097692334, 0.362142585282, 0.355252328834, 0.348425768415, 0.341661801776, 0.334959376311, 0.328317486588, 0.321735172063, 0.31521151497, 0.308745638367, 0.302336704338, 0.29598391232, 0.289686497571, 0.283443729739, 0.27725491156, 0.271119377649, 0.265036493387, 0.259005653912, 0.253026283183, 0.247097833139, 0.241219782932, 0.235391638239, 0.229612930649, 0.223883217122, 0.218202079518, 0.212569124201, 0.206983981709, 0.201446306496, 0.195955776745, 0.190512094256, 0.185114984406, 0.179764196185, 0.174459502324, 0.169200699492, 0.1639876086, 0.158820075195, 0.153697969964, 0.148621189348, 0.143589656295, 0.138603321143, 0.133662162669, 0.128766189309, 0.123915440582, 0.119109988745, 0.114349940703, 0.10963544023, 0.104966670533, 0.100343857232, 0.0957672718266, 0.0912372357329, 0.0867541250127, 0.082318375932, 0.0779304915295, 0.0735910494266, 0.0693007111742, 0.065060233529, 0.0608704821745, 0.056732448584, 0.05264727098, 0.0486162607163, 0.0446409359769, 0.0407230655415, 0.0368647267386, 0.0330683839378, 0.0293369977411, 0.0256741818288, 0.0220844372634, 0.0185735200577, 0.0151490552854, 0.0118216532614, 0.00860719483079, 0.00553245272614, 0.00265435214565};
    private static final int[] ktab = new int[]{0, 12590644, 14272653, 14988939, 15384584, 15635009, 15807561, 15933577, 16029594, 16105155, 16166147, 16216399, 16258508, 16294295, 16325078, 16351831, 16375291, 16396026, 16414479, 16431002, 16445880, 16459343, 16471578, 16482744, 16492970, 16502368, 16511031, 16519039, 16526459, 16533352, 16539769, 16545755, 16551348, 16556584, 16561493, 16566101, 16570433, 16574511, 16578353, 16581977, 16585398, 16588629, 16591685, 16594575, 16597311, 16599901, 16602354, 16604679, 16606881, 16608968, 16610945, 16612818, 16614592, 16616272, 16617861, 16619363, 16620782, 16622121, 16623383, 16624570, 16625685, 16626730, 16627708, 16628619, 16629465, 16630248, 16630969, 16631628, 16632228, 16632768, 16633248, 16633671, 16634034, 16634340, 16634586, 16634774, 16634903, 16634972, 16634980, 16634926, 16634810, 16634628, 16634381, 16634066, 16633680, 16633222, 16632688, 16632075, 16631380, 16630598, 16629726, 16628757, 16627686, 16626507, 16625212, 16623794, 16622243, 16620548, 16618698, 16616679, 16614476, 16612071, 16609444, 16606571, 16603425, 16599973, 16596178, 16591995, 16587369, 16582237, 16576520, 16570120, 16562917, 16554758, 16545450, 16534739, 16522287, 16507638, 16490152, 16468907, 16442518, 16408804, 16364095, 16301683, 16207738, 16047994, 15704248, 15472926};
    private static final double[] wtab = new double[]{1.62318314817E-8, 2.16291505214E-8, 2.54246305087E-8, 2.84579525938E-8, 3.10340022482E-8, 3.33011726243E-8, 3.53439060345E-8, 3.72152672658E-8, 3.8950989572E-8, 4.05763964764E-8, 4.21101548915E-8, 4.35664624904E-8, 4.49563968336E-8, 4.62887864029E-8, 4.75707945735E-8, 4.88083237257E-8, 5.00063025384E-8, 5.11688950428E-8, 5.22996558616E-8, 5.34016475624E-8, 5.44775307871E-8, 5.55296344581E-8, 5.65600111659E-8, 5.75704813695E-8, 5.85626690412E-8, 5.95380306862E-8, 6.04978791776E-8, 6.14434034901E-8, 6.23756851626E-8, 6.32957121259E-8, 6.42043903937E-8, 6.51025540077E-8, 6.59909735447E-8, 6.68703634341E-8, 6.77413882848E-8, 6.8604668381E-8, 6.94607844804E-8, 7.03102820203E-8, 7.11536748229E-8, 7.1991448372E-8, 7.2824062723E-8, 7.36519550992E-8, 7.44755422158E-8, 7.52952223703E-8, 7.61113773308E-8, 7.69243740467E-8, 7.77345662086E-8, 7.85422956743E-8, 7.93478937793E-8, 8.01516825471E-8, 8.09539758128E-8, 8.17550802699E-8, 8.25552964535E-8, 8.33549196661E-8, 8.41542408569E-8, 8.49535474601E-8, 8.57531242006E-8, 8.65532538723E-8, 8.73542180955E-8, 8.8156298059E-8, 8.89597752521E-8, 8.97649321908E-8, 9.05720531451E-8, 9.138142487E-8, 9.21933373471E-8, 9.30080845407E-8, 9.38259651738E-8, 9.46472835298E-8, 9.54723502847E-8, 9.63014833769E-8, 9.71350089201E-8, 9.79732621669E-8, 9.88165885297E-8, 9.96653446693E-8, 1.00519899658E-7, 1.0138063623E-7, 1.02247952126E-7, 1.03122261554E-7, 1.04003996769E-7, 1.04893609795E-7, 1.05791574313E-7, 1.06698387725E-7, 1.07614573423E-7, 1.08540683296E-7, 1.09477300508E-7, 1.1042504257E-7, 1.11384564771E-7, 1.12356564007E-7, 1.13341783071E-7, 1.14341015475E-7, 1.15355110887E-7, 1.16384981291E-7, 1.17431607977E-7, 1.18496049514E-7, 1.19579450872E-7, 1.20683053909E-7, 1.21808209468E-7, 1.2295639141E-7, 1.24129212952E-7, 1.25328445797E-7, 1.26556042658E-7, 1.27814163916E-7, 1.29105209375E-7, 1.30431856341E-7, 1.31797105598E-7, 1.3320433736E-7, 1.34657379914E-7, 1.36160594606E-7, 1.37718982103E-7, 1.39338316679E-7, 1.41025317971E-7, 1.42787873535E-7, 1.44635331499E-7, 1.4657889173E-7, 1.48632138436E-7, 1.50811780719E-7, 1.53138707402E-7, 1.55639532047E-7, 1.58348931426E-7, 1.61313325908E-7, 1.64596952856E-7, 1.68292495203E-7, 1.72541128694E-7, 1.77574279496E-7, 1.83813550477E-7, 1.92166040885E-7, 2.05295471952E-7, 2.22600839893E-7};

    private ZigguratGaussian() {
    }

    static double nextGaussian(RandomGenerator r) {
        int sign;
        double x;
        double y;
        do {
            int i;
            sign = (i = r.nextInt()) < 0 ? 1 : -1;
            int j = i & 0xFFFFFF;
            i = i >>> 24 & 0x7F;
            x = (double)j * wtab[i];
            if (j < ktab[i]) break;
            if (i < 127) {
                y = ytab[i + 1] + (ytab[i] - ytab[i + 1]) * r.nextDouble();
                continue;
            }
            x = 3.44428647676 - StrictMath.log(1.0 - r.nextDouble()) * 0.2903358959097643;
            y = StrictMath.exp(-3.44428647676 * (x - 1.72214323838)) * r.nextDouble();
        } while (y >= StrictMath.exp(-0.5 * x * x));
        return (double)sign * x;
    }
}

