/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.math.rand;

import java.security.SecureRandom;
import java.util.List;
import java.util.Random;
import java.util.SplittableRandom;
import java.util.random.RandomGenerator;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.cicirello.math.rand.Binomial;
import org.cicirello.math.rand.IndexPair;
import org.cicirello.math.rand.IndexTriple;
import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.math.rand.RandomSampler;
import org.cicirello.math.rand.RandomVariates;
import org.cicirello.math.rand.Shuffler;
import org.cicirello.math.rand.ZigguratGaussian;

public class EnhancedRandomGenerator
implements RandomGenerator {
    private final RandomGenerator generator;
    private final RandomGenerator generatorForGaussians;
    private Binomial binomial;

    public EnhancedRandomGenerator() {
        this(RandomGenerator.getDefault(), false);
    }

    public EnhancedRandomGenerator(long seed) {
        this(new SplittableRandom(seed), false);
    }

    public EnhancedRandomGenerator(RandomGenerator generator) {
        this(generator, generator instanceof Random);
    }

    public EnhancedRandomGenerator(String algorithmName) {
        this(RandomGenerator.of(algorithmName));
    }

    private EnhancedRandomGenerator(RandomGenerator generator, boolean replaceGaussian) {
        this.generator = generator;
        this.generatorForGaussians = replaceGaussian ? EnhancedRandomGenerator.internalGaussian(generator) : generator;
    }

    public static EnhancedRandomGenerator getDefault() {
        return new EnhancedRandomGenerator();
    }

    public static EnhancedRandomGenerator of(String algorithmName) {
        return new EnhancedRandomGenerator(algorithmName);
    }

    public final boolean[] arrayMask(int n) {
        return RandomIndexer.arrayMask(n, this.generator);
    }

    public final boolean[] arrayMask(int n, int k) {
        return RandomIndexer.arrayMask(n, k, this.generator);
    }

    public final boolean[] arrayMask(int n, double p) {
        return RandomIndexer.arrayMask(n, this.nextBinomial(n, p), this.generator);
    }

    public final IntStream biasedInts(int randomNumberOrigin, int randomNumberBound) {
        return IntStream.generate(() -> this.nextBiasedInt(randomNumberOrigin, randomNumberBound)).sequential();
    }

    public final IntStream biasedInts(long streamSize, int randomNumberOrigin, int randomNumberBound) {
        return IntStream.generate(() -> this.nextBiasedInt(randomNumberOrigin, randomNumberBound)).sequential().limit(streamSize);
    }

    public final IntStream binomials(int n, double p) {
        return IntStream.generate(() -> this.nextBinomial(n, p)).sequential();
    }

    public final IntStream binomials(long streamSize, int n, double p) {
        return IntStream.generate(() -> this.nextBinomial(n, p)).sequential().limit(streamSize);
    }

    public final DoubleStream cauchys(double median, double scale) {
        return DoubleStream.generate(() -> this.nextCauchy(median, scale)).sequential();
    }

    public final DoubleStream cauchys(long streamSize, double median, double scale) {
        return DoubleStream.generate(() -> this.nextCauchy(median, scale)).sequential().limit(streamSize);
    }

    public final DoubleStream exponentials() {
        return DoubleStream.generate(() -> this.nextExponential()).sequential();
    }

    public final DoubleStream exponentials(long streamSize) {
        return DoubleStream.generate(() -> this.nextExponential()).sequential().limit(streamSize);
    }

    public final DoubleStream gaussians() {
        return DoubleStream.generate(() -> this.nextGaussian()).sequential();
    }

    public final DoubleStream gaussians(double mean, double stdev) {
        return DoubleStream.generate(() -> this.nextGaussian(mean, stdev)).sequential();
    }

    public final DoubleStream gaussians(long streamSize, double mean, double stdev) {
        return DoubleStream.generate(() -> this.nextGaussian(mean, stdev)).sequential().limit(streamSize);
    }

    public final DoubleStream gaussians(long streamSize) {
        return DoubleStream.generate(() -> this.nextGaussian()).sequential().limit(streamSize);
    }

    public final int nextBiasedInt(int bound) {
        return RandomIndexer.nextBiasedInt(bound, this.generator);
    }

    public final int nextBiasedInt(int origin, int bound) {
        return RandomIndexer.nextBiasedInt(origin, bound, this.generator);
    }

    public final int nextBinomial(int n, double p) {
        if (this.binomial == null || !this.binomial.consistentWith(n, p)) {
            this.binomial = Binomial.createInstance(n, p);
        }
        return this.binomial.next(this.generator);
    }

    public final double nextCauchy(double scale) {
        return RandomVariates.nextCauchy(scale, this.generator);
    }

    public final double nextCauchy(double median, double scale) {
        return RandomVariates.nextCauchy(median, scale, this.generator);
    }

    public final double nextGaussian(double stddev) {
        return this.generatorForGaussians.nextGaussian(0.0, stddev);
    }

    public final int[] nextIntPair(int n, int[] result) {
        return RandomIndexer.nextIntPair(n, result, this.generator);
    }

    public final IndexPair nextIntPair(int n) {
        return RandomIndexer.nextIntPair(n, this.generator);
    }

    public final int[] nextIntTriple(int n, int[] result) {
        return RandomIndexer.nextIntTriple(n, result, this.generator);
    }

    public final IndexTriple nextIntTriple(int n) {
        return RandomIndexer.nextIntTriple(n, this.generator);
    }

    public final int[] nextSortedIntPair(int n, int[] result) {
        return RandomIndexer.nextSortedIntPair(n, result, this.generator);
    }

    public final IndexPair nextSortedIntPair(int n) {
        return RandomIndexer.nextSortedIntPair(n, this.generator);
    }

    public final int[] nextSortedIntTriple(int n, int[] result) {
        return RandomIndexer.nextSortedIntTriple(n, result, this.generator);
    }

    public final IndexTriple nextSortedIntTriple(int n) {
        return RandomIndexer.nextSortedIntTriple(n, this.generator);
    }

    public final int[] nextSortedWindowedIntPair(int n, int window, int[] result) {
        return RandomIndexer.nextSortedWindowedIntPair(n, window, result, this.generator);
    }

    public final IndexPair nextSortedWindowedIntPair(int n, int window) {
        return RandomIndexer.nextSortedWindowedIntPair(n, window, this.generator);
    }

    public final int[] nextSortedWindowedIntTriple(int n, int window, int[] result) {
        return RandomIndexer.nextSortedWindowedIntTriple(n, window, result, this.generator);
    }

    public final IndexTriple nextSortedWindowedIntTriple(int n, int window) {
        return RandomIndexer.nextSortedWindowedIntTriple(n, window, this.generator);
    }

    public final int[] nextWindowedIntPair(int n, int window, int[] result) {
        return RandomIndexer.nextWindowedIntPair(n, window, result, this.generator);
    }

    public final IndexPair nextWindowedIntPair(int n, int window) {
        return RandomIndexer.nextWindowedIntPair(n, window, this.generator);
    }

    public final int[] nextWindowedIntTriple(int n, int window, int[] result) {
        return RandomIndexer.nextWindowedIntTriple(n, window, result, this.generator);
    }

    public final IndexTriple nextWindowedIntTriple(int n, int window) {
        return RandomIndexer.nextWindowedIntTriple(n, window, this.generator);
    }

    public final Stream<IndexPair> pairs(int n) {
        return (Stream)Stream.generate(() -> this.nextIntPair(n)).sequential();
    }

    public final Stream<IndexPair> pairs(long streamSize, int n) {
        return ((Stream)Stream.generate(() -> this.nextIntPair(n)).sequential()).limit(streamSize);
    }

    public final int[] sample(int n, double p) {
        return RandomSampler.sample(n, this.nextBinomial(n, p), null, this.generator);
    }

    public final int[] sample(int n, int k, int[] result) {
        return RandomSampler.sample(n, k, result, this.generator);
    }

    public final int[] sampleInsertion(int n, int k, int[] result) {
        return RandomSampler.sampleInsertion(n, k, result, this.generator);
    }

    public final int[] samplePool(int n, int k, int[] result) {
        return RandomSampler.samplePool(n, k, result, this.generator);
    }

    public final int[] sampleReservoir(int n, int k, int[] result) {
        return RandomSampler.sampleReservoir(n, k, result, this.generator);
    }

    public final void shuffle(byte[] array) {
        Shuffler.shuffle(array, this.generator);
    }

    public final void shuffle(byte[] array, int first, int last) {
        Shuffler.shuffle(array, first, last, this.generator);
    }

    public final void shuffle(char[] array) {
        Shuffler.shuffle(array, this.generator);
    }

    public final void shuffle(char[] array, int first, int last) {
        Shuffler.shuffle(array, first, last, this.generator);
    }

    public final void shuffle(double[] array) {
        Shuffler.shuffle(array, this.generator);
    }

    public final void shuffle(double[] array, int first, int last) {
        Shuffler.shuffle(array, first, last, this.generator);
    }

    public final void shuffle(float[] array) {
        Shuffler.shuffle(array, this.generator);
    }

    public final void shuffle(float[] array, int first, int last) {
        Shuffler.shuffle(array, first, last, this.generator);
    }

    public final void shuffle(int[] array) {
        Shuffler.shuffle(array, this.generator);
    }

    public final void shuffle(int[] array, int first, int last) {
        Shuffler.shuffle(array, first, last, this.generator);
    }

    public final void shuffle(long[] array) {
        Shuffler.shuffle(array, this.generator);
    }

    public final void shuffle(long[] array, int first, int last) {
        Shuffler.shuffle(array, first, last, this.generator);
    }

    public final void shuffle(short[] array) {
        Shuffler.shuffle(array, this.generator);
    }

    public final void shuffle(short[] array, int first, int last) {
        Shuffler.shuffle(array, first, last, this.generator);
    }

    public final <T> void shuffle(T[] array) {
        Shuffler.shuffle(array, this.generator);
    }

    public final <T> void shuffle(T[] array, int first, int last) {
        Shuffler.shuffle(array, first, last, this.generator);
    }

    public final <T> void shuffle(List<T> list) {
        Shuffler.shuffle(list, this.generator);
    }

    public final <T> void shuffle(List<T> list, int first, int last) {
        Shuffler.shuffle(list, first, last, this.generator);
    }

    public final Stream<IndexPair> sortedPairs(int n) {
        return (Stream)Stream.generate(() -> this.nextSortedIntPair(n)).sequential();
    }

    public final Stream<IndexPair> sortedPairs(long streamSize, int n) {
        return ((Stream)Stream.generate(() -> this.nextSortedIntPair(n)).sequential()).limit(streamSize);
    }

    public final Stream<IndexTriple> sortedTriples(int n) {
        return (Stream)Stream.generate(() -> this.nextSortedIntTriple(n)).sequential();
    }

    public final Stream<IndexTriple> sortedTriples(long streamSize, int n) {
        return ((Stream)Stream.generate(() -> this.nextSortedIntTriple(n)).sequential()).limit(streamSize);
    }

    public final Stream<IndexPair> sortedWindowedPairs(int n, int window) {
        return (Stream)Stream.generate(() -> this.nextSortedWindowedIntPair(n, window)).sequential();
    }

    public final Stream<IndexPair> sortedWindowedPairs(long streamSize, int n, int window) {
        return ((Stream)Stream.generate(() -> this.nextSortedWindowedIntPair(n, window)).sequential()).limit(streamSize);
    }

    public final Stream<IndexTriple> sortedWindowedTriples(int n, int window) {
        return (Stream)Stream.generate(() -> this.nextSortedWindowedIntTriple(n, window)).sequential();
    }

    public final Stream<IndexTriple> sortedWindowedTriples(long streamSize, int n, int window) {
        return ((Stream)Stream.generate(() -> this.nextSortedWindowedIntTriple(n, window)).sequential()).limit(streamSize);
    }

    public final Stream<IndexTriple> triples(int n) {
        return (Stream)Stream.generate(() -> this.nextIntTriple(n)).sequential();
    }

    public final Stream<IndexTriple> triples(long streamSize, int n) {
        return ((Stream)Stream.generate(() -> this.nextIntTriple(n)).sequential()).limit(streamSize);
    }

    public final Stream<IndexPair> windowedPairs(int n, int window) {
        return (Stream)Stream.generate(() -> this.nextWindowedIntPair(n, window)).sequential();
    }

    public final Stream<IndexPair> windowedPairs(long streamSize, int n, int window) {
        return ((Stream)Stream.generate(() -> this.nextWindowedIntPair(n, window)).sequential()).limit(streamSize);
    }

    public final Stream<IndexTriple> windowedTriples(int n, int window) {
        return (Stream)Stream.generate(() -> this.nextWindowedIntTriple(n, window)).sequential();
    }

    public final Stream<IndexTriple> windowedTriples(long streamSize, int n, int window) {
        return ((Stream)Stream.generate(() -> this.nextWindowedIntTriple(n, window)).sequential()).limit(streamSize);
    }

    @Override
    public final double nextGaussian() {
        return this.generatorForGaussians.nextGaussian();
    }

    @Override
    public final double nextGaussian(double mean, double stddev) {
        return this.generatorForGaussians.nextGaussian(mean, stddev);
    }

    @Override
    public final int nextInt(int bound) {
        return RandomIndexer.nextInt(bound, this.generator);
    }

    @Override
    public final int nextInt(int origin, int bound) {
        return RandomIndexer.nextInt(origin, bound, this.generator);
    }

    @Override
    public final IntStream ints(int randomNumberOrigin, int randomNumberBound) {
        return IntStream.generate(() -> this.nextInt(randomNumberOrigin, randomNumberBound)).sequential();
    }

    @Override
    public final IntStream ints(long streamSize, int randomNumberOrigin, int randomNumberBound) {
        return IntStream.generate(() -> this.nextInt(randomNumberOrigin, randomNumberBound)).sequential().limit(streamSize);
    }

    @Override
    public final DoubleStream doubles() {
        return this.generator.doubles();
    }

    @Override
    public final DoubleStream doubles(double randomNumberOrigin, double randomNumberBound) {
        return this.generator.doubles(randomNumberOrigin, randomNumberBound);
    }

    @Override
    public final DoubleStream doubles(long streamSize) {
        return this.generator.doubles(streamSize);
    }

    @Override
    public final DoubleStream doubles(long streamSize, double randomNumberOrigin, double randomNumberBound) {
        return this.generator.doubles(streamSize, randomNumberOrigin, randomNumberBound);
    }

    @Override
    public final IntStream ints() {
        return this.generator.ints();
    }

    @Override
    public final IntStream ints(long streamSize) {
        return this.generator.ints(streamSize);
    }

    @Override
    public final boolean isDeprecated() {
        return this.generator.isDeprecated();
    }

    @Override
    public final LongStream longs() {
        return this.generator.longs();
    }

    @Override
    public final LongStream longs(long randomNumberOrigin, long randomNumberBound) {
        return this.generator.longs(randomNumberOrigin, randomNumberBound);
    }

    @Override
    public final LongStream longs(long streamSize) {
        return this.generator.longs(streamSize);
    }

    @Override
    public final LongStream longs(long streamSize, long randomNumberOrigin, long randomNumberBound) {
        return this.generator.longs(streamSize, randomNumberOrigin, randomNumberBound);
    }

    @Override
    public final boolean nextBoolean() {
        return this.generator.nextBoolean();
    }

    @Override
    public final void nextBytes(byte[] bytes) {
        this.generator.nextBytes(bytes);
    }

    @Override
    public final double nextDouble() {
        return this.generator.nextDouble();
    }

    @Override
    public final double nextDouble(double bound) {
        return this.generator.nextDouble(bound);
    }

    @Override
    public final double nextDouble(double origin, double bound) {
        return this.generator.nextDouble(origin, bound);
    }

    @Override
    public final double nextExponential() {
        return this.generator.nextExponential();
    }

    @Override
    public final float nextFloat() {
        return this.generator.nextFloat();
    }

    @Override
    public final float nextFloat(float bound) {
        return this.generator.nextFloat(bound);
    }

    @Override
    public final float nextFloat(float origin, float bound) {
        return this.generator.nextFloat(origin, bound);
    }

    @Override
    public final int nextInt() {
        return this.generator.nextInt();
    }

    @Override
    public final long nextLong() {
        return this.generator.nextLong();
    }

    @Override
    public final long nextLong(long bound) {
        return this.generator.nextLong(bound);
    }

    @Override
    public final long nextLong(long origin, long bound) {
        return this.generator.nextLong(origin, bound);
    }

    static RandomGenerator internalGaussian(final RandomGenerator generator) {
        return generator instanceof SecureRandom ? new RandomGenerator(){

            @Override
            public long nextLong() {
                return generator.nextLong();
            }
        } : new RandomGenerator(){

            @Override
            public long nextLong() {
                throw new UnsupportedOperationException("This internal class is for use with Gaussians only. Something is implemented incorrectly.");
            }

            @Override
            public double nextGaussian() {
                return ZigguratGaussian.nextGaussian(generator);
            }

            @Override
            public double nextGaussian(double mean, double stdev) {
                return mean + stdev * ZigguratGaussian.nextGaussian(generator);
            }
        };
    }
}

