/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.math.rand;

import java.util.SplittableRandom;
import java.util.random.RandomGenerator;
import java.util.stream.Stream;
import org.cicirello.math.rand.EnhancedRandomGenerator;
import org.cicirello.math.rand.EnhancedStreamableGenerator;

public final class EnhancedSplittableGenerator
extends EnhancedStreamableGenerator
implements RandomGenerator.SplittableGenerator {
    private final RandomGenerator.SplittableGenerator generator;

    public EnhancedSplittableGenerator() {
        this(new SplittableRandom());
    }

    public EnhancedSplittableGenerator(long seed) {
        this(new SplittableRandom(seed));
    }

    public EnhancedSplittableGenerator(RandomGenerator.SplittableGenerator generator) {
        super(generator);
        this.generator = generator;
    }

    public EnhancedSplittableGenerator(String algorithmName) {
        this(RandomGenerator.SplittableGenerator.of(algorithmName));
    }

    public static EnhancedSplittableGenerator of(String algorithmName) {
        return new EnhancedSplittableGenerator(algorithmName);
    }

    @Override
    public final EnhancedSplittableGenerator split() {
        return new EnhancedSplittableGenerator(this.generator.split());
    }

    @Override
    public final EnhancedSplittableGenerator split(RandomGenerator.SplittableGenerator source) {
        return new EnhancedSplittableGenerator(this.generator.split(source));
    }

    public final Stream<EnhancedSplittableGenerator> esplits() {
        return this.generator.splits().map(gen -> new EnhancedSplittableGenerator((RandomGenerator.SplittableGenerator)gen));
    }

    public final Stream<EnhancedSplittableGenerator> esplits(long streamSize) {
        return this.generator.splits(streamSize).map(gen -> new EnhancedSplittableGenerator((RandomGenerator.SplittableGenerator)gen));
    }

    public final Stream<EnhancedSplittableGenerator> esplits(long streamSize, RandomGenerator.SplittableGenerator source) {
        return this.generator.splits(streamSize, source).map(gen -> new EnhancedSplittableGenerator((RandomGenerator.SplittableGenerator)gen));
    }

    public final Stream<EnhancedSplittableGenerator> esplits(RandomGenerator.SplittableGenerator source) {
        return this.generator.splits(source).map(gen -> new EnhancedSplittableGenerator((RandomGenerator.SplittableGenerator)gen));
    }

    @Override
    public final Stream<RandomGenerator.SplittableGenerator> splits() {
        return this.generator.splits().map(gen -> new EnhancedSplittableGenerator((RandomGenerator.SplittableGenerator)gen));
    }

    @Override
    public final Stream<RandomGenerator.SplittableGenerator> splits(long streamSize) {
        return this.generator.splits(streamSize).map(gen -> new EnhancedSplittableGenerator((RandomGenerator.SplittableGenerator)gen));
    }

    @Override
    public final Stream<RandomGenerator.SplittableGenerator> splits(long streamSize, RandomGenerator.SplittableGenerator source) {
        return this.generator.splits(streamSize, source).map(gen -> new EnhancedSplittableGenerator((RandomGenerator.SplittableGenerator)gen));
    }

    @Override
    public final Stream<RandomGenerator.SplittableGenerator> splits(RandomGenerator.SplittableGenerator source) {
        return this.generator.splits(source).map(gen -> new EnhancedSplittableGenerator((RandomGenerator.SplittableGenerator)gen));
    }

    @Override
    public final Stream<EnhancedRandomGenerator> erngs() {
        return this.esplits().map(x -> x);
    }

    @Override
    public final Stream<EnhancedRandomGenerator> erngs(long streamSize) {
        return this.esplits(streamSize).map(x -> x);
    }

    @Override
    public final Stream<RandomGenerator> rngs() {
        return this.splits().map(x -> x);
    }

    @Override
    public final Stream<RandomGenerator> rngs(long streamSize) {
        return this.splits(streamSize).map(x -> x);
    }
}

