/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.math.rand;

import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import java.util.random.RandomGenerator;
import org.cicirello.math.rand.IndexPair;
import org.cicirello.math.rand.IndexTriple;
import org.cicirello.math.rand.RandomSampler;
import org.cicirello.util.ArrayMinimumLengthEnforcer;
import org.cicirello.util.SortingNetwork;

public final class RandomIndexer {
    private RandomIndexer() {
    }

    public static boolean[] arrayMask(int n) {
        return RandomIndexer.arrayMask(n, ThreadLocalRandom.current());
    }

    public static boolean[] arrayMask(int n, RandomGenerator gen) {
        boolean[] result = new boolean[n];
        for (int i = 0; i < n; ++i) {
            result[i] = gen.nextBoolean();
        }
        return result;
    }

    public static boolean[] arrayMask(int n, int k) {
        return RandomIndexer.arrayMask(n, k, (RandomGenerator)ThreadLocalRandom.current());
    }

    public static boolean[] arrayMask(int n, int k, RandomGenerator gen) {
        boolean[] result = new boolean[n];
        if (k >= n) {
            Arrays.fill(result, true);
        } else {
            int[] indexes = RandomSampler.sample(n, k, null, gen);
            for (int i = 0; i < k; ++i) {
                result[indexes[i]] = true;
            }
        }
        return result;
    }

    public static boolean[] arrayMask(int n, double p) {
        return RandomIndexer.arrayMask(n, p, (RandomGenerator)ThreadLocalRandom.current());
    }

    public static boolean[] arrayMask(int n, double p, RandomGenerator gen) {
        boolean[] result = new boolean[n];
        if (p >= 1.0) {
            Arrays.fill(result, true);
        } else {
            int[] s = RandomSampler.sample(n, p, gen);
            for (int i = 0; i < s.length; ++i) {
                result[s[i]] = true;
            }
        }
        return result;
    }

    public static int nextBiasedInt(int bound) {
        if (bound < 1) {
            throw new IllegalArgumentException("bound must be positive");
        }
        return (int)((long)(ThreadLocalRandom.current().nextInt() & Integer.MAX_VALUE) * (long)bound >> 31);
    }

    public static int nextBiasedInt(int origin, int bound) {
        return origin + RandomIndexer.nextBiasedInt(bound - origin);
    }

    public static int nextBiasedInt(int origin, int bound, RandomGenerator gen) {
        return origin + RandomIndexer.nextBiasedInt(bound - origin, gen);
    }

    public static int nextBiasedInt(int bound, RandomGenerator gen) {
        if (bound < 1) {
            throw new IllegalArgumentException("bound must be positive");
        }
        return (int)((long)(gen.nextInt() & Integer.MAX_VALUE) * (long)bound >> 31);
    }

    public static int nextInt(int bound) {
        return RandomIndexer.nextInt(bound, ThreadLocalRandom.current());
    }

    public static int nextInt(int origin, int bound) {
        return RandomIndexer.nextInt(origin, bound, ThreadLocalRandom.current());
    }

    public static int nextInt(int origin, int bound, RandomGenerator gen) {
        return origin + RandomIndexer.nextInt(bound - origin, gen);
    }

    public static int nextInt(int bound, RandomGenerator gen) {
        if (bound < 1) {
            throw new IllegalArgumentException("bound must be positive");
        }
        long product = (long)(gen.nextInt() & Integer.MAX_VALUE) * (long)bound;
        int low31 = (int)product & Integer.MAX_VALUE;
        if (low31 < bound) {
            int threshold = (Integer.MIN_VALUE - bound) % bound;
            while (low31 < threshold) {
                product = (long)(gen.nextInt() & Integer.MAX_VALUE) * (long)bound;
                low31 = (int)product & Integer.MAX_VALUE;
            }
        }
        return (int)(product >> 31);
    }

    public static int[] nextIntPair(int n, int[] result) {
        return RandomIndexer.nextIntPair(n, result, ThreadLocalRandom.current());
    }

    public static int[] nextIntPair(int n, int[] result, RandomGenerator gen) {
        result = ArrayMinimumLengthEnforcer.enforce((int[])result, (int)2);
        result[0] = RandomIndexer.nextInt(n, gen);
        result[1] = RandomIndexer.nextInt(n - 1, gen);
        if (result[1] == result[0]) {
            result[1] = n - 1;
        }
        return result;
    }

    public static IndexPair nextIntPair(int n) {
        return RandomIndexer.nextIntPair(n, ThreadLocalRandom.current());
    }

    public static IndexPair nextIntPair(int n, RandomGenerator gen) {
        int j;
        int i;
        return new IndexPair(i, (i = RandomIndexer.nextInt(n, gen)) == (j = RandomIndexer.nextInt(n - 1, gen)) ? n - 1 : j);
    }

    public static int[] nextIntTriple(int n, int[] result) {
        return RandomIndexer.nextIntTriple(n, result, ThreadLocalRandom.current());
    }

    public static int[] nextIntTriple(int n, int[] result, RandomGenerator gen) {
        result = ArrayMinimumLengthEnforcer.enforce((int[])result, (int)3);
        result[0] = RandomIndexer.nextInt(n, gen);
        result[1] = RandomIndexer.nextInt(n - 1, gen);
        result[2] = RandomIndexer.nextInt(n - 2, gen);
        if (result[2] == result[1]) {
            result[2] = n - 2;
        }
        if (result[1] == result[0]) {
            result[1] = n - 1;
        }
        if (result[2] == result[0]) {
            result[2] = n - 1;
        }
        return result;
    }

    public static IndexTriple nextIntTriple(int n) {
        return RandomIndexer.nextIntTriple(n, ThreadLocalRandom.current());
    }

    public static IndexTriple nextIntTriple(int n, RandomGenerator gen) {
        int i = RandomIndexer.nextInt(n, gen);
        int j = RandomIndexer.nextInt(n - 1, gen);
        int k = RandomIndexer.nextInt(n - 2, gen);
        if (k == j) {
            k = n - 2;
        }
        return new IndexTriple(i, j == i ? n - 1 : j, k == i ? n - 1 : k);
    }

    public static int[] nextSortedIntPair(int n, int[] result) {
        return RandomIndexer.nextSortedIntPair(n, result, ThreadLocalRandom.current());
    }

    public static int[] nextSortedIntPair(int n, int[] result, RandomGenerator gen) {
        result = ArrayMinimumLengthEnforcer.enforce((int[])result, (int)2);
        result[0] = RandomIndexer.nextInt(n, gen);
        result[1] = RandomIndexer.nextInt(n - 1, gen);
        if (result[1] == result[0]) {
            result[1] = n - 1;
        } else {
            SortingNetwork.compareExchange((int[])result, (int)0, (int)1);
        }
        return result;
    }

    public static IndexPair nextSortedIntPair(int n) {
        return RandomIndexer.nextSortedIntPair(n, ThreadLocalRandom.current());
    }

    public static IndexPair nextSortedIntPair(int n, RandomGenerator gen) {
        IndexPair pair = RandomIndexer.nextIntPair(n, gen);
        if (pair.i() < pair.j()) {
            return pair;
        }
        return new IndexPair(pair.j(), pair.i());
    }

    public static int[] nextSortedIntTriple(int n, int[] result) {
        return RandomIndexer.nextSortedIntTriple(n, result, ThreadLocalRandom.current());
    }

    public static int[] nextSortedIntTriple(int n, int[] result, RandomGenerator gen) {
        result = RandomIndexer.nextIntTriple(n, result, gen);
        SortingNetwork.sort((int[])result, (int)0, (int)1, (int)2);
        return result;
    }

    public static IndexTriple nextSortedIntTriple(int n) {
        return RandomIndexer.nextSortedIntTriple(n, ThreadLocalRandom.current());
    }

    public static IndexTriple nextSortedIntTriple(int n, RandomGenerator gen) {
        IndexTriple triple = RandomIndexer.nextIntTriple(n, gen);
        return IndexTriple.sorted(triple.i(), triple.j(), triple.k());
    }

    public static int[] nextSortedWindowedIntPair(int n, int window, int[] result) {
        return RandomIndexer.nextSortedWindowedIntPair(n, window, result, ThreadLocalRandom.current());
    }

    public static int[] nextSortedWindowedIntPair(int n, int window, int[] result, RandomGenerator gen) {
        if (window >= n - 1) {
            return RandomIndexer.nextSortedIntPair(n, result, gen);
        }
        result = ArrayMinimumLengthEnforcer.enforce((int[])result, (int)2);
        int z1 = n - window;
        int z2 = z1 << 1;
        int i = RandomIndexer.nextInt(z2 + window - 1, gen);
        int j = RandomIndexer.nextInt(window, gen);
        if (i < z2) {
            result[0] = i >> 1;
            result[1] = result[0] + 1 + j;
        } else if ((i -= z1) == (j += z1)) {
            result[0] = j;
            result[1] = n - 1;
        } else if (i < j) {
            result[0] = i;
            result[1] = j;
        } else {
            result[0] = j;
            result[1] = i;
        }
        return result;
    }

    public static IndexPair nextSortedWindowedIntPair(int n, int window) {
        return RandomIndexer.nextSortedWindowedIntPair(n, window, ThreadLocalRandom.current());
    }

    public static IndexPair nextSortedWindowedIntPair(int n, int window, RandomGenerator gen) {
        if (window >= n - 1) {
            return RandomIndexer.nextSortedIntPair(n, gen);
        }
        int z1 = n - window;
        int z2 = z1 << 1;
        int i = RandomIndexer.nextInt(z2 + window - 1, gen);
        int j = RandomIndexer.nextInt(window, gen);
        if (i < z2) {
            return new IndexPair(i >>= 1, i + 1 + j);
        }
        if ((i -= z1) == (j += z1)) {
            return new IndexPair(j, n - 1);
        }
        if (i < j) {
            return new IndexPair(i, j);
        }
        return new IndexPair(j, i);
    }

    public static int[] nextSortedWindowedIntTriple(int n, int window, int[] result) {
        return RandomIndexer.nextSortedWindowedIntTriple(n, window, result, ThreadLocalRandom.current());
    }

    public static int[] nextSortedWindowedIntTriple(int n, int window, int[] result, RandomGenerator gen) {
        if (window >= n - 1) {
            return RandomIndexer.nextSortedIntTriple(n, result, gen);
        }
        result = ArrayMinimumLengthEnforcer.enforce((int[])result, (int)3);
        int z1 = n - window;
        int z3 = 3 * z1;
        int i = RandomIndexer.nextInt(z3 + window - 2, gen);
        int j = RandomIndexer.nextInt(window - 1, gen);
        int k = RandomIndexer.nextInt(window, gen);
        if (i < z3) {
            int q;
            result[0] = q = i / 3;
            if (j < k) {
                result[1] = q + 1 + j;
                result[2] = q + 1 + k;
            } else if (j == k) {
                result[1] = q + 1 + k;
                result[2] = q + window;
            } else {
                result[1] = q + 1 + k;
                result[2] = q + 1 + j;
            }
        } else {
            result[0] = i - z3 + z1;
            result[1] = z1 + (j == k ? window - 1 : j);
            result[2] = k + z1;
            SortingNetwork.compareExchange((int[])result, (int)1, (int)2);
            if (result[0] == result[1]) {
                result[0] = n - 2;
            }
            if (result[0] == result[2]) {
                result[0] = n - 1;
            }
            SortingNetwork.compareExchange((int[])result, (int)0, (int)1);
            SortingNetwork.compareExchange((int[])result, (int)1, (int)2);
        }
        return result;
    }

    public static IndexTriple nextSortedWindowedIntTriple(int n, int window) {
        return RandomIndexer.nextSortedWindowedIntTriple(n, window, ThreadLocalRandom.current());
    }

    public static IndexTriple nextSortedWindowedIntTriple(int n, int window, RandomGenerator gen) {
        int temp;
        if (window >= n - 1) {
            return RandomIndexer.nextSortedIntTriple(n, gen);
        }
        int z1 = n - window;
        int z3 = 3 * z1;
        int i = RandomIndexer.nextInt(z3 + window - 2, gen);
        int j = RandomIndexer.nextInt(window - 1, gen);
        int k = RandomIndexer.nextInt(window, gen);
        if (i < z3) {
            int q = i / 3;
            if (j < k) {
                return new IndexTriple(q, q + 1 + j, q + 1 + k);
            }
            return j == k ? new IndexTriple(q, q + 1 + k, q + window) : new IndexTriple(q, q + 1 + k, q + 1 + j);
        }
        i -= z3 - z1;
        if ((j = z1 + (j == k ? window - 1 : j)) > (k += z1)) {
            temp = j;
            j = k;
            k = temp;
        }
        if (i == j) {
            i = n - 2;
        }
        if (i == k) {
            i = n - 1;
        }
        if (i > j) {
            temp = i;
            i = j;
            j = temp;
        }
        if (j > k) {
            temp = j;
            j = k;
            k = temp;
        }
        return new IndexTriple(i, j, k);
    }

    public static int[] nextWindowedIntPair(int n, int window, int[] result) {
        return RandomIndexer.nextWindowedIntPair(n, window, result, ThreadLocalRandom.current());
    }

    public static int[] nextWindowedIntPair(int n, int window, int[] result, RandomGenerator gen) {
        if (window >= n - 1) {
            return RandomIndexer.nextIntPair(n, result, gen);
        }
        result = ArrayMinimumLengthEnforcer.enforce((int[])result, (int)2);
        int z1 = n - window;
        int z2 = z1 << 1;
        int i = RandomIndexer.nextInt(z2 + window - 1, gen);
        int j = RandomIndexer.nextInt(window, gen);
        if (i < z2) {
            int rightBit = i & 1;
            result[rightBit] = i >> 1;
            result[rightBit ^ 1] = result[rightBit] + 1 + j;
        } else {
            result[0] = (i -= z1) == (j += z1) ? n - 1 : i;
            result[1] = j;
        }
        return result;
    }

    public static IndexPair nextWindowedIntPair(int n, int window) {
        return RandomIndexer.nextWindowedIntPair(n, window, ThreadLocalRandom.current());
    }

    public static IndexPair nextWindowedIntPair(int n, int window, RandomGenerator gen) {
        if (window >= n - 1) {
            return RandomIndexer.nextIntPair(n, gen);
        }
        int z1 = n - window;
        int z2 = z1 << 1;
        int i = RandomIndexer.nextInt(z2 + window - 1, gen);
        int j = RandomIndexer.nextInt(window, gen);
        if (i < z2) {
            int rightBit = i & 1;
            return rightBit == 0 ? new IndexPair(i, i + 1 + j) : new IndexPair((i >>= 1) + 1 + j, i);
        }
        return new IndexPair((i -= z1) == (j += z1) ? n - 1 : i, j);
    }

    public static int[] nextWindowedIntTriple(int n, int window, int[] result) {
        return RandomIndexer.nextWindowedIntTriple(n, window, result, ThreadLocalRandom.current());
    }

    public static int[] nextWindowedIntTriple(int n, int window, int[] result, RandomGenerator gen) {
        int k;
        if (window >= n - 1) {
            return RandomIndexer.nextIntTriple(n, result, gen);
        }
        result = ArrayMinimumLengthEnforcer.enforce((int[])result, (int)3);
        int z1 = n - window;
        int z3 = 3 * z1;
        int i = RandomIndexer.nextInt(z3 + window - 2, gen);
        int j = RandomIndexer.nextInt(window - 1, gen);
        if (j == (k = RandomIndexer.nextInt(window, gen))) {
            j = window - 1;
        }
        if (i < z3) {
            int q = i / 3;
            int r = i % 3;
            result[r] = q;
            if (r == 2) {
                result[0] = q + 1 + j;
                result[1] = q + 1 + k;
            } else {
                result[r ^ 1] = q + 1 + j;
                result[2] = q + 1 + k;
            }
        } else {
            result[0] = i - z3 + z1;
            result[1] = j + z1;
            result[2] = k + z1;
            if (result[0] == result[1]) {
                result[0] = n - 2;
            }
            if (result[0] == result[2]) {
                result[0] = n - 1;
            }
            if (result[0] == result[1]) {
                result[0] = n - 2;
            }
        }
        return result;
    }

    public static IndexTriple nextWindowedIntTriple(int n, int window) {
        return RandomIndexer.nextWindowedIntTriple(n, window, ThreadLocalRandom.current());
    }

    public static IndexTriple nextWindowedIntTriple(int n, int window, RandomGenerator gen) {
        int k;
        if (window >= n - 1) {
            return RandomIndexer.nextIntTriple(n, gen);
        }
        int z1 = n - window;
        int z3 = 3 * z1;
        int i = RandomIndexer.nextInt(z3 + window - 2, gen);
        int j = RandomIndexer.nextInt(window - 1, gen);
        if (j == (k = RandomIndexer.nextInt(window, gen))) {
            j = window - 1;
        }
        if (i < z3) {
            int q = i / 3;
            switch (i % 3) {
                case 0: {
                    return new IndexTriple(q, q + 1 + j, q + 1 + k);
                }
                case 1: {
                    return new IndexTriple(q + 1 + j, q, q + 1 + k);
                }
            }
            return new IndexTriple(q + 1 + j, q + 1 + k, q);
        }
        k += z1;
        if ((i -= z3 - z1) == (j += z1)) {
            i = n - 2;
        }
        if (i == k) {
            i = n - 1;
        }
        if (i == j) {
            i = n - 2;
        }
        return new IndexTriple(i, j, k);
    }
}

