/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.math.rand;

import java.util.List;
import java.util.RandomAccess;
import java.util.concurrent.ThreadLocalRandom;
import java.util.random.RandomGenerator;
import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.util.SimpleSwapper;

public final class Shuffler {
    private Shuffler() {
    }

    public static void shuffle(byte[] array) {
        Shuffler.shuffle(array, (RandomGenerator)ThreadLocalRandom.current());
    }

    public static void shuffle(byte[] array, RandomGenerator gen) {
        int bound = array.length;
        while (bound >= 2) {
            SimpleSwapper.swap((byte[])array, (int)RandomIndexer.nextInt(bound, gen), (int)(--bound));
        }
    }

    public static void shuffle(byte[] array, int first, int last) {
        Shuffler.shuffle(array, first, last, (RandomGenerator)ThreadLocalRandom.current());
    }

    public static void shuffle(byte[] array, int first, int last, RandomGenerator gen) {
        int minBound = first + 2;
        while (last >= minBound) {
            SimpleSwapper.swap((byte[])array, (int)RandomIndexer.nextInt(first, last, gen), (int)(--last));
        }
    }

    public static void shuffle(char[] array) {
        Shuffler.shuffle(array, (RandomGenerator)ThreadLocalRandom.current());
    }

    public static void shuffle(char[] array, RandomGenerator gen) {
        int bound = array.length;
        while (bound >= 2) {
            SimpleSwapper.swap((char[])array, (int)RandomIndexer.nextInt(bound, gen), (int)(--bound));
        }
    }

    public static void shuffle(char[] array, int first, int last) {
        Shuffler.shuffle(array, first, last, (RandomGenerator)ThreadLocalRandom.current());
    }

    public static void shuffle(char[] array, int first, int last, RandomGenerator gen) {
        int minBound = first + 2;
        while (last >= minBound) {
            SimpleSwapper.swap((char[])array, (int)RandomIndexer.nextInt(first, last, gen), (int)(--last));
        }
    }

    public static void shuffle(double[] array) {
        Shuffler.shuffle(array, (RandomGenerator)ThreadLocalRandom.current());
    }

    public static void shuffle(double[] array, RandomGenerator gen) {
        int bound = array.length;
        while (bound >= 2) {
            SimpleSwapper.swap((double[])array, (int)RandomIndexer.nextInt(bound, gen), (int)(--bound));
        }
    }

    public static void shuffle(double[] array, int first, int last) {
        Shuffler.shuffle(array, first, last, (RandomGenerator)ThreadLocalRandom.current());
    }

    public static void shuffle(double[] array, int first, int last, RandomGenerator gen) {
        int minBound = first + 2;
        while (last >= minBound) {
            SimpleSwapper.swap((double[])array, (int)RandomIndexer.nextInt(first, last, gen), (int)(--last));
        }
    }

    public static void shuffle(float[] array) {
        Shuffler.shuffle(array, (RandomGenerator)ThreadLocalRandom.current());
    }

    public static void shuffle(float[] array, RandomGenerator gen) {
        int bound = array.length;
        while (bound >= 2) {
            SimpleSwapper.swap((float[])array, (int)RandomIndexer.nextInt(bound, gen), (int)(--bound));
        }
    }

    public static void shuffle(float[] array, int first, int last) {
        Shuffler.shuffle(array, first, last, (RandomGenerator)ThreadLocalRandom.current());
    }

    public static void shuffle(float[] array, int first, int last, RandomGenerator gen) {
        int minBound = first + 2;
        while (last >= minBound) {
            SimpleSwapper.swap((float[])array, (int)RandomIndexer.nextInt(first, last, gen), (int)(--last));
        }
    }

    public static void shuffle(int[] array) {
        Shuffler.shuffle(array, (RandomGenerator)ThreadLocalRandom.current());
    }

    public static void shuffle(int[] array, RandomGenerator gen) {
        int bound = array.length;
        while (bound >= 2) {
            SimpleSwapper.swap((int[])array, (int)RandomIndexer.nextInt(bound, gen), (int)(--bound));
        }
    }

    public static void shuffle(int[] array, int first, int last) {
        Shuffler.shuffle(array, first, last, (RandomGenerator)ThreadLocalRandom.current());
    }

    public static void shuffle(int[] array, int first, int last, RandomGenerator gen) {
        int minBound = first + 2;
        while (last >= minBound) {
            SimpleSwapper.swap((int[])array, (int)RandomIndexer.nextInt(first, last, gen), (int)(--last));
        }
    }

    public static void shuffle(long[] array) {
        Shuffler.shuffle(array, (RandomGenerator)ThreadLocalRandom.current());
    }

    public static void shuffle(long[] array, RandomGenerator gen) {
        int bound = array.length;
        while (bound >= 2) {
            SimpleSwapper.swap((long[])array, (int)RandomIndexer.nextInt(bound, gen), (int)(--bound));
        }
    }

    public static void shuffle(long[] array, int first, int last) {
        Shuffler.shuffle(array, first, last, (RandomGenerator)ThreadLocalRandom.current());
    }

    public static void shuffle(long[] array, int first, int last, RandomGenerator gen) {
        int minBound = first + 2;
        while (last >= minBound) {
            SimpleSwapper.swap((long[])array, (int)RandomIndexer.nextInt(first, last, gen), (int)(--last));
        }
    }

    public static void shuffle(short[] array) {
        Shuffler.shuffle(array, (RandomGenerator)ThreadLocalRandom.current());
    }

    public static void shuffle(short[] array, RandomGenerator gen) {
        int bound = array.length;
        while (bound >= 2) {
            SimpleSwapper.swap((short[])array, (int)RandomIndexer.nextInt(bound, gen), (int)(--bound));
        }
    }

    public static void shuffle(short[] array, int first, int last) {
        Shuffler.shuffle(array, first, last, (RandomGenerator)ThreadLocalRandom.current());
    }

    public static void shuffle(short[] array, int first, int last, RandomGenerator gen) {
        int minBound = first + 2;
        while (last >= minBound) {
            SimpleSwapper.swap((short[])array, (int)RandomIndexer.nextInt(first, last, gen), (int)(--last));
        }
    }

    public static <T> void shuffle(T[] array) {
        Shuffler.shuffle(array, (RandomGenerator)ThreadLocalRandom.current());
    }

    public static <T> void shuffle(T[] array, RandomGenerator gen) {
        int bound = array.length;
        while (bound >= 2) {
            SimpleSwapper.swap((Object[])array, (int)RandomIndexer.nextInt(bound, gen), (int)(--bound));
        }
    }

    public static <T> void shuffle(T[] array, int first, int last) {
        Shuffler.shuffle(array, first, last, (RandomGenerator)ThreadLocalRandom.current());
    }

    public static <T> void shuffle(T[] array, int first, int last, RandomGenerator gen) {
        int minBound = first + 2;
        while (last >= minBound) {
            SimpleSwapper.swap((Object[])array, (int)RandomIndexer.nextInt(first, last, gen), (int)(--last));
        }
    }

    public static <T> void shuffle(List<T> list) {
        Shuffler.shuffle(list, (RandomGenerator)ThreadLocalRandom.current());
    }

    public static <T> void shuffle(List<T> list, RandomGenerator gen) {
        if (list instanceof RandomAccess) {
            int bound = list.size();
            while (bound >= 2) {
                SimpleSwapper.swap(list, (int)RandomIndexer.nextInt(bound, gen), (int)(--bound));
            }
        } else {
            Object[] array = list.toArray();
            Shuffler.shuffle(array, gen);
            list.clear();
            for (int i = 0; i < array.length; ++i) {
                Object element = array[i];
                list.add(element);
            }
        }
    }

    public static <T> void shuffle(List<T> list, int first, int last) {
        Shuffler.shuffle(list, first, last, (RandomGenerator)ThreadLocalRandom.current());
    }

    public static <T> void shuffle(List<T> list, int first, int last, RandomGenerator gen) {
        if (list instanceof RandomAccess) {
            int minBound = first + 2;
            while (last >= minBound) {
                SimpleSwapper.swap(list, (int)RandomIndexer.nextInt(first, last, gen), (int)(--last));
            }
        } else {
            Object[] array = list.toArray();
            Shuffler.shuffle(array, first, last, gen);
            list.clear();
            for (int i = 0; i < array.length; ++i) {
                Object element = array[i];
                list.add(element);
            }
        }
    }
}

