/*
 * Decompiled with CFR 0.152.
 */
package org.cicomponents.ci;

import org.cicomponents.NodeConfiguration;
import org.cicomponents.OutputProviderService;
import org.cicomponents.ResourceEmitter;
import org.cicomponents.ResourceHolder;
import org.cicomponents.ResourceListener;
import org.cicomponents.ci.Builder;
import org.cicomponents.git.GitRevision;
import org.cicomponents.github.GithubPullRequest;
import org.kohsuke.github.GHCommitState;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"github-repository=cicomponents/cicomponents"})
public class PullRequestListener
implements ResourceListener<GithubPullRequest> {
    private static final Logger log = LoggerFactory.getLogger(PullRequestListener.class);
    @Reference
    protected OutputProviderService outputProviderService;
    @Reference
    protected NodeConfiguration configuration;

    public void onEmittedResource(ResourceHolder<GithubPullRequest> holder, ResourceEmitter<GithubPullRequest> emitter) {
        try (GithubPullRequest resource = (GithubPullRequest)holder.acquire();){
            log.info("Received pull request " + resource.getPullRequest().getNumber());
            String sha = resource.getPullRequest().getHead().getSha();
            resource.getPullRequest().getRepository().createCommitStatus(sha, GHCommitState.PENDING, this.configuration.getUrl() + "/ci/" + sha, "Build in progress", "cicomponents");
            Boolean result = new Builder((GitRevision)resource, this.outputProviderService).get();
            resource.getPullRequest().getRepository().createCommitStatus(sha, result != false ? GHCommitState.SUCCESS : GHCommitState.FAILURE, this.configuration.getUrl() + "/ci/" + sha, result != false ? "Success" : "Failure", "cicomponents");
        }
    }
}

