/*
 * Decompiled with CFR 0.152.
 */
package org.cicomponents.ci;

import java.io.OutputStream;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.cicomponents.OutputProvider;
import org.cicomponents.OutputProviderService;
import org.cicomponents.git.GitRevision;
import org.eclipse.jgit.api.Git;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.ResultHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Builder
implements Supplier<Boolean> {
    private static final Logger log = LoggerFactory.getLogger(Builder.class);
    private final GitRevision resource;
    private final OutputProviderService outputProviderService;

    Builder(GitRevision resource, OutputProviderService outputProviderService) {
        this.resource = resource;
        this.outputProviderService = outputProviderService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean get() {
        Boolean result = false;
        GradleConnector connector = GradleConnector.newConnector();
        Git repository = this.resource.getRepository();
        log.info("Building {}", (Object)repository);
        connector.forProjectDirectory(this.resource.getRepository().getRepository().getDirectory().getParentFile());
        try (ProjectConnection connection = null;){
            connection = connector.connect();
            OutputProvider outputProvider = this.outputProviderService.createOutputProvider();
            OutputStream standardOutput = outputProvider.getStandardOutput();
            OutputStream standardError = outputProvider.getStandardError();
            BuildLauncher buildLauncher = (BuildLauncher)((BuildLauncher)connection.newBuild().forTasks(new String[]{"dist", "check"}).setStandardOutput(standardOutput)).setStandardError(standardError);
            final CompletableFuture future = new CompletableFuture();
            buildLauncher.run((ResultHandler)new ResultHandler<Void>(){

                public void onComplete(Void result) {
                    future.complete(true);
                }

                public void onFailure(GradleConnectionException failure) {
                    future.complete(false);
                }
            });
            result = (Boolean)future.join();
            standardOutput.close();
            standardError.close();
        }
        return result;
    }
}

