/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.kohsuke.github.BranchProtection;
import org.kohsuke.github.EnforcementLevel;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.Requester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD", "URF_UNREAD_FIELD"}, justification="JSON API")
public class GHBranch {
    private GitHub root;
    private GHRepository owner;
    private String name;
    private Commit commit;

    public GitHub getRoot() {
        return this.root;
    }

    public GHRepository getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    public String getSHA1() {
        return this.commit.sha;
    }

    public void disableProtection() throws IOException {
        BranchProtection bp = new BranchProtection();
        bp.enabled = false;
        this.setProtection(bp);
    }

    public void enableProtection(EnforcementLevel level, Collection<String> contexts) throws IOException {
        BranchProtection bp = new BranchProtection();
        bp.enabled = true;
        bp.requiredStatusChecks = new BranchProtection.RequiredStatusChecks();
        bp.requiredStatusChecks.enforcement_level = level;
        bp.requiredStatusChecks.contexts.addAll(contexts);
        this.setProtection(bp);
    }

    public void enableProtection(EnforcementLevel level, String ... contexts) throws IOException {
        this.enableProtection(level, Arrays.asList(contexts));
    }

    private void setProtection(BranchProtection bp) throws IOException {
        new Requester(this.root).method("PATCH").withHeader("Accept", "application/vnd.github.loki-preview+json")._with("protection", bp).to(this.getApiRoute());
    }

    String getApiRoute() {
        return this.owner.getApiTailUrl("/branches/" + this.name);
    }

    public String toString() {
        String url = this.owner != null ? this.owner.getUrl().toString() : "unknown";
        return "Branch:" + this.name + " in " + url;
    }

    GHBranch wrap(GHRepository repo) {
        this.owner = repo;
        this.root = repo.root;
        return this;
    }

    public static class Commit {
        String sha;
        @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="We don't provide it in API now")
        String url;
    }
}

