/*
 * Decompiled with CFR 0.152.
 */
package org.cicomponents.ci;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.cicomponents.ci.GithubApplicationConfiguration;
import org.cicomponents.github.GithubApplicationCredentialsProvider;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.ServiceScope;

@Component(scope=ServiceScope.SINGLETON, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true)
public class GithubApplication
implements GithubApplicationCredentialsProvider {
    private String clientId;
    private String clientSecret;
    private List<String> repositories;

    @Activate
    protected void activate(GithubApplicationConfiguration configuration) {
        this.clientId = configuration.clientId();
        this.clientSecret = configuration.clientSecret();
        this.repositories = Arrays.stream(configuration.repositories().split(",")).map(String::trim).collect(Collectors.toList());
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public List<String> getRepositories() {
        return this.repositories;
    }
}

