/*
 * Decompiled with CFR 0.152.
 */
package org.cicomponents.ci;

import java.io.IOException;
import java.util.Base64;
import java.util.concurrent.ForkJoinPool;
import javax.servlet.AsyncContext;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cicomponents.PersistentMap;
import org.cicomponents.badges.BadgeMaker;
import org.cicomponents.badges.BadgeProperty;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(asyncSupported=true, urlPatterns={"/ci/*"})
@Component
public class StatusServlet
extends HttpServlet
implements Servlet {
    private static final Logger log = LoggerFactory.getLogger(StatusServlet.class);
    @Reference
    protected BadgeMaker badgeMaker;
    @Reference
    protected PersistentMap pmap;

    protected void doGet(HttpServletRequest req, final HttpServletResponse resp) throws ServletException, IOException {
        final AsyncContext asyncContext = req.startAsync();
        ForkJoinPool.commonPool().execute(new Runnable(){

            @Override
            public void run() {
                byte[] badge;
                resp.setContentType("text/html");
                if (StatusServlet.this.pmap.get((Object)"build-status") == null) {
                    badge = StatusServlet.this.badgeMaker.make(new BadgeProperty[]{BadgeMaker.subject((String)"build"), BadgeMaker.status((String)"unknown"), BadgeMaker.statusColor((String)"lightgrey")});
                } else {
                    String buildStatus = (String)StatusServlet.this.pmap.get((Object)"build-status");
                    badge = StatusServlet.this.badgeMaker.make(new BadgeProperty[]{BadgeMaker.subject((String)"build"), BadgeMaker.status((String)buildStatus), BadgeMaker.statusColor((String)(buildStatus.contentEquals("passing") ? "brightgreen" : "red"))});
                }
                resp.getWriter().write("Current status: <img src=\"data:image/svg+xml;base64," + Base64.getEncoder().encodeToString(badge) + "\">");
                asyncContext.complete();
            }
        });
    }
}

