/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.core;

import java.util.Collections;
import java.util.Vector;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.util.ContainerUtil;
import org.w3c.dom.NodeList;

public class VElement
extends Vector<KElement> {
    private static final long serialVersionUID = 1L;

    public VElement() {
    }

    public VElement(Vector m) {
        this.addAll(m);
    }

    public VElement(NodeList n) {
        if (n != null) {
            int len = n.getLength();
            for (int i = 0; i < len; ++i) {
                if (n.item(i).getNodeType() != 1) continue;
                this.addElement((KElement)n.item(i));
            }
        }
    }

    @Override
    public String toString() {
        return "VElement[ --> " + super.toString() + " ]";
    }

    public int index(KElement s) {
        if (s == null) {
            return -1;
        }
        String id = s.getAttribute_KElement("ID", null, null);
        for (int i = 0; i < this.size(); ++i) {
            if (!(id != null ? id.equals(this.elementAt(i).getAttribute_KElement("ID", null, null)) : this.elementAt(i).isEqual(s))) continue;
            return i;
        }
        return -1;
    }

    @Deprecated
    public boolean hasElement(KElement kElem) {
        return this.index(kElem) >= 0;
    }

    @Deprecated
    public void appendUniqueNotNull(KElement v) {
        if (v != null && !this.contains(v)) {
            this.addElement(v);
        }
    }

    @Deprecated
    public void appendUniqueNotNull(VElement v) {
        if (v != null) {
            for (int i = 0; i < v.size(); ++i) {
                this.appendUniqueNotNull(v.elementAt(i));
            }
        }
    }

    public void appendUnique(KElement elem) {
        if (elem == null) {
            return;
        }
        if (this.index(elem) < 0) {
            this.addElement(elem);
        }
    }

    public void addAll(VElement elem) {
        if (elem == null || elem.size() == 0) {
            return;
        }
        super.addAll(elem);
    }

    public <a extends KElement> void addAll(a[] l) {
        if (l == null) {
            return;
        }
        this.ensureCapacity(this.size() + l.length);
        for (int i = 0; i < l.length; ++i) {
            if (l[i] == null) continue;
            this.add(l[i]);
        }
    }

    public boolean containsElement(KElement elem) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!elem.isEqual(this.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    public boolean isEqual(VElement v) {
        int size = this.size();
        if (v == null) {
            return size == 0;
        }
        if (size != v.size()) {
            return false;
        }
        VElement v0 = new VElement(this);
        VElement v1 = new VElement(v);
        v0.sort();
        v1.sort();
        for (int i = 0; i < size; ++i) {
            if (v0.get(i).isEqual(v1.get(i))) continue;
            return false;
        }
        return true;
    }

    public void appendUnique(VElement v) {
        if (v == null) {
            return;
        }
        this.addAll(v);
        this.unify();
    }

    public void appendUniqueElement(VElement v) {
        if (v == null) {
            return;
        }
        this.addAll(v);
        this.unifyElement();
    }

    public void setAttributes(String key, Vector<String> vValue, String nameSpaceURI) {
        if (this.size() != vValue.size()) {
            throw new IllegalArgumentException("VElement.SetAttributes: size mismatch " + this.size() + " != " + vValue.size());
        }
        for (int i = 0; i < this.size(); ++i) {
            KElement k = this.elementAt(i);
            k.setAttribute(key, vValue.elementAt(i), nameSpaceURI);
        }
    }

    public void sort() {
        Collections.sort(this, new KElement.SimpleNodeComparator());
    }

    public void setAttribute(String key, String value, String nameSpaceURI) {
        int siz = this.size();
        for (int i = 0; i < siz; ++i) {
            KElement k = this.elementAt(i);
            k.setAttribute(key, value, nameSpaceURI);
        }
    }

    public void removeAttribute(String key, String nameSpaceURI) {
        int siz = this.size();
        for (int i = 0; i < siz; ++i) {
            KElement k = this.elementAt(i);
            k.removeAttribute(key, nameSpaceURI);
        }
    }

    public void removeElements(VElement v) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!v.containsElement(this.elementAt(i))) continue;
            this.removeElementAt(i);
        }
    }

    public void removeElements(KElement e, int nMax) {
        int j = 0;
        for (int i = this.size() - 1; i >= 0; --i) {
            if (e != this.elementAt(i)) continue;
            this.removeElementAt(i);
            if (++j == nMax) break;
        }
    }

    public VString getElementNameVector(boolean bLocal) {
        VString v = new VString();
        int size = this.size();
        v.ensureCapacity(size);
        for (int i = 0; i < size; ++i) {
            v.add(bLocal ? this.item(i).getLocalName() : this.item(i).getNodeName());
        }
        return v;
    }

    public VElement toVector(String element, JDFAttributeMap mAttrib, boolean bAnd, String nameSpaceURI) {
        VElement v = new VElement();
        boolean bWantName = KElement.isWildCard(element);
        boolean bWantNS = KElement.isWildCard(nameSpaceURI);
        int len = this.size();
        if (len > 0) {
            this.elementAt(len - 1);
        }
        for (int i = 0; i < len; ++i) {
            KElement k = this.elementAt(i);
            if (bWantName && !k.getNodeName().equals(element) || bWantNS && !k.getNamespaceURI().equals(nameSpaceURI) || !k.includesAttributes(mAttrib, bAnd)) continue;
            v.addElement(k);
        }
        return v;
    }

    @Override
    public KElement elementAt(int index) {
        if (index < 0) {
            index += this.size();
        }
        if (this.size() <= index) {
            return null;
        }
        return (KElement)super.elementAt(index);
    }

    @Override
    public KElement get(int index) {
        if (index < 0) {
            index += this.size();
        }
        if (this.size() <= index) {
            return null;
        }
        return (KElement)super.get(index);
    }

    public KElement item(int index) {
        return this.elementAt(index);
    }

    KElement getCommonAncestor() {
        KElement ret;
        int siz = this.size();
        if (siz == 0) {
            return null;
        }
        if (siz == 1) {
            return this.elementAt(0);
        }
        for (ret = this.elementAt(0); ret != null; ret = ret.getParentNode_KElement()) {
            boolean bOK = true;
            for (int i = 1; i < siz; ++i) {
                if (ret.isAncestor(this.elementAt(i))) continue;
                bOK = false;
                break;
            }
            if (!bOK) continue;
            return ret;
        }
        return ret;
    }

    public void unify() {
        ContainerUtil.unify(this);
    }

    public void unifyElement() {
        this.unify();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            KElement e = this.item(i);
            for (int j = size - 1; j > i; --j) {
                KElement e2 = this.item(j);
                if (!e.isEqual(e2)) continue;
                this.removeElementAt(j);
                --size;
            }
        }
    }
}

