/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XNIException;
import org.cip4.jdflib.core.DocumentXMLImpl;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.XMLDoc;
import org.cip4.jdflib.core.XMLErrorHandler;
import org.cip4.jdflib.util.SkipInputStream;
import org.cip4.jdflib.util.UrlUtil;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class XMLParser
extends DOMParser {
    public XMLErrorHandler m_ErrorHandler = null;
    protected String m_SchemaLocation = null;
    public Exception m_lastExcept = null;
    public static boolean m_searchStream = false;
    public boolean ignoreNSDefault = false;
    public boolean m_eraseEmpty = true;
    protected Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public String getDocumentClass() {
        return DocumentXMLImpl.class.getName();
    }

    public XMLParser() {
    }

    @Deprecated
    public XMLParser(String strDocType) {
        this();
    }

    public XMLParser(XMLParser parser) {
        this();
        this.m_eraseEmpty = parser.m_eraseEmpty;
        this.initParser(this.m_SchemaLocation, (XMLErrorHandler)parser.getErrorHandler());
    }

    public XMLDoc parseFile(String strFile) {
        File file = UrlUtil.urlToFile(strFile);
        return this.parseFile(file);
    }

    public XMLDoc parseFile(File file) {
        if (file == null) {
            return null;
        }
        XMLDoc doc = null;
        if (file.canRead()) {
            try {
                doc = this.parseStream(new FileInputStream(file));
                if (doc != null) {
                    doc.setOriginalFileName(file.getAbsolutePath());
                }
                return doc;
            }
            catch (FileNotFoundException e) {
                this.log.error((Object)"cannot find file to parse:", (Throwable)e);
                return null;
            }
        }
        return doc;
    }

    public XMLDoc parseString(String stringInput) {
        ByteArrayInputStream is;
        if (stringInput == null) {
            this.log.error((Object)"cannot parse null string");
            return null;
        }
        try {
            is = new ByteArrayInputStream(stringInput.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException x) {
            this.log.warn((Object)"bad encoding ", (Throwable)x);
            is = new ByteArrayInputStream(stringInput.getBytes());
        }
        return this.parseStream(is);
    }

    public XMLDoc parseStream(InputStream inStream) {
        if (inStream == null) {
            return null;
        }
        XMLReaderStream bis = new XMLReaderStream(false, inStream);
        bis.mark(0);
        InputSource inSource = new InputSource(bis);
        XMLDoc d = this.parseInputSource(inSource);
        if (d == null && m_searchStream) {
            try {
                bis.reset();
            }
            catch (IOException x) {
                bis.allowClose = true;
                bis.close();
                this.log.error((Object)"Error parsing stream", (Throwable)x);
                return null;
            }
            inSource = new InputSource(new XMLReaderStream(true, bis));
            d = this.parseInputSource(inSource);
        }
        bis.allowClose = true;
        bis.close();
        return d;
    }

    public void parse(InputSource inSource) {
        this.parseInputSource(inSource);
    }

    public XMLDoc parseInputSource(InputSource inSource) {
        XMLDoc jdfDoc = null;
        if (inSource != null) {
            this.initParser(this.m_SchemaLocation, this.m_ErrorHandler);
            jdfDoc = this.runParser(inSource, this.m_eraseEmpty);
        }
        return jdfDoc;
    }

    protected void initParser(String schemaLocation, XMLErrorHandler errorHandler) {
        this.m_SchemaLocation = schemaLocation;
        this.m_ErrorHandler = errorHandler;
        try {
            if (this.m_SchemaLocation == null || this.m_SchemaLocation.equals("")) {
                this.setFeature("http://xml.org/sax/features/validation", false);
                this.setFeature("http://apache.org/xml/features/validation/schema", false);
            } else {
                this.setFeature("http://xml.org/sax/features/validation", true);
                this.setFeature("http://apache.org/xml/features/validation/schema", true);
                this.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", this.m_SchemaLocation);
            }
            this.setProperty("http://apache.org/xml/properties/dom/document-class-name", this.getDocumentClass());
            this.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
            this.setFeature("http://xml.org/sax/features/namespaces", true);
            this.setErrorHandler(errorHandler);
        }
        catch (SAXNotRecognizedException e) {
            this.log.error((Object)"error parsing", (Throwable)e);
            this.m_lastExcept = e;
        }
        catch (SAXNotSupportedException e) {
            this.log.error((Object)"error parsing", (Throwable)e);
            this.m_lastExcept = e;
        }
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.m_ErrorHandler = handler != null && handler instanceof XMLErrorHandler ? (XMLErrorHandler)handler : new XMLErrorHandler();
        super.setErrorHandler((ErrorHandler)this.m_ErrorHandler);
    }

    protected XMLDoc runParser(InputSource inSource, boolean bEraseEmpty) {
        XMLDoc doc = this.getXMLDoc();
        try {
            super.parse(inSource);
            doc.setMemberDoc((DocumentXMLImpl)((Object)this.getDocument()));
            if (bEraseEmpty) {
                doc.getRoot().eraseEmptyNodes(true);
            }
        }
        catch (Exception e) {
            this.m_lastExcept = e;
            this.log.error((Object)"error parsing", (Throwable)e);
            doc = null;
        }
        catch (StackOverflowError e) {
            this.m_lastExcept = null;
            this.log.error((Object)"error parsing", (Throwable)e);
            doc = null;
        }
        if (doc != null && this.m_ErrorHandler != null) {
            doc.setValidationResult(this.m_ErrorHandler.getXMLOutput());
            this.m_ErrorHandler.cleanXML(this.m_SchemaLocation);
        }
        if (doc != null) {
            KElement root = doc.getRoot();
            DocumentXMLImpl memberDocument = doc.getMemberDocument();
            String namespaceURI = root.getNamespaceURI();
            this.setDocumentProperties(root, memberDocument, namespaceURI);
            memberDocument.setIgnoreNSDefault(this.ignoreNSDefault);
        }
        return doc;
    }

    protected XMLDoc getXMLDoc() {
        XMLDoc doc = new XMLDoc();
        return doc;
    }

    protected void setDocumentProperties(KElement root, DocumentXMLImpl memberDocument, String namespaceURI) {
    }

    public void setSchemaLocation(String nsURI, String locationURL) {
        this.m_SchemaLocation = nsURI + " " + locationURL;
    }

    public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
        super.startDocument(locator, encoding, namespaceContext, augs);
        DocumentXMLImpl memberDocument = (DocumentXMLImpl)((Object)this.getDocument());
        memberDocument.setIgnoreNSDefault(this.ignoreNSDefault);
    }

    public void cleanup() {
        this.m_lastExcept = null;
        this.ignoreNSDefault = false;
        this.m_eraseEmpty = true;
        this.m_ErrorHandler = null;
        this.m_SchemaLocation = null;
    }

    private class XMLReaderStream
    extends SkipInputStream {
        protected boolean allowClose;

        public XMLReaderStream(boolean searchXML, InputStream stream) {
            super(searchXML ? "<?xml" : null, stream, searchXML, 10000);
            this.allowClose = false;
        }

        @Override
        public void close() {
            try {
                if (this.allowClose) {
                    super.close();
                }
            }
            catch (Exception x) {
                XMLParser.this.log.error((Object)"Error closing reader stream", (Throwable)x);
            }
        }
    }
}

