/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.datatypes;

import java.util.Vector;
import java.util.zip.DataFormatException;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFDurationRange;
import org.cip4.jdflib.datatypes.JDFRangeList;
import org.cip4.jdflib.util.JDFDuration;
import org.cip4.jdflib.util.StringUtil;

public class JDFDurationRangeList
extends JDFRangeList {
    public JDFDurationRangeList() {
    }

    public static JDFDurationRangeList createDurationRangeList(String s) {
        if (s != null && s.length() > 0) {
            try {
                return new JDFDurationRangeList(s);
            }
            catch (DataFormatException x) {
                return null;
            }
        }
        return null;
    }

    public JDFDurationRangeList(String s) throws DataFormatException {
        if (s != null && !s.equals("")) {
            this.setString(s);
        }
    }

    public JDFDurationRangeList(JDFDurationRangeList rl) {
        this.rangeList = new Vector(rl.rangeList);
    }

    public boolean inRange(JDFDuration x) {
        int sz = this.rangeList.size();
        for (int i = 0; i < sz; ++i) {
            JDFDurationRange r = (JDFDurationRange)this.rangeList.elementAt(i);
            if (!r.inRange(x)) continue;
            return true;
        }
        return false;
    }

    public void setString(String s) throws DataFormatException {
        if (s.indexOf("~") == 0 || s.lastIndexOf("~") == s.length() - 1) {
            throw new DataFormatException("JDFDurationRangeList::SetString: Illegal string " + s);
        }
        String zappedWS = StringUtil.zappTokenWS(s, "~");
        VString v = StringUtil.tokenize(zappedWS, " \t", false);
        VString vs = new VString(v);
        this.rangeList.clear();
        for (int i = 0; i < vs.size(); ++i) {
            String str = vs.elementAt(i);
            try {
                JDFDurationRange dr = new JDFDurationRange(str);
                this.rangeList.addElement(dr);
                continue;
            }
            catch (DataFormatException dfe) {
                throw new DataFormatException("JDFDurationRangeList::SetString: Illegal string " + s);
            }
        }
    }

    public boolean isValid(String s) {
        try {
            new JDFDurationRangeList(s);
        }
        catch (DataFormatException e) {
            return false;
        }
        return true;
    }

    public void append(JDFDurationRange r) {
        this.rangeList.addElement(r);
    }

    public void append(JDFDuration xMin, JDFDuration xMax) {
        this.append(new JDFDurationRange(xMin, xMax));
    }

    public void append(JDFDuration x) {
        this.append(new JDFDurationRange(x, x));
    }

    @Override
    public boolean isOrdered() {
        int siz = this.rangeList.size();
        if (siz == 0) {
            return false;
        }
        Vector<JDFDuration> v = new Vector<JDFDuration>();
        for (int i = 0; i < siz; ++i) {
            JDFDurationRange r = (JDFDurationRange)this.rangeList.elementAt(i);
            v.addElement(r.getLeft());
            if (r.getLeft().equals(r.getRight())) continue;
            v.addElement(r.getRight());
        }
        int n = v.size() - 1;
        if (n == 0) {
            return true;
        }
        JDFDuration first = (JDFDuration)v.elementAt(0);
        JDFDuration last = (JDFDuration)v.elementAt(n);
        for (int j = 0; j < n; ++j) {
            JDFDuration value = (JDFDuration)v.elementAt(j);
            JDFDuration nextvalue = (JDFDuration)v.elementAt(j + 1);
            if (first.equals(last) && value.equals(nextvalue) || first.isShorter(last) && (value.isShorter(nextvalue) || value.equals(nextvalue)) || first.isLonger(last) && (value.isLonger(nextvalue) || value.equals(nextvalue))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isUniqueOrdered() {
        JDFDuration last;
        int siz = this.rangeList.size();
        if (siz == 0) {
            return false;
        }
        Vector<JDFDuration> v = new Vector<JDFDuration>();
        for (int i = 0; i < siz; ++i) {
            JDFDurationRange r = (JDFDurationRange)this.rangeList.elementAt(i);
            v.addElement(r.getLeft());
            if (r.getLeft().equals(r.getRight())) continue;
            v.addElement(r.getRight());
        }
        int n = v.size() - 1;
        if (n == 0) {
            return true;
        }
        JDFDuration first = (JDFDuration)v.elementAt(0);
        if (first.equals(last = (JDFDuration)v.elementAt(n))) {
            return false;
        }
        for (int j = 0; j < n; ++j) {
            JDFDuration value = (JDFDuration)v.elementAt(j);
            JDFDuration nextvalue = (JDFDuration)v.elementAt(j + 1);
            if (first.isShorter(last) && value.isShorter(nextvalue) || first.isLonger(last) && value.isLonger(nextvalue)) continue;
            return false;
        }
        return true;
    }
}

