/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.datatypes;

import java.util.Vector;
import java.util.zip.DataFormatException;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFNumberRange;
import org.cip4.jdflib.datatypes.JDFRangeList;
import org.cip4.jdflib.util.StringUtil;

public class JDFNumberRangeList
extends JDFRangeList {
    public static JDFNumberRangeList createNumberRangeList(String s) {
        if (s != null && s.length() > 0) {
            try {
                return new JDFNumberRangeList(s);
            }
            catch (DataFormatException x) {
                return null;
            }
        }
        return null;
    }

    public JDFNumberRangeList() {
    }

    public JDFNumberRangeList(String s) throws DataFormatException {
        if (s != null && !s.equals("")) {
            this.setString(s);
        }
    }

    public JDFNumberRangeList(JDFNumberRangeList rl) {
        this.rangeList = new Vector(rl.rangeList);
    }

    public JDFNumberRangeList(JDFNumberRange r) {
        this.append(r);
    }

    public boolean inRange(double x) {
        int sz = this.rangeList.size();
        for (int i = 0; i < sz; ++i) {
            JDFNumberRange r = (JDFNumberRange)this.rangeList.elementAt(i);
            if (!r.inRange(x)) continue;
            return true;
        }
        return false;
    }

    public void setString(String s) throws DataFormatException {
        if (s.indexOf("~") == 0 || s.lastIndexOf("~") == s.length() - 1) {
            throw new DataFormatException("JDFNumberRangeList::SetString: Illegal string " + s);
        }
        String zappedWS = StringUtil.zappTokenWS(s, "~");
        VString v = StringUtil.tokenize(zappedWS, " \t", false);
        VString vs = new VString(v);
        this.rangeList.clear();
        for (int i = 0; i < vs.size(); ++i) {
            String str = vs.elementAt(i);
            try {
                JDFNumberRange nr = new JDFNumberRange(str);
                this.rangeList.addElement(nr);
                continue;
            }
            catch (DataFormatException dfe) {
                throw new DataFormatException("JDFNumberRangeList::SetString: Illegal string " + s);
            }
        }
    }

    public boolean isValid(String s) {
        try {
            new JDFNumberRangeList(s);
        }
        catch (DataFormatException e) {
            return false;
        }
        return true;
    }

    public void append(JDFNumberRange r) {
        this.rangeList.addElement(r);
    }

    public void append(double xMin, double xMax) {
        this.append(new JDFNumberRange(xMin, xMax));
    }

    public void append(double x) {
        this.append(new JDFNumberRange(x, x));
    }

    @Override
    public boolean isOrdered() {
        int siz = this.rangeList.size();
        if (siz == 0) {
            return false;
        }
        Vector<Double> v = new Vector<Double>();
        for (int i = 0; i < siz; ++i) {
            JDFNumberRange r = (JDFNumberRange)this.rangeList.elementAt(i);
            v.addElement(new Double(r.getLeft()));
            if (r.getLeft() == r.getRight()) continue;
            v.addElement(new Double(r.getRight()));
        }
        int n = v.size() - 1;
        if (n == 0) {
            return true;
        }
        double first = (Double)v.elementAt(0);
        double last = (Double)v.elementAt(n);
        for (int j = 0; j < n; ++j) {
            double value = (Double)v.elementAt(j);
            double nextvalue = (Double)v.elementAt(j + 1);
            if (first == last && value == nextvalue || first < last && value <= nextvalue || first > last && value >= nextvalue) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isUniqueOrdered() {
        double last;
        int siz = this.rangeList.size();
        if (siz == 0) {
            return false;
        }
        Vector<Double> v = new Vector<Double>();
        for (int i = 0; i < siz; ++i) {
            JDFNumberRange r = (JDFNumberRange)this.rangeList.elementAt(i);
            v.addElement(new Double(r.getLeft()));
            if (r.getLeft() == r.getRight()) continue;
            v.addElement(new Double(r.getRight()));
        }
        int n = v.size() - 1;
        if (n == 0) {
            return true;
        }
        double first = (Double)v.elementAt(0);
        if (first == (last = ((Double)v.elementAt(n)).doubleValue())) {
            return false;
        }
        for (int j = 0; j < n; ++j) {
            double value = (Double)v.elementAt(j);
            double nextvalue = (Double)v.elementAt(j + 1);
            if (first < last && value < nextvalue || first > last && value < nextvalue) continue;
            return false;
        }
        return true;
    }
}

