/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.datatypes;

import java.util.Vector;
import java.util.zip.DataFormatException;
import org.cip4.jdflib.datatypes.JDFNumList;
import org.cip4.jdflib.util.StringUtil;

public class JDFRGBColor
extends JDFNumList {
    private static final long serialVersionUID = 1L;

    public JDFRGBColor() {
        super(3);
    }

    @Deprecated
    public JDFRGBColor(Vector v) throws DataFormatException {
        super(v);
    }

    public JDFRGBColor(String s) throws DataFormatException {
        super(s);
    }

    public static JDFRGBColor createRGBColor(String s) {
        if (s != null && s.length() >= 5) {
            try {
                return new JDFRGBColor(s);
            }
            catch (DataFormatException x) {
                return null;
            }
        }
        return null;
    }

    public JDFRGBColor(JDFNumList nl) throws DataFormatException {
        super(nl);
    }

    public JDFRGBColor(double r, double g, double b) {
        super(3);
        this.set(0, r);
        this.set(1, g);
        this.set(2, b);
    }

    @Override
    public boolean isValid() throws DataFormatException {
        if (this.size() != 3) {
            throw new DataFormatException("wrong size:" + this.size());
        }
        for (Object o : this) {
            if (o instanceof Double) continue;
            throw new DataFormatException("Data format exception!");
        }
        return true;
    }

    public double getR() {
        return this.doubleAt(0);
    }

    public void setR(double red) {
        this.set(0, red);
    }

    public double getG() {
        return this.doubleAt(1);
    }

    public void setG(double green) {
        this.set(1, green);
    }

    public double getB() {
        return this.doubleAt(2);
    }

    public void setB(double blue) {
        this.set(2, blue);
    }

    public String getHTMLColor() {
        int r = (int)(255.0 * this.getR());
        int g = (int)(255.0 * this.getG());
        int b = (int)(255.0 * this.getB());
        return StringUtil.sprintf("#%02x%02x%02x", r + "," + g + "," + b);
    }
}

