/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.datatypes;

import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.DataFormatException;
import org.cip4.jdflib.datatypes.JDFNumList;
import org.cip4.jdflib.datatypes.JDFXYPair;

public class JDFTransferFunction
extends JDFNumList {
    private static final long serialVersionUID = 1L;

    public static JDFTransferFunction createTransferFunction(String s) {
        if (s != null && s.length() > 0) {
            try {
                return new JDFTransferFunction(s);
            }
            catch (DataFormatException x) {
                return null;
            }
        }
        return null;
    }

    public JDFTransferFunction() throws DataFormatException {
        super("");
    }

    public JDFTransferFunction(String s) throws DataFormatException {
        super(s);
    }

    @Deprecated
    public JDFTransferFunction(Vector v) throws DataFormatException {
        super(v);
    }

    public JDFTransferFunction(JDFNumList nl) throws DataFormatException {
        super(nl.toString());
    }

    public JDFTransferFunction(JDFTransferFunction tf) {
        this.addAll(tf);
    }

    @Override
    public boolean isValid() throws DataFormatException {
        if (this.size() % 2 != 0) {
            throw new DataFormatException("Data format exception!");
        }
        for (Object o : this) {
            if (o instanceof Double) continue;
            throw new DataFormatException("Data format exception!");
        }
        return true;
    }

    public void add(JDFXYPair xy) {
        this.add(new Double(xy.getX()));
        this.add(new Double(xy.getY()));
    }

    public void add(Double x, Double y) {
        this.add(x);
        this.add(y);
    }

    public void add(double x, double y) {
        this.add(new Double(x));
        this.add(new Double(y));
    }

    public void add(String s) throws DataFormatException {
        StringTokenizer sToken = new StringTokenizer(s, " ");
        if (sToken.countTokens() % 2 != 0) {
            throw new DataFormatException("Data format exception!");
        }
        while (sToken.hasMoreTokens()) {
            String t = sToken.nextToken().trim();
            try {
                this.addElement(new Double(t));
            }
            catch (NumberFormatException e) {
                throw new DataFormatException("Data format exception!");
            }
        }
    }

    public void add(JDFTransferFunction tf) {
        this.addAll(tf);
    }
}

