/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.datatypes;

import java.util.Vector;
import java.util.zip.DataFormatException;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFNumList;
import org.cip4.jdflib.datatypes.JDFShape;
import org.cip4.jdflib.util.StringUtil;

public class JDFXYPair
extends JDFNumList {
    private static final long serialVersionUID = 1L;

    public JDFXYPair() {
        super(2);
    }

    @Deprecated
    public JDFXYPair(Vector v) throws DataFormatException {
        super(v);
    }

    public JDFXYPair(String s) throws DataFormatException {
        super(s);
    }

    public static JDFXYPair createXYPair(String s) {
        if (s != null && s.length() > 0) {
            try {
                return new JDFXYPair(s);
            }
            catch (DataFormatException x) {
                return null;
            }
        }
        return null;
    }

    public JDFXYPair(JDFNumList nl) throws DataFormatException {
        super(nl);
    }

    public JDFXYPair(JDFShape shape) {
        this.add(shape.getX());
        this.add(shape.getY());
    }

    public JDFXYPair(JDFXYPair nl) {
        this.addAll(nl);
    }

    public JDFXYPair(double x, double y) {
        super(2);
        this.set(0, new Double(x));
        this.set(1, new Double(y));
    }

    @Override
    public boolean isValid() throws DataFormatException {
        if (this.size() != 2) {
            throw new DataFormatException("Data format exception!" + this.size());
        }
        for (Object o : this) {
            if (o instanceof Double) continue;
            throw new DataFormatException("Data format exception!");
        }
        return true;
    }

    public double getX() {
        return this.doubleAt(0);
    }

    public void setX(double x) {
        this.set(0, x);
    }

    public double getY() {
        return this.doubleAt(1);
    }

    public void swapXY() {
        double tmp = this.getX();
        this.setX(this.getY());
        this.setY(tmp);
    }

    public void setY(double y) {
        this.set(1, y);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        JDFXYPair xyPair = (JDFXYPair)other;
        return Math.abs(this.getX() - xyPair.getX()) <= 1.0E-6 && Math.abs(this.getY() - xyPair.getY()) <= 1.0E-6;
    }

    public boolean isGreaterOrEqual(JDFXYPair x) {
        return this.equals(x) || this.getX() >= x.getX() && this.getY() >= x.getY();
    }

    public boolean isLessOrEqual(JDFXYPair x) {
        return this.equals(x) || this.getX() <= x.getX() && this.getY() <= x.getY();
    }

    public boolean isGreater(JDFXYPair x) {
        return !this.isLessOrEqual(x);
    }

    public boolean isPortrait() {
        return this.getX() < this.getY();
    }

    public boolean isLess(JDFXYPair x) {
        return !this.isGreaterOrEqual(x);
    }

    @Override
    public void setString(String string) throws DataFormatException {
        try {
            super.setString(string);
        }
        catch (DataFormatException x) {
            Double d = StringUtil.parseDouble(string, Double.NaN);
            if (!Double.isNaN(d)) {
                super.setString(string + " 0");
            }
            VString v = StringUtil.tokenize(string, "/", false);
            if (v.size() == 2) {
                super.setString(StringUtil.replaceChar(string, '/', " ", 0));
            }
            throw x;
        }
    }
}

