/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.elementwalker;

import java.util.Iterator;
import java.util.zip.DataFormatException;
import org.apache.commons.lang.StringUtils;
import org.cip4.jdflib.auto.JDFAutoApprovalDetails;
import org.cip4.jdflib.auto.JDFAutoColor;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFComment;
import org.cip4.jdflib.core.JDFCustomerInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.JDFNodeInfo;
import org.cip4.jdflib.core.JDFRefElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.JDFNameRangeList;
import org.cip4.jdflib.elementwalker.BaseElementWalker;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;
import org.cip4.jdflib.jmf.JDFAcknowledge;
import org.cip4.jdflib.jmf.JDFCommand;
import org.cip4.jdflib.jmf.JDFJMF;
import org.cip4.jdflib.jmf.JDFMessage;
import org.cip4.jdflib.jmf.JDFQuery;
import org.cip4.jdflib.jmf.JDFResponse;
import org.cip4.jdflib.node.JDFAncestor;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.pool.JDFPool;
import org.cip4.jdflib.resource.JDFDevice;
import org.cip4.jdflib.resource.JDFLayoutPreparationParams;
import org.cip4.jdflib.resource.JDFPageList;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.JDFStrippingParams;
import org.cip4.jdflib.resource.JDFTool;
import org.cip4.jdflib.resource.devicecapability.JDFAbstractState;
import org.cip4.jdflib.resource.process.JDFApprovalDetails;
import org.cip4.jdflib.resource.process.JDFApprovalSuccess;
import org.cip4.jdflib.resource.process.JDFAssembly;
import org.cip4.jdflib.resource.process.JDFAssemblySection;
import org.cip4.jdflib.resource.process.JDFColor;
import org.cip4.jdflib.resource.process.JDFComponent;
import org.cip4.jdflib.resource.process.JDFEmployee;
import org.cip4.jdflib.resource.process.JDFGeneralID;
import org.cip4.jdflib.resource.process.JDFLayout;
import org.cip4.jdflib.resource.process.JDFPageData;
import org.cip4.jdflib.span.JDFSpanBase;
import org.cip4.jdflib.util.EnumUtil;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.JDFDuration;
import org.cip4.jdflib.util.StringUtil;

public class FixVersion
extends BaseElementWalker {
    protected boolean bFixIDs;
    protected boolean bZappInvalid;
    protected final JDFElement.EnumVersion version;
    protected boolean bOK;
    protected boolean fixICSVersions;
    protected boolean bLayoutPrepToStripping;

    public boolean isFixICSVersions() {
        return this.fixICSVersions;
    }

    public void setFixICSVersions(boolean pFixICSVersions) {
        this.fixICSVersions = pFixICSVersions;
    }

    public boolean isFixVersionIDFix() {
        return this.bFixIDs;
    }

    public boolean isOK() {
        return this.bOK;
    }

    public void setFixVersionIDFix(boolean fixVersionIDFix) {
        this.bFixIDs = fixVersionIDFix;
    }

    public FixVersion(JDFElement.EnumVersion _version) {
        super(new BaseWalkerFactory());
        new BaseWalker(this.getFactory());
        this.bFixIDs = true;
        this.bZappInvalid = false;
        this.version = _version;
        this.bOK = true;
        this.fixICSVersions = false;
        this.bLayoutPrepToStripping = false;
    }

    public FixVersion(FixVersion fixVersion) {
        super(new BaseWalkerFactory());
        this.version = fixVersion.version;
        this.bZappInvalid = fixVersion.bZappInvalid;
        this.bFixIDs = fixVersion.bFixIDs;
        this.fixICSVersions = fixVersion.fixICSVersions;
        this.bLayoutPrepToStripping = fixVersion.bLayoutPrepToStripping;
    }

    @Override
    protected BaseWalkerFactory getFactory() {
        return (BaseWalkerFactory)this.theFactory;
    }

    public void setLayoutPrepToStripping(boolean layoutPrepToStripping) {
        this.bLayoutPrepToStripping = layoutPrepToStripping;
    }

    public boolean convert(KElement e) {
        this.walkTree(e, null);
        return this.isOK();
    }

    protected void updateAssemblyIDS(JDFElement e) {
        if (this.version != null) {
            if (this.lessThanVersion(JDFElement.EnumVersion.Version_1_3)) {
                e.renameAttribute("AssemblyIDs", "AssemblyID", null, null);
            } else {
                e.renameAttribute("AssemblyID", "AssemblyIDs", null, null);
            }
        }
    }

    protected boolean lessThanVersion(JDFElement.EnumVersion v) {
        return EnumUtil.aLessThanB(this.version, v);
    }

    @Override
    public String toString() {
        return "[FixVersion : version=" + (this.version == null ? "null" : this.version.getName()) + " LO->Strip" + this.bLayoutPrepToStripping;
    }

    public void setBZappInvalid(boolean zappInvalid) {
        this.bZappInvalid = zappInvalid;
    }

    boolean isQueueFilterRemove(KElement toCheck) {
        JDFMessage.EnumType type = ((JDFMessage)toCheck).getEnumType();
        if (type == null) {
            return false;
        }
        boolean b = true;
        b = b || JDFMessage.EnumType.AbortQueueEntry.equals((Object)type);
        b = b || JDFMessage.EnumType.RemoveQueueEntry.equals((Object)type);
        b = b || JDFMessage.EnumType.HoldQueueEntry.equals((Object)type);
        b = b || JDFMessage.EnumType.RemoveQueueEntry.equals((Object)type);
        b = b || JDFMessage.EnumType.ResubmitQueueEntry.equals((Object)type);
        b = b || JDFMessage.EnumType.SetQueueEntryPosition.equals((Object)type);
        b = b || JDFMessage.EnumType.SetQueueEntryPriority.equals((Object)type);
        b = b || JDFMessage.EnumType.CloseQueue.equals((Object)type);
        b = b || JDFMessage.EnumType.OpenQueue.equals((Object)type);
        b = b || JDFMessage.EnumType.HoldQueue.equals((Object)type);
        b = b || JDFMessage.EnumType.ResumeQueue.equals((Object)type);
        b = b || JDFMessage.EnumType.FlushQueue.equals((Object)type);
        return b;
    }

    public class WalkLayoutPrep
    extends WalkResource {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFLayoutPreparationParams;
        }

        @Override
        public KElement walk(KElement e1, KElement trackElem) {
            JDFLayoutPreparationParams lpp = (JDFLayoutPreparationParams)e1;
            if (lpp.isResourceRoot() && FixVersion.this.bLayoutPrepToStripping) {
                int i;
                VElement rls = lpp.getLinksAndRefs(true, false);
                if (rls == null) {
                    return null;
                }
                rls.unify();
                VElement vn = new VElement();
                for (int i2 = 0; i2 < rls.size(); ++i2) {
                    JDFResourceLink rl = (JDFResourceLink)rls.get(i2);
                    vn.add(rl.getParentJDF());
                }
                vn.unify();
                if (vn.size() <= 0) {
                    return null;
                }
                JDFNode node = (JDFNode)vn.get(0);
                JDFLayoutPreparationParams.StrippingConverter sc = lpp.convertToStripping(node);
                new FixVersion(FixVersion.this).walkTree(sc.getAssembly(), null);
                new FixVersion(FixVersion.this).walkTree(sc.getStrippingParams(), null);
                new FixVersion(FixVersion.this).walkTree(sc.getBinderySignature(), null);
                for (i = 1; i < vn.size(); ++i) {
                    JDFNode n = (JDFNode)vn.get(i);
                    n.linkResource((JDFResource)sc.getAssembly(), JDFResourceLink.EnumUsage.Input, null);
                    n.linkResource((JDFResource)sc.getStrippingParams(), JDFResourceLink.EnumUsage.Input, null);
                }
                for (i = 0; i < rls.size(); ++i) {
                    rls.get(i).deleteNode();
                }
                return null;
            }
            return super.walk(e1, trackElem);
        }
    }

    public class WalkCustomerInfo
    extends WalkResource {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFCustomerInfo;
        }

        @Override
        public KElement walk(KElement e1, KElement trackElem) {
            JDFCustomerInfo ci = (JDFCustomerInfo)e1;
            if (ci.hasAttribute("rRefs")) {
                ci.removeAttribute("rRefs");
            }
            return super.walk(e1, trackElem);
        }
    }

    public class WalkNodeInfo
    extends WalkResource {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFNodeInfo;
        }

        @Override
        public KElement walk(KElement e1, KElement trackElem) {
            JDFNodeInfo ni = (JDFNodeInfo)e1;
            if (ni.hasAttribute("rRefs")) {
                ni.removeAttribute("rRefs");
            }
            return super.walk(e1, trackElem);
        }
    }

    public class WalkSpanBase
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFSpanBase;
        }

        @Override
        public KElement walk(KElement e1, KElement trackElem) {
            JDFSpanBase b = (JDFSpanBase)e1;
            if (FixVersion.this.version != null) {
                if (FixVersion.this.version.getValue() >= JDFElement.EnumVersion.Version_1_2.getValue()) {
                    if (b.hasAttribute("Priority")) {
                        if (b.getPriority() == JDFSpanBase.EnumPriority.Required) {
                            b.setSettingsPolicy(JDFElement.EnumSettingsPolicy.MustHonor);
                        } else {
                            b.setSettingsPolicy(JDFElement.EnumSettingsPolicy.BestEffort);
                        }
                        b.removeAttribute("Priority");
                    }
                } else if (b.getSettingsPolicy(true) == JDFElement.EnumSettingsPolicy.BestEffort) {
                    b.setPriority(JDFSpanBase.EnumPriority.Required);
                } else {
                    b.setPriority(JDFSpanBase.EnumPriority.Suggested);
                }
            }
            return super.walk(e1, trackElem);
        }
    }

    public class WalkLayout
    extends WalkResource {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFLayout;
        }

        @Override
        public KElement walk(KElement e1, KElement trackElem) {
            JDFLayout l = (JDFLayout)e1;
            if (l.isResourceRoot() && FixVersion.this.version != null) {
                int vers = FixVersion.this.version.getValue();
                boolean newLayout = JDFLayout.isNewLayout(l);
                if (vers >= JDFElement.EnumVersion.Version_1_3.getValue() && !newLayout) {
                    FixVersion.this.bOK = l.toNewLayout() && FixVersion.this.bOK;
                } else if (vers < JDFElement.EnumVersion.Version_1_3.getValue() && newLayout) {
                    boolean bl = FixVersion.this.bOK = l.fromNewLayout() && FixVersion.this.bOK;
                }
                if (vers >= JDFElement.EnumVersion.Version_1_4.getValue() && l.hasAttribute("Name")) {
                    l.renameAttribute("Name", "DescriptiveName", null, null);
                }
            }
            return super.walk(e1, trackElem);
        }
    }

    public class WalkPageData
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFPageData;
        }

        @Override
        public KElement walk(KElement e1, KElement trackElem) {
            JDFPageData e = (JDFPageData)e1;
            FixVersion.this.updateAssemblyIDS(e);
            return super.walk(e1, trackElem);
        }
    }

    public class WalkStrippingParams
    extends WalkResource {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFStrippingParams;
        }

        @Override
        public KElement walk(KElement e1, KElement trackElem) {
            JDFStrippingParams e = (JDFStrippingParams)e1;
            FixVersion.this.updateAssemblyIDS(e);
            return super.walk(e1, trackElem);
        }
    }

    public class WalkPageList
    extends WalkResource {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFPageList;
        }

        @Override
        public KElement walk(KElement e1, KElement trackElem) {
            JDFPageList e = (JDFPageList)e1;
            FixVersion.this.updateAssemblyIDS(e);
            return super.walk(e1, trackElem);
        }
    }

    public class WalkAssemblySection
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFAssemblySection;
        }

        @Override
        public KElement walk(KElement e1, KElement trackElem) {
            JDFAssemblySection e = (JDFAssemblySection)e1;
            FixVersion.this.updateAssemblyIDS(e);
            return super.walk(e1, trackElem);
        }
    }

    public class WalkAssembly
    extends WalkResource {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFAssembly;
        }

        @Override
        public KElement walk(KElement e1, KElement trackElem) {
            JDFAssembly e = (JDFAssembly)e1;
            FixVersion.this.updateAssemblyIDS(e);
            return super.walk(e1, trackElem);
        }
    }

    public class WalkGeneralIDNamedFeature
    extends WalkGeneralID {
        @Override
        public boolean matches(KElement toCheck) {
            boolean b = super.matches(toCheck);
            b = b && toCheck.getParentNode() instanceof JDFNode;
            return b && "NamedFeature".equals(toCheck.getAttribute("DataType"));
        }

        @Override
        public KElement walk(KElement e1, KElement trackElem) {
            if (EnumUtil.aLessThanB(FixVersion.this.version, JDFElement.EnumVersion.Version_1_5)) {
                JDFNode n = (JDFNode)e1.getParentNode();
                JDFGeneralID gid = (JDFGeneralID)e1;
                n.appendAttribute("NamedFeatures", gid.getIDUsage(), null, " ", false);
                n.appendAttribute("NamedFeatures", gid.getIDValue(), null, " ", false);
                gid.deleteNode();
                return null;
            }
            return super.walk(e1, trackElem);
        }
    }

    public class WalkGeneralID
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFGeneralID;
        }
    }

    public class WalkEmployee
    extends WalkResource {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFEmployee;
        }

        @Override
        public KElement walk(KElement e1, KElement trackElem) {
            JDFEmployee e = (JDFEmployee)e1;
            if (!e.hasAttribute("ProductID")) {
                e.setProductID(StringUtil.getNonEmpty(e.getPersonalID()));
            }
            return super.walk(e1, trackElem);
        }
    }

    public class WalkColor
    extends WalkResource {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFColor;
        }

        @Override
        public KElement walk(KElement e1, KElement trackElem) {
            JDFColor c = (JDFColor)e1;
            if (c.hasAttribute("UsePDLAlternateCS")) {
                if (!c.hasAttribute("MappingSelection")) {
                    c.setMappingSelection(c.getUsePDLAlternateCS() ? JDFAutoColor.EnumMappingSelection.UsePDLValues : JDFAutoColor.EnumMappingSelection.UseProcessColorValues);
                }
                c.removeAttribute("UsePDLAlternateCS");
            }
            return super.walk(e1, trackElem);
        }
    }

    public class WalkApprovalSuccess
    extends WalkResource {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFApprovalSuccess;
        }

        @Override
        public KElement walk(KElement e1, KElement trackElem) {
            JDFApprovalSuccess as = (JDFApprovalSuccess)e1;
            if (FixVersion.this.version != null) {
                if (FixVersion.this.version.getValue() >= JDFElement.EnumVersion.Version_1_3.getValue()) {
                    if (as.hasChildElement("Contact", null) || as.hasChildElement("FileSpec", null)) {
                        JDFApprovalDetails ad = as.appendApprovalDetails();
                        ad.setApprovalState(JDFAutoApprovalDetails.EnumApprovalState.Approved);
                        ad.moveElement(as.getContact(), null);
                        ad.moveElement(as.getFileSpec(), null);
                    }
                } else {
                    for (int i = 0; i < 99999; ++i) {
                        JDFApprovalDetails ad = as.getApprovalDetails(i);
                        int iAccept = 0;
                        if (ad == null) {
                            if (iAccept != 0) break;
                            as.setResStatus(JDFResource.EnumResStatus.Rejected, false);
                            break;
                        }
                        if (ad.getApprovalState() == JDFAutoApprovalDetails.EnumApprovalState.Rejected) {
                            FixVersion.this.bOK = false;
                            ad.deleteNode();
                            continue;
                        }
                        ++iAccept;
                        as.moveElement(ad.getContact(), null);
                        as.moveElement(ad.getFileSpec(), null);
                        ad.deleteNode();
                    }
                }
            }
            return super.walk(e1, trackElem);
        }
    }

    public class WalkComponent
    extends WalkResource {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFComponent;
        }

        @Override
        public KElement walk(KElement e1, KElement trackElem) {
            JDFComponent c = (JDFComponent)e1;
            if (FixVersion.this.version != null) {
                if (FixVersion.this.version.getValue() >= JDFElement.EnumVersion.Version_1_4.getValue()) {
                    c.removeAttribute("IsWaste");
                }
                if (FixVersion.this.version.getValue() >= JDFElement.EnumVersion.Version_1_3.getValue()) {
                    this.fixFromSourceSheet(c);
                } else {
                    this.fixToSourceSheet(c);
                }
            }
            return super.walk(e1, trackElem);
        }

        private void fixToSourceSheet(JDFComponent c) {
            JDFLayout layout = c.getLayout();
            if (layout != null) {
                String sourcesheet = layout.getSheetName();
                c.setSourceSheet(sourcesheet);
                JDFRefElement layoutRef = (JDFRefElement)c.getElement_KElement("LayoutRef", null, 0);
                if (layoutRef != null) {
                    layoutRef.removeChild("Part", null, 0);
                }
            }
        }

        private void fixFromSourceSheet(JDFComponent c) {
            if (c.hasAttribute("SourceSheet")) {
                String sourceSheet = c.getSourceSheet();
                JDFRefElement layoutRef = (JDFRefElement)c.getElement_KElement("LayoutRef", null, 0);
                if (layoutRef != null) {
                    JDFLayout lo = (JDFLayout)layoutRef.getLinkRoot(layoutRef.getrRef());
                    if (lo != null) {
                        lo.fixVersion(FixVersion.this.version);
                    }
                    layoutRef.setPartMap(new JDFAttributeMap("SheetName", sourceSheet));
                    lo = (JDFLayout)layoutRef.getTarget();
                    layoutRef.setPartMap(lo.getPartMap());
                }
                c.removeAttribute("SourceSheet");
            }
        }
    }

    public class WalkTool
    extends WalkResource {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFTool;
        }

        @Override
        public KElement walk(KElement e1, KElement trackElem) {
            JDFTool t = (JDFTool)e1;
            if (FixVersion.this.version != null && FixVersion.this.version.getValue() >= JDFElement.EnumVersion.Version_1_3.getValue()) {
                if (t.hasAttribute("ToolID") && !t.hasAttribute("ProductID")) {
                    t.setProductID(t.getToolID());
                }
                t.removeAttribute("ToolID", null);
            } else if (FixVersion.this.version != null && FixVersion.this.version.getValue() < JDFElement.EnumVersion.Version_1_3.getValue() && t.hasAttribute("ProductID") && !t.hasAttribute("ToolID")) {
                t.setToolID(t.getProductID());
            }
            return super.walk(e1, trackElem);
        }
    }

    public class WalkDevice
    extends WalkResource {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFDevice;
        }

        @Override
        public KElement walk(KElement e1, KElement trackElem) {
            JDFDevice d = (JDFDevice)e1;
            if (!d.hasAttribute("DescriptiveName")) {
                d.setDescriptiveName(StringUtil.getNonEmpty(d.getFriendlyName()));
            }
            if (EnumUtil.aLessThanB(JDFElement.EnumVersion.Version_1_3, FixVersion.this.version)) {
                d.removeAttribute("FriendlyName");
            }
            return super.walk(e1, trackElem);
        }
    }

    public class WalkState
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFAbstractState;
        }

        @Override
        public KElement walk(KElement e1, KElement trackElem) {
            JDFAbstractState a = (JDFAbstractState)e1;
            if ("unbounded".equals(a.getAttribute("MaxOccurs", null, null))) {
                a.setAttribute("MaxOccurs", "INF");
            }
            return super.walk(e1, trackElem);
        }
    }

    public class WalkResource
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFResource;
        }

        @Override
        public KElement walk(KElement e1, KElement trackElem) {
            JDFResource r = (JDFResource)e1;
            if (!r.isResourceRootRoot()) {
                if (!r.isResourceElement()) {
                    r.removeAttribute("Class");
                }
            } else {
                if (r.hasAttribute("rRefs")) {
                    r.removeAttribute("rRefs");
                }
                r.init();
            }
            if (FixVersion.this.version != null) {
                if (!r.isResourceRootRoot()) {
                    if (FixVersion.this.version.getValue() >= JDFElement.EnumVersion.Version_1_2.getValue()) {
                        r.removeAttribute("ID");
                    }
                } else if (FixVersion.this.version.getValue() <= JDFElement.EnumVersion.Version_1_2.getValue() && r.getPartUsage() == JDFResource.EnumPartUsage.Sparse) {
                    r.setPartUsage(JDFResource.EnumPartUsage.Implicit);
                }
            }
            return super.walk(e1, trackElem);
        }
    }

    public class WalkPool
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFPool;
        }

        @Override
        public KElement walk(KElement e1, KElement trackElem) {
            JDFPool p = (JDFPool)e1;
            if (p.hasAttribute("rRefs")) {
                p.removeAttribute("rRefs");
            }
            return super.walk(e1, trackElem);
        }
    }

    public class WalkJDF
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFNode;
        }

        @Override
        public KElement walk(KElement e1, KElement trackElem) {
            JDFNode.EnumType enumType;
            JDFNode n = (JDFNode)e1;
            if (FixVersion.this.version != null) {
                n.setVersion(FixVersion.this.version);
                n.setMaxVersion(FixVersion.this.version);
                n.fixNiCi(FixVersion.this.version);
                this.fixNamedFeatures(n, trackElem);
            }
            if (!n.hasAttribute("JobPartID")) {
                n.setJobPartID(n.generateDotID("JobPartID", null));
            }
            if (n.isJDFRoot() && !n.hasAncestorAttribute("JobID", null)) {
                n.setJobID(n.generateDotID("JobID", null));
            }
            if ((enumType = n.getEnumType()) != null) {
                n.setType(enumType);
            }
            return super.walk(e1, trackElem);
        }

        private void fixNamedFeatures(JDFNode n, KElement trackElem) {
            if (EnumUtil.aLessThanB(JDFElement.EnumVersion.Version_1_4, FixVersion.this.version)) {
                VString v = n.getNamedFeatures();
                if (v != null) {
                    for (int i = 0; i < v.size() / 2; ++i) {
                        String key = v.get(i * 2);
                        String val = v.get(i * 2 + 1);
                        n.appendGeneralID(key, val).setAttribute("DataType", "NamedFeature");
                    }
                }
                n.removeAttribute("NamedFeatures");
            }
        }
    }

    public class WalkAncestor
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFAncestor;
        }

        @Override
        public KElement walk(KElement e1, KElement trackElem) {
            JDFAncestor a = (JDFAncestor)e1;
            if (FixVersion.this.version != null) {
                a.setVersion(FixVersion.this.version);
                a.setMaxVersion(FixVersion.this.version);
                if (FixVersion.this.version.getValue() < JDFElement.EnumVersion.Version_1_3.getValue()) {
                    a.inlineRefElements(null, null, true);
                }
            }
            return super.walk(e1, trackElem);
        }
    }

    public class WalkJMFMessage
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFMessage;
        }

        @Override
        public KElement walk(KElement e1, KElement trackElem) {
            JDFMessage jmf = (JDFMessage)e1;
            if (jmf.hasAttribute("Type") && !jmf.hasAttribute("xsi:type", "http://www.w3.org/2001/XMLSchema-instance", false)) {
                jmf.setAttribute("xsi:type", jmf.getLocalName() + jmf.getType(), "http://www.w3.org/2001/XMLSchema-instance");
            }
            return super.walk(e1, trackElem);
        }
    }

    public class WalkJMFResponseQueue
    extends WalkJMFResponseAcknowledge {
        @Override
        public KElement walk(KElement e1, KElement trackElem) {
            this.fixQueue((JDFMessage)e1);
            return super.walk(e1, trackElem);
        }

        @Override
        public boolean matches(KElement toCheck) {
            if (!super.matches(toCheck)) {
                return false;
            }
            return FixVersion.this.isQueueFilterRemove(toCheck);
        }
    }

    public class WalkJMFCommandAbortQueueEntry
    extends WalkJMFCommandQueueFilter {
        @Override
        public KElement walk(KElement e1, KElement trackElem) {
            if (!EnumUtil.aLessThanB(FixVersion.this.version, JDFElement.EnumVersion.Version_1_5)) {
                e1.getCreateElement("AbortQueueEntryParams").moveElement(((JDFMessage)e1).getQueueEntryDef(0), null);
            }
            return super.walk(e1, trackElem);
        }

        @Override
        public boolean matches(KElement toCheck) {
            if (!super.matches(toCheck)) {
                return false;
            }
            return JDFMessage.EnumType.AbortQueueEntry.equals((Object)((JDFMessage)toCheck).getEnumType());
        }
    }

    public class WalkJMFCommandQueueFilter
    extends WalkJMFCommand {
        @Override
        public KElement walk(KElement e1, KElement trackElem) {
            this.fixQueueFilter((JDFCommand)e1);
            return super.walk(e1, trackElem);
        }

        @Override
        public boolean matches(KElement toCheck) {
            if (!super.matches(toCheck)) {
                return false;
            }
            return FixVersion.this.isQueueFilterRemove(toCheck);
        }
    }

    public class WalkJMFCommand
    extends WalkJMFMessage {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFCommand;
        }

        void fixQueueFilter(JDFCommand c) {
            if (!EnumUtil.aLessThanB(FixVersion.this.version, JDFElement.EnumVersion.Version_1_5)) {
                c.removeChild("QueueFilter", null, 0);
            }
        }
    }

    public class WalkJMFResponseAcknowledge
    extends WalkJMFMessage {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFResponse || toCheck instanceof JDFAcknowledge;
        }

        void fixQueue(JDFMessage resp) {
            if (!EnumUtil.aLessThanB(FixVersion.this.version, JDFElement.EnumVersion.Version_1_5)) {
                resp.removeChild("Queue", null, 0);
            }
        }
    }

    public class WalkJMFQuery
    extends WalkJMFMessage {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFQuery;
        }
    }

    public class WalkJMF
    extends WalkPool {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFJMF;
        }

        @Override
        public KElement walk(KElement e1, KElement trackElem) {
            JDFJMF jmf = (JDFJMF)e1;
            if (FixVersion.this.version != null) {
                jmf.setVersion(FixVersion.this.version);
                jmf.setMaxVersion(FixVersion.this.version);
                if (EnumUtil.aLessThanB(JDFElement.EnumVersion.Version_1_3, FixVersion.this.version)) {
                    if (!jmf.hasAttribute("AgentName")) {
                        jmf.setAgentName(JDFAudit.getStaticAgentName());
                    }
                    if (!jmf.hasAttribute("AgentVersion")) {
                        jmf.setAgentName(JDFAudit.getStaticAgentVersion());
                    }
                } else {
                    jmf.removeAttribute("AgentName");
                    jmf.removeAttribute("AgentVersion");
                }
            }
            return super.walk(e1, trackElem);
        }
    }

    public class WalkAudit
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFAudit;
        }

        @Override
        public KElement walk(KElement e1, KElement trackElem) {
            JDFAudit audit = (JDFAudit)e1;
            if (FixVersion.this.version != null) {
                this.fixID(audit);
                String author = audit.getAuthor();
                if (FixVersion.this.lessThanVersion(JDFElement.EnumVersion.Version_1_2)) {
                    this.mergeAuthor(audit, author);
                } else if (author.length() > 0) {
                    this.splitAuthor(audit, author);
                }
                this.authorToEmployee(audit);
            }
            return super.walk(e1, trackElem);
        }

        private void fixID(JDFAudit audit) {
            if (FixVersion.this.lessThanVersion(JDFElement.EnumVersion.Version_1_3)) {
                audit.removeAttribute("ID");
            } else {
                audit.appendAnchor(null);
            }
        }

        private void mergeAuthor(JDFAudit audit, String author) {
            String tmp = audit.getAgentName();
            boolean b = false;
            if (tmp.length() != 0) {
                author = author + "_|_" + tmp;
                b = true;
            }
            if ((tmp = audit.getAgentVersion()).length() != 0) {
                if (!b) {
                    author = author + "_|_ ";
                }
                author = author + "_|_" + tmp;
                b = true;
            }
            audit.removeAttribute("AgentName");
            audit.removeAttribute("AgentVersion");
            if (b) {
                audit.setAuthor(author);
            }
        }

        private void splitAuthor(JDFAudit audit, String author) {
            VString tokens = StringUtil.tokenize(author, "_|_", false);
            if (tokens.size() == 3) {
                String tmp = tokens.stringAt(0);
                if (!tmp.equals("") && !tmp.equals(" ")) {
                    audit.setAuthor(tmp);
                }
                if (!(tmp = tokens.stringAt(1)).equals("") && !tmp.equals(" ")) {
                    audit.setAgentName(tmp);
                }
                if (!(tmp = tokens.stringAt(2)).equals("") && !tmp.equals(" ")) {
                    audit.setAgentVersion(tmp);
                }
            }
        }

        private void authorToEmployee(JDFAudit audit) {
            if (!FixVersion.this.lessThanVersion(JDFElement.EnumVersion.Version_1_4)) {
                String finalAuthor = StringUtil.getNonEmpty(audit.getAuthor());
                if (finalAuthor != null && !audit.hasChildElement("Employee", null)) {
                    audit.appendEmployee().setDescriptiveName(finalAuthor);
                }
                audit.removeAttribute("Author");
            }
        }
    }

    public class WalkComment
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFComment;
        }

        @Override
        public KElement walk(KElement e1, KElement trackElem) {
            JDFComment c = (JDFComment)e1;
            if (FixVersion.this.version != null) {
                if (FixVersion.this.version.getValue() >= JDFElement.EnumVersion.Version_1_3.getValue() && c.getLocalName().equals("Comment")) {
                    c.appendAnchor(null);
                } else {
                    c.removeAttribute("ID");
                    c.removeAttribute("AgentName");
                    c.removeAttribute("AgentVersion");
                    c.removeAttribute("Author");
                    c.removeAttribute("TimeStamp");
                }
            }
            return super.walk(e1, trackElem);
        }
    }

    public class WalkResLink
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFResourceLink;
        }

        @Override
        public KElement walk(KElement e1, KElement trackElem) {
            JDFResourceLink rl = (JDFResourceLink)e1;
            if (FixVersion.this.version != null) {
                this.updateDraftOK(rl);
            }
            return super.walk(e1, trackElem);
        }

        private void updateDraftOK(JDFResourceLink rl) {
            if (FixVersion.this.version.getValue() >= JDFElement.EnumVersion.Version_1_3.getValue()) {
                if (rl.hasAttribute("DraftOK")) {
                    if (!rl.hasAttribute("MinStatus")) {
                        rl.setMinStatus(JDFResource.EnumResStatus.Draft);
                    }
                    rl.removeAttribute("DraftOK");
                }
            } else {
                if (rl.hasAttribute("MinStatus")) {
                    if (!rl.hasAttribute("DraftOK")) {
                        rl.setDraftOK(true);
                    }
                    rl.removeAttribute("MinStatus");
                }
                rl.removeAttribute("MinLateStatus");
            }
        }
    }

    public class WalkElement
    extends BaseWalker {
        public WalkElement() {
            super(FixVersion.this.getFactory());
        }

        @Override
        public KElement walk(KElement e1, KElement trackElem) {
            JDFElement el = (JDFElement)e1;
            JDFAttributeMap m = el.getAttributeMap();
            Iterator<String> it = m.getKeyIterator();
            AttributeInfo ai = el.getAttributeInfo();
            while (it.hasNext()) {
                String key = it.next();
                String value = m.get(key);
                this.walkSingleAttribute(el, ai, key, value);
            }
            return el;
        }

        private void walkSingleAttribute(JDFElement el, AttributeInfo ai, String key, String value) {
            AttributeInfo.EnumAttributeType attType = ai.getAttributeType(key);
            if (AttributeInfo.EnumAttributeType.isRange(attType)) {
                this.fixRange(el, key, value);
            } else if (AttributeInfo.EnumAttributeType.duration.equals((Object)attType)) {
                this.fixDuration(el, key, value);
            } else if (AttributeInfo.EnumAttributeType.dateTime.equals((Object)attType)) {
                this.fixDateTime(el, key, value);
            }
            if (FixVersion.this.bFixIDs && value.length() > 0 && StringUtils.isNumeric((String)value.substring(0, 1))) {
                this.fixIDs(el, ai, key, value);
            }
            if ("ICSVersions".equals(key)) {
                this.fixICSVesions(el, value);
            }
            if (FixVersion.this.bZappInvalid && attType != null && !AttributeInfo.validStringForType(value, attType, null)) {
                el.removeAttribute_KElement(key, null);
            }
        }

        private void fixICSVesions(JDFElement el, String value) {
            if (!FixVersion.this.fixICSVersions) {
                return;
            }
            VString v = StringUtil.tokenize(value, null, false);
            if (v == null) {
                return;
            }
            int minor = FixVersion.this.version.getMinorVersion();
            for (int i = 0; i < v.size(); ++i) {
                String icsToken = v.get(i);
                if (!".".equals(StringUtil.substring(icsToken, -2, -1)) || !StringUtil.isInteger(StringUtil.rightStr(icsToken, 1))) continue;
                icsToken = StringUtil.leftStr(icsToken, -1) + minor;
                v.set(i, icsToken);
            }
            el.setAttribute("ICSVersions", v, null);
        }

        private void fixRange(JDFElement el, String key, String value) {
            try {
                JDFNameRangeList nrl = new JDFNameRangeList(value);
                el.setAttribute(key, nrl, null);
            }
            catch (JDFException e) {
            }
            catch (DataFormatException e) {
                // empty catch block
            }
        }

        private void fixDuration(JDFElement el, String key, String value) {
            try {
                el.setAttribute(key, new JDFDuration(value).getDurationISO());
            }
            catch (DataFormatException ex) {
                // empty catch block
            }
        }

        private void fixDateTime(JDFElement el, String key, String value) {
            try {
                el.setAttribute(key, new JDFDate(value).getDateTimeISO());
            }
            catch (DataFormatException ex) {
                // empty catch block
            }
        }

        private void fixIDs(JDFElement el, AttributeInfo ai, String key, String value) {
            AttributeInfo.EnumAttributeType atType = ai.getAttributeType(key);
            if (atType != null) {
                if (atType.equals((Object)AttributeInfo.EnumAttributeType.ID) || atType.equals((Object)AttributeInfo.EnumAttributeType.IDREF)) {
                    value = "_" + value;
                    el.setAttribute(key, value);
                } else if (atType.equals((Object)AttributeInfo.EnumAttributeType.IDREFS)) {
                    VString vvalues = new VString(value, " ");
                    for (int i = 0; i < vvalues.size(); ++i) {
                        String s = vvalues.stringAt(i);
                        if (s.length() <= 0 || !StringUtils.isNumeric((String)s.substring(0, 1))) continue;
                        s = "_" + s;
                        vvalues.setElementAt(s, i);
                    }
                    el.setAttribute(key, vvalues, null);
                }
            }
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFElement;
        }
    }
}

