/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions;

import org.cip4.jdflib.core.JDFComment;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.extensions.BaseXJDFHelper;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.process.JDFGeneralID;

public class IntentHelper
extends BaseXJDFHelper {
    public static boolean bSpanAsAttribute = true;

    public IntentHelper(KElement intent) {
        this.theElement = intent;
        this.theElement.appendAnchor(null);
    }

    public String toString() {
        return "IntentHelper: " + this.theElement;
    }

    public KElement getIntent() {
        return this.theElement;
    }

    public KElement getResource() {
        String name = this.theElement.getAttribute("Name", null, null);
        if (name != null) {
            return this.theElement.getCreateElement(name);
        }
        for (KElement e = this.theElement.getFirstChildElement(); e != null; e = e.getNextSiblingElement()) {
            if (e instanceof JDFPart || e instanceof JDFGeneralID || e instanceof JDFComment) continue;
            return e;
        }
        return null;
    }

    public String getName() {
        KElement r;
        String name = this.theElement.getAttribute("Name", null, null);
        if (name == null && (r = this.getResource()) != null) {
            name = r.getLocalName();
            this.theElement.setAttribute("Name", name);
        }
        return name;
    }

    public void setSpan(String att, String val, String dataType) {
        KElement resource = this.getResource();
        this.setSpan(resource, att, val, dataType);
    }

    public String getSpan(String spanName) {
        KElement resource = this.getResource();
        String s = resource.getAttribute(spanName, null, null);
        if (s == null) {
            s = resource.getXPathAttribute(spanName + "/@Actual", null);
        }
        return s;
    }

    public void setSpan(KElement resource, String att, String val, String dataType) {
        if (bSpanAsAttribute || dataType == null) {
            resource.setAttribute(att, val);
        } else {
            if (!dataType.endsWith("Span")) {
                dataType = dataType + "Span";
            }
            KElement span = resource.getCreateElement(dataType);
            span.setAttribute("Name", att);
            span.setAttribute("Actual", val);
        }
    }
}

