/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker;

import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.cip4.jdflib.auto.JDFAutoComponent;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.DocumentJDFImpl;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFNodeInfo;
import org.cip4.jdflib.core.JDFRefElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.JDFSeparationList;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.JDFNameRange;
import org.cip4.jdflib.datatypes.JDFNameRangeList;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.elementwalker.BaseElementWalker;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;
import org.cip4.jdflib.elementwalker.EnsureNSUri;
import org.cip4.jdflib.elementwalker.UnLinkFinder;
import org.cip4.jdflib.extensions.IntentHelper;
import org.cip4.jdflib.extensions.ProductHelper;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.extensions.xjdfwalker.IDFinder;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.pool.JDFAuditPool;
import org.cip4.jdflib.pool.JDFResourcePool;
import org.cip4.jdflib.resource.JDFBindItem;
import org.cip4.jdflib.resource.JDFEdgeGluing;
import org.cip4.jdflib.resource.JDFEmbossingItem;
import org.cip4.jdflib.resource.JDFHardCoverBinding;
import org.cip4.jdflib.resource.JDFInsert;
import org.cip4.jdflib.resource.JDFNumberItem;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.JDFProofItem;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.JDFSoftCoverBinding;
import org.cip4.jdflib.resource.JDFStripBinding;
import org.cip4.jdflib.resource.JDFStrippingParams;
import org.cip4.jdflib.resource.JDFTabs;
import org.cip4.jdflib.resource.intent.JDFArtDelivery;
import org.cip4.jdflib.resource.intent.JDFColorIntent;
import org.cip4.jdflib.resource.intent.JDFDropIntent;
import org.cip4.jdflib.resource.intent.JDFDropItemIntent;
import org.cip4.jdflib.resource.intent.JDFIntentResource;
import org.cip4.jdflib.resource.intent.JDFShapeCut;
import org.cip4.jdflib.resource.process.JDFColorantControl;
import org.cip4.jdflib.resource.process.JDFCompany;
import org.cip4.jdflib.resource.process.JDFComponent;
import org.cip4.jdflib.resource.process.JDFDependencies;
import org.cip4.jdflib.resource.process.JDFLayout;
import org.cip4.jdflib.resource.process.JDFLayoutElement;
import org.cip4.jdflib.resource.process.JDFMedia;
import org.cip4.jdflib.resource.process.JDFRunList;
import org.cip4.jdflib.resource.process.postpress.JDFChannelBinding;
import org.cip4.jdflib.resource.process.postpress.JDFCoilBinding;
import org.cip4.jdflib.resource.process.postpress.JDFPlasticCombBinding;
import org.cip4.jdflib.resource.process.postpress.JDFRingBinding;
import org.cip4.jdflib.resource.process.postpress.JDFSaddleStitching;
import org.cip4.jdflib.resource.process.postpress.JDFSideSewing;
import org.cip4.jdflib.resource.process.postpress.JDFThreadSealing;
import org.cip4.jdflib.resource.process.postpress.JDFThreadSewing;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.UnitParser;

public class XJDFToJDFConverter
extends BaseElementWalker {
    JDFDoc jdfDoc;
    Map<String, IDFinder.IDPart> idMap;
    boolean firstConvert = true;
    boolean firstproductInList = true;
    boolean foundProduct;
    boolean foundProductList = false;
    JDFNode currentJDFNode = null;
    boolean createProduct = true;
    boolean convertUnits;
    private JDFElement.EnumVersion version = JDFElement.EnumVersion.Version_1_4;
    private boolean bConvertTilde;
    private boolean heuristicLink;

    public boolean isCreateProduct() {
        return this.createProduct;
    }

    public void setCreateProduct(boolean createProduct) {
        this.createProduct = createProduct;
    }

    public boolean isConvertUnits() {
        return this.convertUnits;
    }

    public void setConvertUnits(boolean convertUnits) {
        this.convertUnits = convertUnits;
    }

    public boolean isbConvertTilde() {
        return this.bConvertTilde;
    }

    public void setbConvertTilde(boolean bConvertTilde) {
        this.bConvertTilde = bConvertTilde;
    }

    public XJDFToJDFConverter(JDFDoc template) {
        super(new BaseWalkerFactory());
        this.jdfDoc = template == null ? null : template.clone();
        this.idMap = null;
        this.foundProduct = false;
        this.bConvertTilde = false;
        this.convertUnits = false;
        this.heuristicLink = true;
    }

    public void resetProduct() {
        this.foundProduct = false;
    }

    public JDFDoc convert(KElement xjdf) {
        if (xjdf == null) {
            return null;
        }
        if (this.jdfDoc == null) {
            this.jdfDoc = new JDFDoc("JDF");
            this.jdfDoc.copyMeta(xjdf.getOwnerDocument_KElement());
        }
        JDFNode root = this.prepareRoot();
        xjdf = this.reparse(xjdf);
        xjdf.setAttribute("Version", this.version.getName());
        JDFNode theNode = this.findNode(xjdf, true);
        if (theNode == null) {
            return null;
        }
        this.idMap = new IDFinder().getMap(xjdf);
        this.walkTree(xjdf, theNode);
        new PostConverter(theNode).postConvert();
        return this.jdfDoc;
    }

    protected KElement reparse(KElement xjdf) {
        if (xjdf != null && !(xjdf.getOwnerDocument() instanceof DocumentJDFImpl)) {
            JDFDoc doc = new JDFDoc(xjdf.getOwnerDocument());
            doc.setInitOnCreate(false);
            KElement xjdf2 = doc.getRoot();
            if (!xjdf2.getLocalName().equals(xjdf.getLocalName())) {
                xjdf2 = xjdf2.getChildByTagName(xjdf.getNodeName(), xjdf.getNamespaceURI(), 0, xjdf.getAttributeMap(), false, true);
            }
            int i = 0;
            while (xjdf2 != null) {
                if (xjdf.isEqual(xjdf2)) {
                    xjdf = xjdf2;
                    break;
                }
                xjdf2 = xjdf2.getChildByTagName(xjdf.getNodeName(), xjdf.getNamespaceURI(), ++i, xjdf.getAttributeMap(), false, true);
            }
            if (xjdf2 == null) {
                this.log.error((Object)"SNAFU converting xjdf - retaining old");
            }
        }
        return xjdf;
    }

    private JDFNode prepareRoot() {
        JDFNode root = this.jdfDoc.getJDFRoot();
        if (this.firstConvert) {
            root.getCreateAuditPool().addModified(null, null);
        } else if (!"Product".equals(root.getType())) {
            root = this.createProductRoot(root);
        }
        return root;
    }

    public boolean canConvert(KElement xjdf) {
        return xjdf == null ? false : "XJDF".equals(xjdf.getLocalName());
    }

    private JDFNode findNode(KElement xjdf, boolean create) {
        JDFNode n;
        JDFNode root = this.jdfDoc.getJDFRoot();
        String jpID = xjdf.getAttribute("JobPartID", null, null);
        JDFNode jDFNode = n = jpID == null ? null : root.getJobPart(jpID, null);
        if (n == null) {
            if (!root.hasAttribute("Type")) {
                return root;
            }
            if (jpID == null) {
                VElement nodes = root.getvJDFNode(null, null, false);
                VString xTypes = StringUtil.tokenize(xjdf.getAttribute("Types"), null, false);
                for (int i = 0; i < nodes.size(); ++i) {
                    JDFNode n2 = (JDFNode)nodes.get(i);
                    VString vtypes = n2.getAllTypes();
                    if (!vtypes.containsAll(xTypes)) continue;
                    return n2;
                }
            }
        }
        if (n == null && create) {
            n = root.addProcessGroup(new VString(xjdf.getAttribute("Types"), null));
        }
        return n;
    }

    boolean isXResourceElement(KElement toCheck) {
        boolean bReturn = false;
        if (toCheck != null) {
            KElement parent = toCheck.getParentNode_KElement();
            if (parent == null) {
                return bReturn;
            }
            KElement parent2 = parent.getParentNode_KElement();
            if (parent2 == null) {
                return bReturn;
            }
            String parentName = parent2.getLocalName();
            boolean bL1 = parentName.endsWith("Set") && toCheck.getLocalName().equals(parent2.getAttribute("Name"));
            bReturn = bL1 = bL1 || parentName.equals("Product") && toCheck.getLocalName().equals(parent.getAttribute("Name"));
        }
        return bReturn;
    }

    boolean isXResource(KElement toCheck) {
        KElement parent = toCheck.getParentNode_KElement();
        if (parent == null) {
            return false;
        }
        String localName = parent.getLocalName();
        boolean b = localName.endsWith("Set");
        b = b && toCheck.getLocalName().equals(StringUtil.leftStr(localName, -3));
        return b && parent.hasAttribute("Name");
    }

    protected JDFSeparationList createSeparationList(KElement rPart, String elem) {
        String c = rPart.getAttribute(elem, null, null);
        JDFSeparationList sepList = null;
        if (c != null) {
            sepList = (JDFSeparationList)rPart.getCreateElement(elem);
            sepList.setSeparations(new VString(c, null));
            rPart.removeAttribute(elem);
        }
        return sepList;
    }

    protected JDFNode createProductRoot(JDFNode theNode) {
        JDFNode parent = (JDFNode)this.jdfDoc.createElement("JDF");
        parent.setType(JDFNode.EnumType.Product);
        theNode = (JDFNode)parent.moveElement(theNode, null);
        this.jdfDoc.appendChild(parent);
        parent.moveAttribute("JobID", theNode);
        parent.moveAttribute("Version", theNode);
        parent.setJobPartID("rootPart");
        parent.moveElement(theNode.getResourcePool(), null);
        JDFComponent c = (JDFComponent)parent.addResource("Component", JDFResourceLink.EnumUsage.Output);
        c.setDescriptiveName("dummy output");
        c.setComponentType(JDFAutoComponent.EnumComponentType.FinalProduct, null);
        this.mergeProductLinks(theNode, parent);
        this.firstConvert = true;
        return parent;
    }

    protected void convertUnits(KElement e2) {
        if (this.convertUnits) {
            JDFAttributeMap map = e2.getAttributeMap();
            Iterator<String> keyIt = map.getKeyIterator();
            UnitParser up = new UnitParser();
            while (keyIt.hasNext()) {
                JDFDate d;
                String newVal;
                String key = keyIt.next();
                String val = map.get(key);
                if (!val.equals(newVal = up.extractUnits(val))) {
                    e2.setAttribute(key, newVal);
                }
                if (!(e2 instanceof JDFElement) || !AttributeInfo.EnumAttributeType.dateTime.equals((Object)((JDFElement)e2).getAttributeInfo().getAttributeType(key)) || (d = JDFDate.createDate(val)) == null || val.equals(d.getDateTimeISO())) continue;
                e2.setAttribute(key, d.getDateTimeISO());
            }
        }
    }

    protected void convertTilde(KElement e2) {
        if (this.bConvertTilde) {
            JDFAttributeMap map = e2.getAttributeMap();
            Iterator<String> keyIt = map.getKeyIterator();
            while (keyIt.hasNext()) {
                VString v;
                String key = keyIt.next();
                String val = map.get(key);
                if (!(e2 instanceof JDFElement) || !AttributeInfo.EnumAttributeType.isRange(((JDFElement)e2).getAttributeInfo().getAttributeType(key)) || (v = new VString(val, null)).size() % 2 != 0) continue;
                JDFNameRangeList nrl = new JDFNameRangeList();
                for (int i = 0; i < v.size(); i += 2) {
                    nrl.append(new JDFNameRange(v.get(i), v.get(i + 1)));
                }
                String newVal = nrl.getString(0);
                if (val.equals(newVal)) continue;
                e2.setAttribute(key, newVal);
            }
        }
    }

    private void mergeProductLinks(JDFNode theNode, JDFNode parent) {
        JDFResource rNode;
        this.mergeProductLink(theNode, parent, "CustomerInfo", JDFResourceLink.EnumUsage.Input);
        this.mergeProductLink(theNode, parent, "NodeInfo", JDFResourceLink.EnumUsage.Input);
        JDFResource r = parent.getResource("Component", JDFResourceLink.EnumUsage.Output, 0);
        if (r != null && "dummy outout".equals(r.getDescriptiveName()) && (rNode = theNode.getResource("Component", JDFResourceLink.EnumUsage.Output, 0)) != null) {
            parent.getLink(r, JDFResourceLink.EnumUsage.Output).deleteNode();
            r.deleteNode();
        }
        this.mergeProductLink(theNode, parent, "Component", JDFResourceLink.EnumUsage.Output);
    }

    private void mergeProductLink(JDFNode theNode, JDFNode parent, String resName, JDFResourceLink.EnumUsage enumUsage) {
        JDFResourceLink link;
        JDFResource r = parent.getResource(resName, enumUsage, 0);
        if (r == null && (link = theNode.getLink(0, resName, new JDFAttributeMap("Usage", enumUsage), null)) != null) {
            parent.ensureLink(link.getLinkRoot(), enumUsage, null);
        }
    }

    public void setVersion(JDFElement.EnumVersion version) {
        this.version = version;
    }

    public JDFElement.EnumVersion getVersion() {
        return this.version;
    }

    protected void attributesToSpan(KElement e) {
        JDFAttributeMap map = e.getAttributeMap();
        JDFElement ir = (JDFElement)e;
        VString keys = map.getKeys();
        VString knownElements = ir.knownElements();
        for (String name : keys) {
            if (!knownElements.contains(name)) continue;
            this.attributeToSpan(e, name);
        }
    }

    protected KElement attributeToSpan(KElement e, String name) {
        KElement subElem = e.appendElement(name);
        subElem.init();
        subElem.setAttribute("Actual", e.getAttribute(name));
        this.convertUnits(subElem);
        this.convertTilde(subElem);
        e.removeAttribute(name);
        return subElem;
    }

    protected void moveToLink(JDFResourceLink rl, JDFAttributeMap partmap, JDFAttributeMap map, String a) {
        if (map == null || map.isEmpty()) {
            return;
        }
        VString vGW = new VString("Good Waste", null);
        for (String gw : vGW) {
            JDFAttributeMap pm = new JDFAttributeMap(partmap);
            pm.put("Condition", gw);
            if (map.get(a + gw) == null) continue;
            if (rl != null) {
                rl.setAmountPoolAttribute(a, map.get(a + gw), null, pm);
            }
            map.remove(a + gw);
        }
    }

    protected void moveAmountsToLink(JDFAttributeMap partmap, JDFAttributeMap map, JDFResourceLink rl) {
        this.moveToLink(rl, partmap, map, "Amount");
        this.moveToLink(rl, partmap, map, "ActualAmount");
        this.moveToLink(rl, partmap, map, "MaxAmount");
    }

    public void setConvertTilde(boolean b) {
        this.bConvertTilde = b;
    }

    public void setHeuristicLink(boolean heuristicLink) {
        this.heuristicLink = heuristicLink;
    }

    public boolean isHeuristicLink() {
        return this.heuristicLink;
    }

    public class WalkIntent
    extends WalkXElement {
        @Override
        public KElement walk(KElement e, KElement trackElem) {
            IntentHelper h;
            String name;
            String id;
            JDFNode parent = (JDFNode)trackElem;
            JDFNode root = parent.getJDFRoot();
            JDFResourceLink.EnumUsage inOut = JDFResourceLink.EnumUsage.getEnum(e.getAttribute("Usage"));
            if (inOut == null) {
                inOut = JDFResourceLink.EnumUsage.Input;
            }
            if ((id = e.getAttribute("ID", null, null)) == null) {
                id = "r" + KElement.uniqueID(0);
                e.setAttribute("ID", id);
            }
            JDFResource r = null;
            KElement idElem = parent.getCreateResourcePool().getChildWithAttribute(null, "ID", null, id, 0, true);
            if (idElem instanceof JDFResource) {
                r = (JDFResource)idElem;
            } else {
                JDFResourcePool rp;
                r = (JDFResource)root.getChildWithAttribute(null, "ID", null, id, 0, false);
                if (r != null && !(rp = root.getCreateResourcePool()).equals(r.getParentNode_KElement())) {
                    rp.moveElement(r, null);
                }
            }
            if (r == null && (name = (h = new IntentHelper(e)).getName()) != null) {
                r = parent.addResource(name, null);
                r.removeAttribute("Status");
            }
            if (r != null) {
                JDFResourceLink rl;
                r.setAttributes(e);
                if (r.getResourceClass() == null) {
                    r.setResourceClass(JDFResource.EnumResourceClass.Intent);
                }
                if ((rl = parent.ensureLink(r, inOut, null)) != null) {
                    rl.setrRef(id);
                    r.removeAttribute("Usage");
                    rl.moveAttribute("ProcessUsage", r);
                    rl.moveAttribute("Amount", r);
                    rl.moveAttribute("ActualAmount", r);
                    rl.moveAttribute("MaxAmount", r);
                    rl.moveAttribute("MinAmount", r);
                }
                r.removeAttribute("Name");
                r.removeAttribute("Usage");
                if (!r.hasAttribute("Status")) {
                    r.setResStatus(JDFResource.EnumResStatus.Available, true);
                }
            }
            return r;
        }

        @Override
        public boolean matches(KElement toCheck) {
            KElement parent = toCheck.getParentNode_KElement();
            boolean bL1 = parent != null && parent.getLocalName().equals("Product");
            return bL1 && super.matches(toCheck) && toCheck.getLocalName().equals("Intent");
        }
    }

    public class WalkNodeInfo
    extends WalkResource {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFNodeInfo;
        }

        @Override
        public KElement walk(KElement e, KElement trackElem) {
            JDFNode theNode = XJDFToJDFConverter.this.currentJDFNode == null ? ((JDFElement)trackElem).getParentJDF() : XJDFToJDFConverter.this.currentJDFNode;
            JDFNodeInfo ni = (JDFNodeInfo)trackElem;
            JDFAttributeMap partmap = ni.getPartMap();
            JDFAttributeMap map = e.getAttributeMap();
            JDFAttributeMap map2 = map.clone();
            JDFResourceLink rl = theNode.getLink((JDFResource)ni, null);
            XJDFToJDFConverter.this.moveAmountsToLink(partmap, map, rl);
            map2.removeKeys(map.getKeys());
            e.removeAttributes(map2.getKeys());
            return super.walk(e, trackElem);
        }
    }

    public class WalkLayoutElement
    extends WalkResource {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFLayoutElement;
        }

        @Override
        public KElement walk(KElement e, KElement trackElem) {
            if (e.hasAttribute("Dependencies")) {
                e.appendElement("Dependencies").moveAttribute("RunListRefs", e, "Dependencies", null, null);
            }
            return super.walk(e, trackElem);
        }
    }

    public class WalkRunList
    extends WalkResource {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFRunList;
        }

        @Override
        public KElement walk(KElement e, KElement trackElem) {
            this.splitLayoutElem(e);
            return super.walk(e, trackElem);
        }

        private void splitLayoutElem(KElement e) {
            if (!e.hasChildElement("LayoutElement", null)) {
                JDFElement loe = (JDFElement)e.appendElement("LayoutElement");
                VString vAtt = loe.knownAttributes();
                vAtt.appendUnique("Dependencies");
                JDFAttributeMap map = e.getAttributeMap();
                Iterator<String> it = map.getKeyIterator();
                while (it.hasNext()) {
                    String s = it.next();
                    if (!vAtt.contains(s)) continue;
                    loe.setAttribute(s, map.get(s));
                    e.removeAttribute(s);
                }
                VString vElm = loe.knownElements();
                VElement vMyElm = e.getChildElementVector(null, null);
                for (int i = 0; i < vMyElm.size(); ++i) {
                    if (!vElm.contains(vMyElm.get(i).getLocalName())) continue;
                    loe.moveElement(vMyElm.get(i), null);
                }
            }
        }
    }

    public class WalkColorantControl
    extends WalkResource {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFColorantControl;
        }

        @Override
        public KElement walk(KElement e, KElement trackElem) {
            KElement rPart = super.walk(e, trackElem);
            XJDFToJDFConverter.this.createSeparationList(rPart, "ColorantParams");
            XJDFToJDFConverter.this.createSeparationList(rPart, "ColorantOrder");
            XJDFToJDFConverter.this.createSeparationList(rPart, "DeviceColorantOrder");
            return rPart;
        }
    }

    public class WalkMedia
    extends WalkResource {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFMedia;
        }

        @Override
        public KElement walk(KElement e, KElement trackElem) {
            JDFResource root;
            KElement rPart = super.walk(e, trackElem);
            if (rPart != null && (root = ((JDFResource)rPart).getResourceRoot()) != null && root != rPart && !root.hasAttribute("MediaType")) {
                root.copyAttribute("MediaType", rPart);
            }
            return rPart;
        }
    }

    public class WalkCompany
    extends WalkResource {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFCompany;
        }

        @Override
        public KElement walk(KElement e, KElement trackElem) {
            e.renameAttribute("CompanyID", "ProductID", null, null);
            return super.walk(e, trackElem);
        }
    }

    public class WalkLayout
    extends WalkStrippingParams {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFLayout;
        }
    }

    public class WalkStrippingParams
    extends WalkResource {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFStrippingParams;
        }

        @Override
        protected String getRefName(String val) {
            if ("PaperRef".equals(val) || "PlateRef".equals(val) || "ProofRef".equals(val)) {
                return "MediaRef";
            }
            return super.getRefName(val);
        }
    }

    public class WalkXJDFColorSet
    extends WalkSet {
        @Override
        public boolean matches(KElement toCheck) {
            return super.matches(toCheck) && "Color".equals(toCheck.getAttribute("Name"));
        }

        @Override
        public KElement walk(KElement e, KElement trackElem) {
            JDFNode theNode = (JDFNode)trackElem;
            KElement k2 = super.walk(e, trackElem);
            JDFResource r = (JDFResource)k2;
            JDFResourceLink rl = theNode.getLink(r, null);
            if (rl != null) {
                rl.renameElement("ColorPoolLink", null);
            }
            r.renameElement("ColorPool", null);
            r.removeAttribute("PartIDKeys");
            return k2;
        }
    }

    public class WalkXJDFResource
    extends WalkXElement {
        @Override
        public KElement walk(KElement e, KElement trackElem) {
            JDFResource newPartition;
            JDFNode theNode = XJDFToJDFConverter.this.currentJDFNode == null ? ((JDFElement)trackElem).getParentJDF() : XJDFToJDFConverter.this.currentJDFNode;
            JDFPart part = (JDFPart)e.getElement("Part");
            JDFAttributeMap partmap = null;
            if (part != null) {
                newPartition = this.createPartition(e, trackElem, part);
                partmap = part.getPartMap();
            } else if (e.getPreviousSiblingElement(e.getNodeName(), null) != null) {
                newPartition = theNode.getJDFRoot().addResource(trackElem.getLocalName(), null);
                newPartition.copyAttribute("ID", e);
            } else {
                newPartition = (JDFResource)trackElem;
            }
            if (newPartition == null) {
                return null;
            }
            JDFAttributeMap map = e.getAttributeMap();
            map.remove("ID");
            map.remove("PartIDKeys");
            JDFResourceLink rl = theNode.getLink(newPartition, null);
            XJDFToJDFConverter.this.moveAmountsToLink(partmap, map, rl);
            newPartition.setAttributes(map);
            return newPartition;
        }

        protected JDFResource createPartition(KElement e, KElement trackElem, JDFPart part) {
            VJDFAttributeMap partMapVector;
            JDFNode theNode = XJDFToJDFConverter.this.currentJDFNode == null ? ((JDFElement)trackElem).getParentJDF() : XJDFToJDFConverter.this.currentJDFNode;
            JDFResource r = (JDFResource)trackElem;
            JDFAttributeMap partMap = part.getPartMap();
            JDFResource rPart = r.getCreatePartition(partMap, part.guessPartIDKeys());
            JDFResourceLink rll = theNode.getLink(r, null);
            VJDFAttributeMap vJDFAttributeMap = partMapVector = rll != null ? rll.getPartMapVector() : null;
            if (!(rll == null || partMapVector != null && partMapVector.contains(partMap))) {
                rll.moveElement(part, null);
            }
            return rPart;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return super.matches(toCheck) && XJDFToJDFConverter.this.isXResource(toCheck);
        }
    }

    public class WalkXJDFColorResource
    extends WalkXJDFResource {
        @Override
        protected JDFResource createPartition(KElement e, KElement trackElem, JDFPart part) {
            JDFNode theNode = ((JDFElement)trackElem).getParentJDF();
            JDFResource r = (JDFResource)trackElem;
            String sep = part.getSeparation();
            KElement col = r.getChildWithAttribute("Color", "Name", null, sep, 0, true);
            if (col != null) {
                return null;
            }
            JDFResource rPart = r.getCreatePartition(part.getPartMap(), part.guessPartIDKeys());
            JDFResourceLink rll = theNode.getLink(r, null);
            if (rll != null) {
                rll.removeChildren("Part", null, null);
            }
            rPart.renameElement("Color", null);
            rPart.renameAttribute("Separation", "Name", null, null);
            r.removeFromAttribute("PartIDKeys", "Separation", null, " ", -1);
            return rPart;
        }

        @Override
        public boolean matches(KElement toCheck) {
            KElement parent = toCheck.getParentNode_KElement();
            if (parent == null) {
                return false;
            }
            boolean bL1 = parent.getLocalName().endsWith("Set");
            return bL1 && super.matches(toCheck) && "Color".equals(parent.getAttribute("Name"));
        }

        @Override
        public KElement walk(KElement e, KElement trackElem) {
            KElement rPart = super.walk(e, trackElem);
            if (rPart != null) {
                rPart.removeAttribute("Status");
            }
            return rPart;
        }
    }

    public class WalkIgnore
    extends WalkXElement {
        @Override
        public KElement walk(KElement e, KElement trackElem) {
            return null;
        }

        @Override
        public boolean matches(KElement toCheck) {
            boolean matches = super.matches(toCheck);
            boolean m1 = toCheck instanceof JDFPart && XJDFToJDFConverter.this.isXResource(toCheck.getParentNode_KElement());
            boolean m2 = "ChildProduct".equals(toCheck.getLocalName());
            boolean m3 = "ProcessList".equals(toCheck.getLocalName());
            boolean m4 = "Dependent".equals(toCheck.getLocalName());
            return matches && (m1 || m2 || m3 || m4);
        }
    }

    public class WalkContinue
    extends WalkXElement {
        @Override
        public KElement walk(KElement e, KElement trackElem) {
            return trackElem;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return false;
        }
    }

    public class WalkProductList
    extends WalkXElement {
        @Override
        public KElement walk(KElement e, KElement trackElem) {
            e.deleteNode();
            boolean bFirst = XJDFToJDFConverter.this.foundProductList;
            XJDFToJDFConverter.this.foundProductList = true;
            if (XJDFToJDFConverter.this.createProduct && !XJDFToJDFConverter.this.foundProduct && e.numChildElements("Product", null) > 1) {
                XJDFToJDFConverter.this.createProductRoot(XJDFToJDFConverter.this.currentJDFNode);
            }
            JDFNode theReturn = XJDFToJDFConverter.this.currentJDFNode;
            if (!"Product".equals(XJDFToJDFConverter.this.currentJDFNode.getType())) {
                theReturn = XJDFToJDFConverter.this.jdfDoc.getJDFRoot();
            }
            return XJDFToJDFConverter.this.createProduct && !bFirst ? theReturn : null;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return super.matches(toCheck) && toCheck.getLocalName().equals("ProductList");
        }
    }

    public class WalkChildProduct
    extends WalkXElement {
        @Override
        public KElement walk(KElement e, KElement trackElem) {
            JDFNode theNode = (JDFNode)trackElem;
            KElement parent = e.getParentNode_KElement();
            String parentID = parent.getAttribute("ID");
            JDFNode nodeParent = theNode.getRoot().getChildJDFNode(parentID, false);
            if (nodeParent != null) {
                JDFNode tmp2 = nodeParent.addProduct();
                tmp2.copyAttribute("ID", e, "ChildRef", null, null);
            }
            return null;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return super.matches(toCheck) && toCheck.getLocalName().equals("ChildProduct");
        }
    }

    public class WalkProduct
    extends WalkXElement {
        @Override
        public KElement walk(KElement e, KElement trackElem) {
            JDFNode theNode = (JDFNode)trackElem;
            if ("Product".equals(theNode.getType())) {
                JDFNode tmp = theNode.getRoot().getChildJDFNode(e.getAttribute("ID"), false);
                if (tmp != null) {
                    theNode = tmp;
                } else if (theNode != XJDFToJDFConverter.this.currentJDFNode && !XJDFToJDFConverter.this.firstproductInList) {
                    theNode = theNode.addProduct();
                }
            } else {
                theNode = XJDFToJDFConverter.this.createProductRoot(theNode);
            }
            XJDFToJDFConverter.this.firstproductInList = false;
            theNode.setAttributes(e);
            this.fixComponent(theNode, e);
            return theNode;
        }

        private void fixComponent(JDFNode theNode, KElement xjdfProduct) {
            JDFComponent c = (JDFComponent)theNode.getResource("Component", JDFResourceLink.EnumUsage.Output, 0);
            if (c == null) {
                c = (JDFComponent)theNode.addResource("Component", JDFResourceLink.EnumUsage.Output);
                JDFAutoComponent.EnumComponentType partialFinal = new ProductHelper(xjdfProduct).isRootProduct() ? JDFAutoComponent.EnumComponentType.FinalProduct : JDFAutoComponent.EnumComponentType.PartialProduct;
                c.setComponentType(partialFinal, null);
            }
            AttributeInfo info = c.getAttributeInfo();
            VString cKnown = info.knownAttribs();
            AttributeInfo infoNode = theNode.getAttributeInfo();
            cKnown.removeAll(infoNode.knownAttribs());
            cKnown.remove("Amount");
            cKnown.remove("ActualAmount");
            for (String known : cKnown) {
                if (!theNode.hasAttribute(known)) continue;
                c.moveAttribute(known, theNode);
            }
            JDFResourceLink rl = theNode.getLink((JDFResource)c, JDFResourceLink.EnumUsage.Output);
            if (rl != null) {
                rl.moveAttribute("Amount", theNode);
            }
        }

        @Override
        public boolean matches(KElement toCheck) {
            return super.matches(toCheck) && toCheck.getLocalName().equals("Product");
        }
    }

    public class WalkReplace
    extends WalkXElement {
        @Override
        public KElement walk(KElement e, KElement trackElem) {
            trackElem.removeChildren(e.getNodeName(), null, null);
            return super.walk(e, trackElem);
        }

        @Override
        public boolean matches(KElement toCheck) {
            return super.matches(toCheck) && toCheck instanceof JDFAuditPool;
        }
    }

    public class WalkIntentElement
    extends WalkXElement {
        @Override
        public KElement walk(KElement e, KElement trackElem) {
            XJDFToJDFConverter.this.attributesToSpan(e);
            return super.walk(e, trackElem);
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFDropIntent || toCheck instanceof JDFDropItemIntent || toCheck instanceof JDFArtDelivery || toCheck instanceof JDFBindItem || toCheck instanceof JDFChannelBinding || toCheck instanceof JDFCoilBinding || toCheck instanceof JDFEdgeGluing || toCheck instanceof JDFHardCoverBinding || toCheck instanceof JDFPlasticCombBinding || toCheck instanceof JDFRingBinding || toCheck instanceof JDFSaddleStitching || toCheck instanceof JDFSideSewing || toCheck instanceof JDFSoftCoverBinding || toCheck instanceof JDFStripBinding || toCheck instanceof JDFTabs || toCheck instanceof JDFThreadSealing || toCheck instanceof JDFThreadSewing || toCheck instanceof JDFEmbossingItem || toCheck instanceof JDFInsert || toCheck instanceof JDFNumberItem || toCheck instanceof JDFProofItem || toCheck instanceof JDFShapeCut;
        }
    }

    public class WalkIntentResource
    extends WalkResource {
        @Override
        public KElement walk(KElement e, KElement trackElem) {
            XJDFToJDFConverter.this.attributesToSpan(e);
            return super.walk(e, trackElem);
        }

        @Override
        public boolean matches(KElement toCheck) {
            return super.matches(toCheck) && toCheck instanceof JDFIntentResource;
        }
    }

    public class WalkColorIntent
    extends WalkIntentResource {
        final VString backAtts = new VString("Coatings ColorStandard Coverage", null);

        @Override
        public KElement walk(KElement e, KElement trackElem) {
            this.evaluateColorsUsed(e);
            if (e.hasAttribute("NumColors")) {
                this.evaluateNumColors(e, trackElem);
            }
            for (String att : this.backAtts) {
                this.evaluateBackAttribute(e, att);
            }
            KElement ret = super.walk(e, trackElem);
            this.repartitionSide(e, trackElem);
            return ret;
        }

        private void repartitionSide(KElement e, KElement trackElem) {
            KElement cuBack = e.getElement("ColorsUsedBack");
            KElement cuFront = e.getElement("ColorsUsed");
            if (cuBack != null && cuFront != null) {
                VElement sepsBack;
                VElement sepsFront = cuFront.getChildElementVector("SeparationSpec", null);
                if (!sepsFront.isEqual(sepsBack = cuBack.getChildElementVector("SeparationSpec", null))) {
                    if (cuFront.getElement("SeparationSpec") != null) {
                        JDFResource ciFront = ((JDFResource)trackElem).getCreatePartition(JDFResource.EnumPartIDKey.Side, "Front", null);
                        ciFront.moveElement(cuFront, null);
                    } else {
                        cuFront.deleteNode();
                    }
                    if (cuBack.getElement("SeparationSpec") != null) {
                        JDFResource ciBack = ((JDFResource)trackElem).getCreatePartition(JDFResource.EnumPartIDKey.Side, "Back", null);
                        cuBack.renameElement("ColorsUsed", null);
                        ciBack.moveElement(cuBack, null);
                    } else {
                        cuBack.deleteNode();
                    }
                } else {
                    cuBack.deleteNode();
                }
            } else if (cuBack == null && cuFront != null) {
                if (cuFront.getElement("SeparationSpec") != null) {
                    JDFResource ciFront = ((JDFResource)trackElem).getCreatePartition(JDFResource.EnumPartIDKey.Side, "Front", null);
                    ciFront.moveElement(cuFront, null);
                } else {
                    cuFront.deleteNode();
                }
            } else if (cuBack != null && cuFront == null) {
                if (cuBack.getElement("SeparationSpec") != null) {
                    JDFResource ciBack = ((JDFResource)trackElem).getCreatePartition(JDFResource.EnumPartIDKey.Side, "Back", null);
                    ciBack.moveElement(cuBack, null);
                } else {
                    cuBack.deleteNode();
                }
            }
            for (String att : this.backAtts) {
                String back = att + "Back";
                KElement coatBack = e.getElement(back);
                if (coatBack != null) {
                    KElement coatings = e.getElement(att);
                    if (coatings != null) {
                        JDFResource ciFront = ((JDFResource)trackElem).getCreatePartition(JDFResource.EnumPartIDKey.Side, "Front", null);
                        ciFront.moveElement(coatings, null);
                    }
                    JDFResource ciBack = ((JDFResource)trackElem).getCreatePartition(JDFResource.EnumPartIDKey.Side, "Back", null);
                    ciBack.moveElement(e.getElement(back), null).renameElement(att, null);
                }
                this.evaluateBackAttribute(e, att);
            }
        }

        private void evaluateColorsUsed(KElement e) {
            JDFSeparationList sl = XJDFToJDFConverter.this.createSeparationList(e, "ColorsUsed");
            if (e.hasAttribute("ColorsUsedBack")) {
                if (sl != null) {
                    sl = (JDFSeparationList)sl.deleteNode();
                }
                e.renameAttribute("ColorsUsedBack", "ColorsUsed", null, null);
                JDFSeparationList slBack = XJDFToJDFConverter.this.createSeparationList(e, "ColorsUsed");
                slBack.renameElement("ColorsUsedBack", null);
                if (sl != null) {
                    e.moveElement(sl, slBack);
                }
            }
        }

        private void evaluateBackAttribute(KElement e, String front) {
            String back = front + "Back";
            if (e.hasAttribute(back)) {
                String frontVal = e.getAttribute(front, null, null);
                e.renameAttribute(back, front, null, null);
                KElement span = XJDFToJDFConverter.this.attributeToSpan(e, front);
                span.renameElement(back, null);
                e.setAttribute(front, frontVal);
            }
        }

        private void evaluateNumColors(KElement e, KElement trackElem) {
            JDFXYPair xyp = JDFXYPair.createXYPair(e.getAttribute("NumColors", null, null));
            if (xyp != null) {
                double[] list = xyp.getDoubleList();
                e.removeAttribute("NumColors");
                for (int i = list.length - 1; i >= 0; --i) {
                    int n = (int)(list[i] + 0.5);
                    VString v = this.getDefaultSeparations(n);
                    KElement cuf = null;
                    if (i == 1) {
                        KElement cub;
                        cuf = e.getElement("ColorsUsed");
                        if (cuf != null) {
                            cuf.renameElement("ColorsUsedFront", null);
                        }
                        if ((cub = e.getElement("ColorsUsedBack")) != null) {
                            cub.renameElement("ColorsUsed", null);
                        }
                    }
                    JDFSeparationList newElem = (JDFSeparationList)e.getCreateElement("ColorsUsed");
                    newElem.appendSeparations(v);
                    newElem.unify();
                    if (i != 1) continue;
                    newElem.renameElement("ColorsUsedBack", null);
                    if (cuf == null) continue;
                    cuf.renameElement("ColorsUsed", null);
                }
            }
        }

        private VString getDefaultSeparations(int n) {
            VString v = new VString("Black Cyan Magenta Yellow Spot1 Spot2 Spot3 Spot4", null);
            while (v.size() > n) {
                v.remove(n);
            }
            return v;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return super.matches(toCheck) && toCheck instanceof JDFColorIntent;
        }
    }

    public class WalkResource
    extends WalkXElement {
        @Override
        public KElement walk(KElement e, KElement trackElem) {
            e.removeAttribute("Class");
            return super.walk(e, trackElem);
        }

        @Override
        public boolean matches(KElement toCheck) {
            return super.matches(toCheck) && XJDFToJDFConverter.this.isXResourceElement(toCheck);
        }
    }

    public class WalkSet
    extends WalkXElement {
        @Override
        public KElement walk(KElement e, KElement trackElem) {
            SetHelper h;
            String name;
            SetHelper h2;
            String name2;
            JDFNode parent = (JDFNode)trackElem;
            JDFNode root = parent.getJDFRoot();
            JDFResourceLink.EnumUsage inOut = JDFResourceLink.EnumUsage.getEnum(e.getAttribute("Usage"));
            String id = e.getAttribute("ID", null, null);
            if (inOut == null && XJDFToJDFConverter.this.isHeuristicLink() && "ParameterSet".equals(e.getLocalName()) && !"Contact".equals(name2 = (h2 = new SetHelper(e)).getName()) && !"LayoutElement".equals(name2) && !"RunList".equals(name2)) {
                inOut = JDFResourceLink.EnumUsage.Input;
            }
            JDFResource r = null;
            KElement idElem = root.getCreateResourcePool().getChildWithAttribute(null, "ID", null, id, 0, true);
            if (idElem instanceof JDFResource) {
                r = (JDFResource)idElem;
            } else {
                JDFResourcePool rp;
                r = (JDFResource)root.getChildWithAttribute(null, "ID", null, id, 0, false);
                if (r != null && !(rp = root.getCreateResourcePool()).equals(r.getParentNode_KElement())) {
                    rp.moveElement(r, null);
                }
            }
            if (r == null && (name = (h = new SetHelper(e)).getName()) != null) {
                r = root.addResource(name, null);
                r.removeAttribute("Status");
            }
            if (r != null) {
                JDFResourceLink rl;
                r.setAttributes(e);
                if (r.getResourceClass() == null) {
                    String name3 = StringUtil.leftStr(e.getLocalName(), -3);
                    r.setResourceClass("Parameter".equals(name3) ? JDFResource.EnumResourceClass.Parameter : JDFResource.EnumResourceClass.Handling);
                }
                if (inOut != null && (rl = parent.ensureLink(r, inOut, null)) != null) {
                    rl.setrRef(id);
                    r.removeAttribute("Usage");
                    rl.moveAttribute("ProcessUsage", r);
                    rl.moveAttribute("Amount", r);
                    rl.moveAttribute("ActualAmount", r);
                    rl.moveAttribute("MaxAmount", r);
                    rl.moveAttribute("MinAmount", r);
                }
                if (!r.hasAttribute("Status")) {
                    r.setResStatus(JDFResourceLink.EnumUsage.Output.equals((Object)inOut) ? JDFResource.EnumResStatus.Unavailable : JDFResource.EnumResStatus.Available, true);
                }
                r.removeAttribute("Name");
                r.removeAttribute("Usage");
            }
            return r;
        }

        @Override
        public boolean matches(KElement toCheck) {
            KElement parent = toCheck.getParentNode_KElement();
            boolean bL1 = parent != null && (parent.getLocalName().equals("XJDF") || parent.getLocalName().equals("Product"));
            String localName = toCheck.getLocalName();
            return bL1 && super.matches(toCheck) && localName.endsWith("Set") && (toCheck.hasAttribute("Name") || toCheck.getElement(StringUtil.leftStr(localName, -3)) != null);
        }
    }

    public class WalkSpan
    extends WalkXElement {
        @Override
        public KElement walk(KElement e, KElement trackElem) {
            KElement eNew = trackElem.appendElement(e.getAttribute("Name"));
            eNew.setAttributes(e);
            XJDFToJDFConverter.this.convertUnits(eNew);
            eNew.removeAttribute("Name");
            eNew.setAttribute("DataType", e.getLocalName());
            return eNew;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck.getLocalName().endsWith("Span");
        }
    }

    public class WalkXJDF
    extends WalkXElement {
        @Override
        public KElement walk(KElement e, KElement trackElem) {
            XJDFToJDFConverter.this.currentJDFNode = (JDFNode)trackElem;
            XJDFToJDFConverter.this.currentJDFNode.setAttributes(e);
            XJDFToJDFConverter.this.currentJDFNode.setVersion(XJDFToJDFConverter.this.getVersion());
            XJDFToJDFConverter.this.currentJDFNode.setStatus(JDFElement.EnumNodeStatus.Part);
            this.removeInheritedJobID();
            this.setTypes();
            return XJDFToJDFConverter.this.currentJDFNode;
        }

        private void setTypes() {
            String t = XJDFToJDFConverter.this.currentJDFNode.getAttribute("Types", null, null);
            if ("Product".equals(t)) {
                XJDFToJDFConverter.this.currentJDFNode.setType(JDFNode.EnumType.Product);
                XJDFToJDFConverter.this.currentJDFNode.removeAttribute("Types");
                XJDFToJDFConverter.this.createProduct = true;
                XJDFToJDFConverter.this.foundProduct = true;
            } else if (StringUtil.tokenize(t, null, false).size() == 1) {
                XJDFToJDFConverter.this.currentJDFNode.setType(t.trim(), false);
            } else {
                XJDFToJDFConverter.this.currentJDFNode.setType(JDFNode.EnumType.ProcessGroup);
            }
        }

        private void removeInheritedJobID() {
            JDFNode parent = XJDFToJDFConverter.this.currentJDFNode.getParentJDF();
            if (parent != null) {
                String jobID = StringUtil.getNonEmpty(parent.getJobID(true));
                String myJobID = StringUtil.getNonEmpty(XJDFToJDFConverter.this.currentJDFNode.getJobID(false));
                if (myJobID != null && myJobID.equals(jobID)) {
                    XJDFToJDFConverter.this.currentJDFNode.removeAttribute("JobID");
                }
            }
        }

        @Override
        public boolean matches(KElement toCheck) {
            return super.matches(toCheck) && "XJDF".equals(toCheck.getLocalName());
        }
    }

    protected class WalkXElement
    extends BaseWalker {
        public WalkXElement() {
            super(XJDFToJDFConverter.this.getFactory());
        }

        @Override
        public KElement walk(KElement e, KElement trackElem) {
            VElement v = trackElem.getChildElementVector(null, null);
            for (int i = 0; i < v.size(); ++i) {
                KElement kk = v.get(i);
                if (!e.isEqual(kk)) continue;
                return null;
            }
            this.cleanRefs(e, trackElem);
            if (XJDFToJDFConverter.this.isXResourceElement(e)) {
                trackElem.setAttributes(e);
            } else {
                KElement e2 = trackElem.copyElement(e, null);
                XJDFToJDFConverter.this.convertUnits(e2);
                XJDFToJDFConverter.this.convertTilde(e2);
                this.fixNamespace(e2);
                e2.removeChildren(null, null, null);
                trackElem = e2;
            }
            XJDFToJDFConverter.this.convertUnits(trackElem);
            XJDFToJDFConverter.this.convertTilde(trackElem);
            return trackElem;
        }

        private void fixNamespace(KElement e2) {
            String namespace = e2.getNamespaceURI();
            if (JDFElement.getSchemaURL(2, 0).equals(StringUtil.leftStr(namespace, -1) + 0)) {
                e2.setNamespaceURI(JDFElement.getSchemaURL(1, 1));
            }
        }

        protected String getRefName(String val) {
            String refName = val.endsWith("Refs") ? StringUtil.leftStr(val, -1) : val;
            return refName;
        }

        protected void cleanRefs(KElement e, KElement trackElem) {
            JDFAttributeMap map = e.getAttributeMap();
            if (map == null) {
                return;
            }
            VString keys = map.getKeys();
            if (keys != null) {
                int keySize = keys.size();
                for (int i = 0; i < keySize; ++i) {
                    String val = keys.get(i);
                    if (!val.endsWith("Ref") && !val.endsWith("Refs") || val.equals("rRef")) continue;
                    String values = map.get(val);
                    this.cleanRef(e, trackElem, val, values);
                }
            }
        }

        protected void cleanRef(KElement e, KElement trackElem, String val, String values) {
            VString vValues = StringUtil.tokenize(values, null, false);
            for (String value : vValues) {
                IDFinder.IDPart p = XJDFToJDFConverter.this.idMap.get(value);
                if (p == null) continue;
                String refName = this.getRefName(val);
                if (refName != null) {
                    KElement refOld = trackElem != null ? trackElem.getElement(refName) : null;
                    KElement ref = e.appendElement(refName);
                    ref.setAttribute("rRef", p.getID());
                    VJDFAttributeMap vpartmap = p.getPartMap();
                    if (vpartmap != null) {
                        for (int j = 0; j < vpartmap.size(); ++j) {
                            ref.appendElement("Part").setAttributes(vpartmap.get(j));
                        }
                    }
                    if (ref.isEqual(refOld)) {
                        ref.deleteNode();
                    }
                }
                e.removeAttribute(val);
            }
        }
    }

    private class PostConverter {
        private final JDFNode theNode;

        public PostConverter(JDFNode theNode) {
            this.theNode = theNode;
        }

        void postConvert() {
            JDFNode root = this.theNode.getJDFRoot();
            if ("Product".equals(root.getType())) {
                XJDFToJDFConverter.this.mergeProductLinks(this.theNode, root);
            }
            this.cleanResources();
            this.fixDependencies(root);
            new UnLinkFinder().eraseUnlinked(root);
            XJDFToJDFConverter.this.firstConvert = false;
            EnsureNSUri fixNS = new EnsureNSUri();
            fixNS.addNS(null, JDFElement.getSchemaURL());
            fixNS.walk(root);
        }

        private void cleanResources() {
            VElement vRes = this.collectResources();
            if (vRes != null) {
                for (KElement rr : vRes) {
                    this.cleanResource(rr);
                }
            }
        }

        private VElement collectResources() {
            VElement vRes = new VElement();
            for (JDFNode n = this.theNode; n != null; n = n.getParentJDF()) {
                JDFResourcePool rp = n.getResourcePool();
                VElement v = rp == null ? null : rp.getPoolChildren(null, null, null);
                vRes.addAll(v);
            }
            return vRes;
        }

        private void cleanResource(KElement rr) {
            JDFResource r = (JDFResource)rr;
            if (r != null) {
                JDFResource.EnumResStatus s = r.getStatusFromLeaves(false);
                if (s != null) {
                    r.setResStatus(s, false);
                }
                if ("ColorPool".equals(r.getLocalName())) {
                    this.cleanColorPool(r);
                }
            }
        }

        private void cleanColorPool(JDFResource r) {
            VElement v;
            String id = r.getID();
            if (StringUtil.getNonEmpty(id) != null && (v = this.theNode.getRoot().getChildrenByTagName_KElement(null, null, new JDFAttributeMap("rRef", id), false, false, 0)) != null) {
                for (KElement e : v) {
                    String name = e.getLocalName();
                    if ("ColorRef".equals(name)) {
                        name = StringUtil.leftStr(e.getNodeName(), -3) + "PoolRef";
                        e.renameElement(name, null);
                        continue;
                    }
                    if (!"ColorLink".equals(name)) continue;
                    name = StringUtil.leftStr(e.getNodeName(), -4) + "PoolLink";
                    e.renameElement(name, null);
                }
            }
        }

        private void fixDependencies(JDFNode root) {
            Vector<JDFDependencies> vDep = root.getChildrenByClass(JDFDependencies.class, true, 0);
            if (vDep == null) {
                return;
            }
            for (JDFDependencies dep : vDep) {
                this.fixOneDependencies(dep);
            }
        }

        private void fixOneDependencies(JDFDependencies dep) {
            if (dep == null) {
                return;
            }
            VElement v = dep.getChildElementVector_KElement("RunListRef", null, null, true, 0);
            if (v == null) {
                return;
            }
            for (KElement e : v) {
                JDFRefElement rl = (JDFRefElement)e;
                rl.renameElement("LayoutElementRef", null);
                JDFResource root = rl.getTargetRoot();
                if (root == null) continue;
                VElement vR = root.getLeaves(true);
                VElement v2 = root.getLinksAndRefs(true, false);
                if (v2 != null) {
                    for (KElement rl2 : v2) {
                        rl2.renameElement("LayoutElementLink", null);
                    }
                }
                if ((v2 = root.getLinksAndRefs(false, true)) != null) {
                    for (KElement rl2 : v2) {
                        rl2.renameElement("LayoutElementRef", null);
                    }
                }
                for (KElement r : vR) {
                    JDFLayoutElement loe;
                    JDFLayoutElement jDFLayoutElement = loe = r instanceof JDFRunList ? ((JDFRunList)r).getLayoutElement() : null;
                    if (loe != null) {
                        r.moveElements(loe.getChildElementVector_KElement(null, null, null, true, 0), null);
                        r.setAttributes(loe);
                        loe.deleteNode();
                    }
                    r.renameElement("LayoutElement", null);
                }
            }
        }
    }
}

