/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.jmf;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoJobPhase;
import org.cip4.jdflib.auto.JDFAutoQueueEntry;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.ifaces.INodeIdentifiable;
import org.cip4.jdflib.jmf.JDFDeviceInfo;
import org.cip4.jdflib.jmf.JDFMessage;
import org.cip4.jdflib.jmf.JDFSignal;
import org.cip4.jdflib.jmf.JDFStatusQuParams;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.node.NodeIdentifier;
import org.cip4.jdflib.resource.JDFModulePhase;
import org.cip4.jdflib.resource.JDFModuleStatus;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.StringUtil;

public class JDFJobPhase
extends JDFAutoJobPhase
implements INodeIdentifiable {
    private static final long serialVersionUID = 1L;
    private static ElemInfoTable[] elemInfoTable = new ElemInfoTable[1];

    public JDFJobPhase(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFJobPhase(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFJobPhase(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFJobPhase[  --> " + super.toString() + " ]";
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return new ElementInfo(super.getTheElementInfo(), elemInfoTable);
    }

    @Override
    public String getStatusDetails() {
        return this.getAttribute("StatusDetails");
    }

    @Override
    public String getQueueEntryID() {
        return this.getInheritedStatusQuParamsAttribute("QueueEntryID", null);
    }

    @Override
    public String getJobID() {
        return this.getInheritedStatusQuParamsAttribute("JobID", null);
    }

    @Override
    public String getJobPartID() {
        return this.getInheritedStatusQuParamsAttribute("JobPartID", null);
    }

    @Override
    public VJDFAttributeMap getPartMapVector() {
        return super.getPartMapVector();
    }

    @Override
    public void setPartMapVector(VJDFAttributeMap vParts) {
        super.setPartMapVector(vParts);
    }

    @Override
    public void setPartMap(JDFAttributeMap mPart) {
        super.setPartMap(mPart);
    }

    @Override
    public void removePartMap(JDFAttributeMap mPart) {
        super.removePartMap(mPart);
    }

    @Override
    public boolean hasPartMap(JDFAttributeMap mPart) {
        return super.hasPartMap(mPart);
    }

    public JDFNode getCreateNode() {
        return (JDFNode)this.getCreateElement_KElement("JDF", null, 0);
    }

    public JDFNode appendNode() {
        return (JDFNode)this.appendElementN("JDF", 1, null);
    }

    public void applyNode(JDFNode node) {
        NodeIdentifier ni = node == null ? new NodeIdentifier() : node.getIdentifier();
        this.setIdentifier(ni);
        if (node != null) {
            JDFNode.EnumActivation activation = node.getActivation(true);
            if (activation != null) {
                this.setActivation(JDFAutoJobPhase.EnumActivation.getEnum(activation.getName()));
            }
            VJDFAttributeMap vMap = ni.getPartMapVector();
            this.setStatus(node.getVectorPartStatus(vMap));
            this.setStatusDetails(node.getVectorPartStatusDetails(vMap));
        }
    }

    public JDFNode getNode() {
        return (JDFNode)this.getElement("JDF", null, 0);
    }

    public JDFStatusQuParams getStatusQuParams() {
        KElement parent = this.getParentNode_KElement();
        if (!(parent instanceof JDFDeviceInfo)) {
            return null;
        }
        if (!((parent = parent.getParentNode_KElement()) instanceof JDFSignal) || !JDFMessage.EnumType.Status.equals((Object)((JDFMessage)parent).getEnumType())) {
            return null;
        }
        return ((JDFMessage)parent).getStatusQuParams();
    }

    @Override
    public NodeIdentifier getIdentifier() {
        NodeIdentifier ni = new NodeIdentifier();
        ni.setTo(this.getJobID(), this.getJobPartID(), this.getPartMapVector());
        return ni;
    }

    @Override
    public void setIdentifier(NodeIdentifier ni) {
        if (ni == null) {
            ni = new NodeIdentifier();
        }
        this.setJobID(ni.getJobID());
        this.setJobPartID(ni.getJobPartID());
        this.setPartMapVector(ni.getPartMapVector());
    }

    private String getInheritedStatusQuParamsAttribute(String key, String nameSpaceURI) {
        String val = this.getAttribute(key, nameSpaceURI, null);
        if (val != null) {
            return val;
        }
        JDFStatusQuParams sqp = this.getStatusQuParams();
        if (sqp == null) {
            return null;
        }
        return sqp.getAttribute(key, nameSpaceURI, null);
    }

    public JDFModuleStatus createModuleStatusFromModulePhase(JDFModulePhase mp) {
        if (mp == null) {
            return null;
        }
        JDFModuleStatus ms = this.appendModuleStatus();
        ms.copyAttribute("ModuleType", mp);
        ms.copyAttribute("ModuleIndex", mp);
        ms.copyAttribute("ModuleID", mp);
        return ms;
    }

    public double getAmountDifference(JDFJobPhase lastphase) {
        if (this.isSamePhase(lastphase, true)) {
            return this.getPhaseAmount() - lastphase.getPhaseAmount();
        }
        return this.getPhaseAmount();
    }

    public double getWasteDifference(JDFJobPhase lastphase) {
        if (this.isSamePhase(lastphase, true)) {
            return this.getPhaseWaste() - lastphase.getPhaseWaste();
        }
        return this.getPhaseWaste();
    }

    public boolean isSamePhase(JDFJobPhase lastphase, boolean bExact) {
        if (lastphase == null) {
            return false;
        }
        if (bExact) {
            JDFDate startTime = this.getPhaseStartTime();
            JDFDate lastStartTime = lastphase.getPhaseStartTime();
            return startTime != null && startTime.equals(lastStartTime);
        }
        if (!ContainerUtil.equals((Object)this.getStatus(), (Object)lastphase.getStatus())) {
            return false;
        }
        if (!ContainerUtil.equals(StringUtil.getNonEmpty(this.getStatusDetails()), StringUtil.getNonEmpty(lastphase.getStatusDetails()))) {
            return false;
        }
        if (!ContainerUtil.equals(StringUtil.getNonEmpty(this.getDescriptiveName()), StringUtil.getNonEmpty(lastphase.getDescriptiveName()))) {
            return false;
        }
        if (!ContainerUtil.equals(this.getIdentifier(), lastphase.getIdentifier())) {
            return false;
        }
        if (!ContainerUtil.matches(this.getCostCenter(), lastphase.getCostCenter())) {
            return false;
        }
        return ContainerUtil.equals(this.getMISDetails(), lastphase.getMISDetails());
    }

    public boolean mergeLastPhase(JDFJobPhase lastphase) {
        if (!this.isSamePhase(lastphase, false)) {
            return false;
        }
        JDFDate startTime = lastphase.getPhaseStartTime();
        if (!ContainerUtil.equals(this.getPhaseStartTime(), startTime)) {
            double waste;
            this.setPhaseStartTime(startTime);
            double amount = this.getPhaseAmount() + lastphase.getPhaseAmount();
            if (amount != 0.0) {
                this.setPhaseAmount(amount);
            }
            if ((waste = this.getPhaseWaste() + lastphase.getPhaseWaste()) != 0.0) {
                this.setPhaseWaste(waste);
            }
        }
        return true;
    }

    @Override
    public double getPhaseAmount() {
        if (this.hasAttribute("PhaseAmount")) {
            return super.getPhaseAmount();
        }
        return super.getAmount();
    }

    @Override
    public JDFDate getPhaseStartTime() {
        if (this.hasAttribute("PhaseStartTime")) {
            return super.getPhaseStartTime();
        }
        return super.getStartTime();
    }

    @Override
    public double getPhaseWaste() {
        if (this.hasAttribute("PhaseWaste")) {
            return super.getPhaseWaste();
        }
        return super.getWaste();
    }

    public JDFAutoQueueEntry.EnumQueueEntryStatus getQueueEntryStatus() {
        return JDFElement.EnumNodeStatus.getQueueEntryStatus(this.getStatus());
    }

    static {
        JDFJobPhase.elemInfoTable[0] = new ElemInfoTable("JDF", 0x33333333L);
    }
}

