/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.jmf;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoPipeParams;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.JDFResource;

public class JDFPipeParams
extends JDFAutoPipeParams {
    private static final long serialVersionUID = 1L;

    public JDFPipeParams(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFPipeParams(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFPipeParams(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFPipeParams[  --> " + super.toString() + " ]";
    }

    @Deprecated
    public final VElement getResourceLinks(String nam, JDFAttributeMap mAttrib, String nameSpaceURI) {
        VElement v = this.getChildElementVector(nam, nameSpaceURI, mAttrib, true, 0, false);
        for (int i = v.size() - 1; i >= 0; --i) {
            JDFElement e = (JDFElement)v.elementAt(i);
            if (e instanceof JDFResourceLink) continue;
            v.remove(i);
        }
        return v;
    }

    public final JDFResourceLink getResourceLink() {
        VElement v = this.getChildElementVector(null, null, null, true, 0, false);
        for (int i = 0; i < v.size(); ++i) {
            KElement e = v.item(i);
            if (!(e instanceof JDFResourceLink)) continue;
            return (JDFResourceLink)e;
        }
        return null;
    }

    @Override
    public VString getUnknownElements(boolean bIgnorePrivate, int nMax) {
        boolean bIgnorePrivateLocal = bIgnorePrivate;
        if (bIgnorePrivateLocal) {
            bIgnorePrivateLocal = false;
        }
        return this.getUnknownPoolElements(JDFElement.EnumPoolType.PipeParams, nMax);
    }

    public JDFResource getCreateResource(String resName) {
        JDFResource r = null;
        KElement e = this.getCreateElement(resName, null, 0);
        if (!(e instanceof JDFResource)) {
            throw new JDFException("JDFPipeParams.getCreateResource tried to create a JDFElement instead of a JDFResource");
        }
        return r;
    }

    public JDFResource getResource(String resName) {
        if (resName == null) {
            JDFResource target;
            JDFResourceLink rl = this.getResourceLink();
            if (rl != null && (target = rl.getTarget()) != null) {
                return target;
            }
            VElement v = this.getChildElementVector(null, null, null, true, 0, false);
            for (int i = 0; i < v.size(); ++i) {
                KElement e = v.item(i);
                if (!(e instanceof JDFResource)) continue;
                return (JDFResource)e;
            }
            return null;
        }
        JDFResource r = null;
        KElement e = this.getElement(resName, null, 0);
        if (!(e instanceof JDFResource)) {
            throw new JDFException("JDFPipeParams.getResource tried to return a JDFElement instead of a JDFResource");
        }
        r = (JDFResource)e;
        return r;
    }

    public JDFResource appendResource(String resName) {
        KElement e = this.appendElement(resName, null);
        if (!(e instanceof JDFResource)) {
            throw new JDFException("JDFpipeParams.appendResource tried to return a JDFElement instead of a JDFResource: " + resName);
        }
        return (JDFResource)e;
    }

    public JDFResourceLink appendResourceLink(String linkName, boolean bInput) {
        String linkNameLocal = linkName;
        if (!linkNameLocal.endsWith("Link")) {
            linkNameLocal = linkNameLocal + "Link";
        }
        JDFResourceLink rl = null;
        if (this.getResourceLink() != null) {
            throw new JDFException("JDFpipeParams.appendResourceLink tried to append an additional link");
        }
        KElement e = this.appendElement(linkNameLocal, null);
        if (!(e instanceof JDFResourceLink)) {
            throw new JDFException("JDFpipeParams.appendResourceLink tried to return a JDFElement instead of a JDFResourceLink: " + linkNameLocal);
        }
        rl = (JDFResourceLink)e;
        rl.setUsage(bInput ? JDFResourceLink.EnumUsage.Input : JDFResourceLink.EnumUsage.Output);
        return rl;
    }

    public void applyPipeToNode(JDFNode parentNode) {
        if (parentNode == null) {
            return;
        }
        VElement vNodes = parentNode.getvJDFNode(null, null, false);
        int size = vNodes.size();
        for (int i = 0; i < size; ++i) {
            JDFNode node = (JDFNode)vNodes.elementAt(i);
            if (!this.matchesNode(node)) continue;
            double dAmount = -1.0;
            JDFResourceLink rl = this.getResourceLink();
            if (rl == null) continue;
            JDFResourceLink rlNode = node.getLink(0, rl.getNodeName(), new JDFAttributeMap("rRef", rl.getrRef()), null);
            if (rlNode == null) {
                throw new JDFException("Applying pipeparams to inconsistent node: missing resourcelink: " + rl.getNodeName());
            }
            VJDFAttributeMap vMap = rl.getPartMapVector();
            if (vMap == null) {
                vMap = new VJDFAttributeMap();
                vMap.add(null);
            }
            for (int j = 0; j < vMap.size(); ++j) {
                JDFAttributeMap map = vMap.elementAt(j);
                dAmount = rl.getActualAmount(map);
                rlNode.setActualAmount(dAmount, map);
            }
        }
    }

    private boolean matchesNode(JDFNode node) {
        if (node == null) {
            return false;
        }
        if (this.hasAttribute("JobID") && !this.getJobID().equals(node.getJobID(true))) {
            return false;
        }
        return !this.hasAttribute("JobPartID") || this.getJobPartID().equals(node.getJobPartID(false));
    }
}

