/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.jmf;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoQueueEntry;
import org.cip4.jdflib.core.JDFNodeInfo;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.ifaces.INodeIdentifiable;
import org.cip4.jdflib.jmf.JDFJobPhase;
import org.cip4.jdflib.jmf.JDFQueue;
import org.cip4.jdflib.jmf.JDFQueueFilter;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.node.NodeIdentifier;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.MyInteger;
import org.cip4.jdflib.util.StringUtil;

public class JDFQueueEntry
extends JDFAutoQueueEntry
implements Comparable<KElement>,
INodeIdentifiable {
    private static final long serialVersionUID = 1L;

    public JDFQueueEntry(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFQueueEntry(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFQueueEntry(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFQueueEntry[  --> " + super.toString() + " ]";
    }

    @Override
    public VJDFAttributeMap getPartMapVector() {
        return super.getPartMapVector();
    }

    @Override
    public void setPartMapVector(VJDFAttributeMap vParts) {
        super.setPartMapVector(vParts);
    }

    @Override
    public void setPartMap(JDFAttributeMap mPart) {
        super.setPartMap(mPart);
    }

    @Override
    public void removePartMap(JDFAttributeMap mPart) {
        super.removePartMap(mPart);
    }

    public boolean matchesNodeIdentifier(NodeIdentifier ni) {
        if (ni == null) {
            return false;
        }
        NodeIdentifier niThis = this.getIdentifier();
        return niThis.matches(ni);
    }

    @Deprecated
    public boolean matchesQueueFilter(JDFQueueFilter filter) {
        if (filter == null) {
            return true;
        }
        return filter.matches(this);
    }

    @Override
    public boolean hasPartMap(JDFAttributeMap mPart) {
        return super.hasPartMap(mPart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPriority(int value) {
        int oldVal;
        int n = oldVal = this.hasAttribute("Priority") ? this.getPriority() : -1;
        if (this.isAutomated() && value != oldVal) {
            JDFQueue queue;
            JDFQueue jDFQueue = queue = (JDFQueue)this.getParentNode_KElement();
            synchronized (jDFQueue) {
                super.setPriority(value);
                queue.sortChild(this);
            }
        } else if (value != oldVal) {
            super.setPriority(value);
        }
    }

    @Deprecated
    public void sortQueue(int oldVal) {
        JDFQueue queue = (JDFQueue)this.getParentNode_KElement();
        queue.sortChildren();
    }

    private boolean isAutomated() {
        KElement e = this.getParentNode_KElement();
        if (e instanceof JDFQueue) {
            return ((JDFQueue)e).isAutomated();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setQueueEntryStatus(JDFAutoQueueEntry.EnumQueueEntryStatus value) {
        JDFAutoQueueEntry.EnumQueueEntryStatus oldVal = this.getQueueEntryStatus();
        if (this.isAutomated() && !ContainerUtil.equals((Object)oldVal, (Object)value)) {
            JDFQueue queue;
            JDFQueue jDFQueue = queue = (JDFQueue)this.getParentNode_KElement();
            synchronized (jDFQueue) {
                super.setQueueEntryStatus(value);
                if (this.isCompleted()) {
                    if (!this.hasAttribute("EndTime")) {
                        super.setEndTime(new JDFDate());
                    }
                    queue.cleanup();
                } else if (JDFAutoQueueEntry.EnumQueueEntryStatus.Running.equals((Object)value)) {
                    if (!this.hasAttribute("StartTime")) {
                        super.setStartTime(new JDFDate());
                    }
                    this.removeAttribute("EndTime");
                } else if (JDFAutoQueueEntry.EnumQueueEntryStatus.Suspended.equals((Object)value) && !this.hasAttribute("EndTime")) {
                    super.setEndTime(new JDFDate());
                }
                if (!JDFAutoQueueEntry.EnumQueueEntryStatus.Removed.equals((Object)value) && queue.equals(this.getParentNode_KElement())) {
                    queue.sortChild(this);
                }
                queue.setStatusFromEntries();
            }
        } else if (!ContainerUtil.equals((Object)oldVal, (Object)value)) {
            super.setQueueEntryStatus(value);
        }
    }

    @Override
    public NodeIdentifier getIdentifier() {
        NodeIdentifier ni = new NodeIdentifier();
        ni.setTo(this.getJobID(), this.getJobPartID(), this.getPartMapVector());
        return ni;
    }

    @Override
    public void setIdentifier(NodeIdentifier ni) {
        if (ni == null) {
            return;
        }
        this.setPartMapVector(ni.getPartMapVector());
        this.setJobID(ni.getJobID());
        this.setJobPartID(ni.getJobPartID());
    }

    public JDFQueueEntry getNextQueueEntry() {
        return this.getNextSiblingElement(JDFQueueEntry.class);
    }

    public JDFQueueEntry getPreviousQueueEntry() {
        return (JDFQueueEntry)this.getPreviousSiblingElement("QueueEntry", null);
    }

    public Vector<JDFAutoQueueEntry.EnumQueueEntryStatus> getNextStatusVector() {
        Vector<JDFAutoQueueEntry.EnumQueueEntryStatus> v = new Vector<JDFAutoQueueEntry.EnumQueueEntryStatus>();
        JDFAutoQueueEntry.EnumQueueEntryStatus qesThis = this.getQueueEntryStatus();
        if (qesThis == null) {
            Iterator it = JDFAutoQueueEntry.EnumQueueEntryStatus.iterator();
            while (it.hasNext()) {
                v.add((JDFAutoQueueEntry.EnumQueueEntryStatus)((Object)it.next()));
            }
        } else if (JDFAutoQueueEntry.EnumQueueEntryStatus.Running.equals((Object)qesThis)) {
            v.add(JDFAutoQueueEntry.EnumQueueEntryStatus.Running);
            v.add(JDFAutoQueueEntry.EnumQueueEntryStatus.Suspended);
            v.add(JDFAutoQueueEntry.EnumQueueEntryStatus.PendingReturn);
            v.add(JDFAutoQueueEntry.EnumQueueEntryStatus.Completed);
            v.add(JDFAutoQueueEntry.EnumQueueEntryStatus.Aborted);
        } else if (JDFAutoQueueEntry.EnumQueueEntryStatus.Waiting.equals((Object)qesThis)) {
            v.add(JDFAutoQueueEntry.EnumQueueEntryStatus.Running);
            v.add(JDFAutoQueueEntry.EnumQueueEntryStatus.Waiting);
            v.add(JDFAutoQueueEntry.EnumQueueEntryStatus.Held);
            v.add(JDFAutoQueueEntry.EnumQueueEntryStatus.Removed);
            v.add(JDFAutoQueueEntry.EnumQueueEntryStatus.PendingReturn);
            v.add(JDFAutoQueueEntry.EnumQueueEntryStatus.Aborted);
        } else if (JDFAutoQueueEntry.EnumQueueEntryStatus.Held.equals((Object)qesThis)) {
            v.add(JDFAutoQueueEntry.EnumQueueEntryStatus.Waiting);
            v.add(JDFAutoQueueEntry.EnumQueueEntryStatus.Held);
            v.add(JDFAutoQueueEntry.EnumQueueEntryStatus.Removed);
            v.add(JDFAutoQueueEntry.EnumQueueEntryStatus.PendingReturn);
            v.add(JDFAutoQueueEntry.EnumQueueEntryStatus.Aborted);
        } else if (JDFAutoQueueEntry.EnumQueueEntryStatus.Removed.equals((Object)qesThis)) {
            v.add(JDFAutoQueueEntry.EnumQueueEntryStatus.Removed);
        } else if (JDFAutoQueueEntry.EnumQueueEntryStatus.Suspended.equals((Object)qesThis)) {
            v.add(JDFAutoQueueEntry.EnumQueueEntryStatus.Waiting);
            v.add(JDFAutoQueueEntry.EnumQueueEntryStatus.Running);
            v.add(JDFAutoQueueEntry.EnumQueueEntryStatus.Suspended);
            v.add(JDFAutoQueueEntry.EnumQueueEntryStatus.Completed);
            v.add(JDFAutoQueueEntry.EnumQueueEntryStatus.Aborted);
        } else if (JDFAutoQueueEntry.EnumQueueEntryStatus.PendingReturn.equals((Object)qesThis)) {
            v.add(JDFAutoQueueEntry.EnumQueueEntryStatus.PendingReturn);
            v.add(JDFAutoQueueEntry.EnumQueueEntryStatus.Completed);
            v.add(JDFAutoQueueEntry.EnumQueueEntryStatus.Aborted);
        } else if (JDFAutoQueueEntry.EnumQueueEntryStatus.Completed.equals((Object)qesThis)) {
            v.add(JDFAutoQueueEntry.EnumQueueEntryStatus.Waiting);
            v.add(JDFAutoQueueEntry.EnumQueueEntryStatus.Removed);
            v.add(JDFAutoQueueEntry.EnumQueueEntryStatus.PendingReturn);
            v.add(JDFAutoQueueEntry.EnumQueueEntryStatus.Completed);
            v.add(JDFAutoQueueEntry.EnumQueueEntryStatus.Aborted);
        } else if (JDFAutoQueueEntry.EnumQueueEntryStatus.Aborted.equals((Object)qesThis)) {
            v.add(JDFAutoQueueEntry.EnumQueueEntryStatus.Waiting);
            v.add(JDFAutoQueueEntry.EnumQueueEntryStatus.Removed);
            v.add(JDFAutoQueueEntry.EnumQueueEntryStatus.PendingReturn);
            v.add(JDFAutoQueueEntry.EnumQueueEntryStatus.Aborted);
        }
        return v;
    }

    public boolean isCompleted() {
        String status = this.getAttribute("Status", null, null);
        return "Completed".equals(status) || "Removed".equals(status) || "Aborted".equals(status);
    }

    @Deprecated
    public int getSortPriority() {
        return JDFQueueEntry.getSortPriority(this.getQueueEntryStatus(), this.getPriority());
    }

    @Deprecated
    public JDFJobPhase getJobPhase() {
        return this.getJobPhase(0);
    }

    @Deprecated
    public JDFJobPhase getCreateJobPhase() {
        return this.getCreateJobPhase(0);
    }

    @Deprecated
    public static int getSortPriority(JDFAutoQueueEntry.EnumQueueEntryStatus status, int priority) {
        int sort = status == null ? 0 : 10000 - 1000 * status.getValue();
        return sort += priority;
    }

    public void setFromJDF(JDFNode jdf) {
        JDFNodeInfo ni;
        if (jdf == null) {
            return;
        }
        this.setJobID(jdf.getJobID(true));
        this.setJobPartID(jdf.getJobPartID(false));
        this.setPartMapVector(jdf.getPartMapVector());
        if (!this.hasAttribute("DescriptiveName")) {
            this.setDescriptiveName(StringUtil.getNonEmpty(jdf.getDescriptiveName()));
        }
        if (!this.hasAttribute("Priority") && (ni = jdf.getInheritedNodeInfo("@Priority")) != null) {
            this.copyAttribute("Priority", ni, null, null, null);
        }
        this.eraseEmptyAttributes(true);
    }

    @Override
    public int compareTo(KElement arg0) {
        return new QueueEntryComparator().compare(this, arg0);
    }

    @Override
    public void setEndTime(JDFDate value) {
        this.setSortDate("EndTime", value == null ? null : value.getDateTimeISO());
    }

    @Override
    public void setStartTime(JDFDate value) {
        this.setSortDate("StartTime", value == null ? null : value.getDateTimeISO());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSortDate(String attName, String value) {
        if (value == null) {
            value = new JDFDate().getDateTimeISO();
        }
        String oldVal = this.getAttribute(attName, null, null);
        if (this.isAutomated() && !ContainerUtil.equals(oldVal, value)) {
            JDFQueue queue;
            JDFQueue jDFQueue = queue = (JDFQueue)this.getParentNode_KElement();
            synchronized (jDFQueue) {
                super.setAttribute(attName, value);
                queue.sortChild(this);
            }
        } else if (!ContainerUtil.equals(oldVal, value)) {
            super.setAttribute(attName, value);
        }
    }

    @Override
    public void setSubmissionTime(JDFDate value) {
        this.setSortDate("SubmissionTime", value == null ? null : value.getDateTimeISO());
    }

    public static class QueueEntryComparator
    implements Comparator<KElement> {
        private static HashMap<String, MyInteger> fastStat = null;

        public QueueEntryComparator() {
            if (fastStat == null) {
                fastStat = new HashMap();
                Iterator it = JDFAutoQueueEntry.EnumQueueEntryStatus.iterator();
                while (it.hasNext()) {
                    JDFAutoQueueEntry.EnumQueueEntryStatus eqs = (JDFAutoQueueEntry.EnumQueueEntryStatus)((Object)it.next());
                    fastStat.put(eqs.getName(), new MyInteger(eqs.getValue()));
                }
            }
        }

        @Override
        public int compare(KElement o1, KElement o2) {
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            int i = o1.getNodeName().compareTo(o2.getNodeName());
            if (i != 0) {
                return i;
            }
            if (o1 instanceof JDFQueueEntry && o2 instanceof JDFQueueEntry) {
                int d;
                String d2;
                String d1;
                int s2;
                JDFQueueEntry q1 = (JDFQueueEntry)o1;
                JDFQueueEntry q2 = (JDFQueueEntry)o2;
                MyInteger m1 = fastStat.get(q1.getAttribute("Status", null, null));
                MyInteger m2 = fastStat.get(q2.getAttribute("Status", null, null));
                int s1 = m1 == null ? 0 : m1.i;
                int n = s2 = m2 == null ? 0 : m2.i;
                if (s1 != s2) {
                    return s1 - s2;
                }
                if (q1.isCompleted()) {
                    d1 = q1.getAttribute("EndTime", null, null);
                    d2 = q2.getAttribute("EndTime", null, null);
                    if (d1 != null && d2 != null) {
                        return d2.compareTo(d1);
                    }
                } else {
                    s1 = q1.getPriority();
                    if (s1 != (s2 = q2.getPriority())) {
                        return s2 - s1;
                    }
                }
                if ((d = ContainerUtil.compare((Comparable)((Object)(d1 = q1.getAttribute("StartTime", null, null))), (Comparable)((Object)(d2 = q2.getAttribute("StartTime", null, null))))) != 0) {
                    return d;
                }
                d1 = q1.getAttribute("SubmissionTime", null, null);
                d = ContainerUtil.compare((Comparable)((Object)d1), (Comparable)((Object)(d2 = q2.getAttribute("SubmissionTime", null, null))));
                if (d != 0) {
                    return d;
                }
            }
            return 0;
        }
    }
}

