/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource;

import java.util.HashSet;
import java.util.Iterator;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoPart;
import org.cip4.jdflib.core.AtrInfo;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.util.StringUtil;

public class JDFPart
extends JDFAutoPart {
    private static final long serialVersionUID = 1L;
    private static HashSet<String> tokensSet = null;
    private static HashSet<String> irlSet = null;

    public JDFPart(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFPart(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFPart(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFPart[  --> " + super.toString() + " ]";
    }

    @Override
    public JDFAttributeMap getPartMap() {
        JDFAttributeMap am = this.getAttributeMap();
        Iterator<String> it = am.getKeyIterator();
        JDFAttributeMap retMap = new JDFAttributeMap();
        while (it.hasNext()) {
            String key = it.next();
            if (JDFResource.EnumPartIDKey.getEnum(key) == null) continue;
            retMap.put(key, am.get(key));
        }
        return retMap;
    }

    public VString guessPartIDKeys() {
        JDFAttributeMap map = this.getPartMap();
        if (map == null || map.size() == 0) {
            return null;
        }
        VString v = new VString();
        VString keys = map.getKeys();
        if (map.size() == 1) {
            return map.getKeys();
        }
        if (keys.contains("SignatureName")) {
            v.add("SignatureName");
            keys.remove("SignatureName");
        }
        if (keys.contains("SheetName")) {
            v.add("SheetName");
            keys.remove("SheetName");
        }
        if (keys.contains("Side")) {
            v.add("Side");
            keys.remove("Side");
        }
        if (keys.contains("Separation")) {
            v.add("Separation");
            keys.remove("Separation");
        }
        v.addAll(keys);
        return v;
    }

    @Override
    public void setPartMap(JDFAttributeMap mPart) {
        this.removeAttributes(null);
        this.setAttributes(mPart);
    }

    @Deprecated
    public static boolean matchesPart(String key, String resourceValue, String linkValue) {
        return JDFPart.matchesPart(key, resourceValue, linkValue, false);
    }

    public static boolean matchesPart(String key, String resourceValue, String linkValue, boolean strictPartVersion) {
        boolean b;
        if (resourceValue.equals(linkValue)) {
            return true;
        }
        if (tokensSet == null) {
            tokensSet = new HashSet();
            tokensSet.add(JDFResource.EnumPartIDKey.DocTags.getName());
            tokensSet.add(JDFResource.EnumPartIDKey.ItemNames.getName());
            tokensSet.add(JDFResource.EnumPartIDKey.PageTags.getName());
            tokensSet.add(JDFResource.EnumPartIDKey.RunTags.getName());
            tokensSet.add(JDFResource.EnumPartIDKey.SetTags.getName());
        }
        if (irlSet == null) {
            irlSet = new HashSet();
            irlSet.add(JDFResource.EnumPartIDKey.DocCopies.getName());
            irlSet.add(JDFResource.EnumPartIDKey.DocIndex.getName());
            irlSet.add(JDFResource.EnumPartIDKey.DocRunIndex.getName());
            irlSet.add(JDFResource.EnumPartIDKey.DocSheetIndex.getName());
            irlSet.add(JDFResource.EnumPartIDKey.LayerIDs.getName());
            irlSet.add(JDFResource.EnumPartIDKey.PageNumber.getName());
            irlSet.add(JDFResource.EnumPartIDKey.RunIndex.getName());
            irlSet.add(JDFResource.EnumPartIDKey.SectionIndex.getName());
            irlSet.add(JDFResource.EnumPartIDKey.SetIndex.getName());
            irlSet.add(JDFResource.EnumPartIDKey.SetRunIndex.getName());
            irlSet.add(JDFResource.EnumPartIDKey.SetSheetIndex.getName());
            irlSet.add(JDFResource.EnumPartIDKey.SheetIndex.getName());
        }
        if (tokensSet.contains(key)) {
            b = AtrInfo.matchesAttribute(linkValue, resourceValue, AttributeInfo.EnumAttributeType.NMTOKENS);
        } else if (irlSet.contains(key)) {
            b = AtrInfo.matchesAttribute(linkValue, resourceValue, AttributeInfo.EnumAttributeType.IntegerRangeList);
        } else if (!strictPartVersion && "PartVersion".equals(key)) {
            VString resTokens = StringUtil.tokenize(resourceValue, null, false);
            VString linkTokens = StringUtil.tokenize(linkValue, null, false);
            b = resTokens.size() == linkTokens.size() ? resourceValue.equals(linkValue) : (resTokens.size() == 1 ? AtrInfo.matchesAttribute(resourceValue, linkValue, AttributeInfo.EnumAttributeType.NMTOKENS) : (linkTokens.size() == 1 ? AtrInfo.matchesAttribute(linkValue, resourceValue, AttributeInfo.EnumAttributeType.NMTOKENS) : false));
        } else {
            b = false;
        }
        return b;
    }

    @Deprecated
    public static boolean overlapPartMap(JDFAttributeMap resourceMap, JDFAttributeMap linkMap) {
        return JDFPart.overlapPartMap(resourceMap, linkMap, false);
    }

    public static boolean overlapPartMap(JDFAttributeMap resourceMap, JDFAttributeMap linkMap, boolean strictPartVersion) {
        if (resourceMap == null || linkMap == null) {
            return true;
        }
        for (String key : linkMap.keySet()) {
            String linkVal;
            String resVal = resourceMap.get(key);
            if (resVal == null || JDFPart.matchesPart(key, resVal, linkVal = linkMap.get(key), strictPartVersion)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        AttributeInfo ai = AttributeInfo.fixedMap.get("JDFPart");
        if (ai != null) {
            return ai;
        }
        ai = super.getTheAttributeInfo();
        AttributeInfo.fixedMap.put("JDFPart", ai);
        return ai;
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        ElementInfo ai = ElementInfo.fixedMap.get("JDFPart");
        if (ai != null) {
            return ai;
        }
        ai = super.getTheElementInfo();
        ElementInfo.fixedMap.put("JDFPart", ai);
        return ai;
    }
}

