/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.intent;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.core.JDFComment;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.span.JDFDurationSpan;
import org.cip4.jdflib.span.JDFEnumerationSpan;
import org.cip4.jdflib.span.JDFIntegerSpan;
import org.cip4.jdflib.span.JDFNameSpan;
import org.cip4.jdflib.span.JDFNumberSpan;
import org.cip4.jdflib.span.JDFOptionSpan;
import org.cip4.jdflib.span.JDFShapeSpan;
import org.cip4.jdflib.span.JDFSpanBase;
import org.cip4.jdflib.span.JDFStringSpan;
import org.cip4.jdflib.span.JDFTimeSpan;
import org.cip4.jdflib.span.JDFXYPairSpan;
import org.cip4.jdflib.util.StringUtil;
import org.w3c.dom.DOMException;

public class JDFIntentResource
extends JDFResource {
    private static final long serialVersionUID = 1L;

    public JDFIntentResource(CoreDocumentImpl myOwnerDocument, String qualifiedName) throws DOMException {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFIntentResource(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFIntentResource(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFIntent[  --> " + super.toString() + " ]";
    }

    public static String guessActual(JDFElement root, String spanName) {
        if (root == null) {
            return null;
        }
        KElement span = root.getElement(spanName);
        if (span instanceof JDFSpanBase) {
            return ((JDFSpanBase)span).guessActual();
        }
        return null;
    }

    public static void copyActualToProcess(JDFElement intentRoot, JDFElement processRoot, String spanName, String attName) {
        if (intentRoot == null || processRoot == null) {
            return;
        }
        String val = JDFIntentResource.guessActual(intentRoot, spanName);
        if (val == null) {
            return;
        }
        if (StringUtil.getNonEmpty(attName) == null) {
            attName = spanName;
        }
        processRoot.setAttribute(attName, val);
    }

    public int preferredToActual() {
        return this.preferredToActual(null);
    }

    public int preferredToActual(String key) {
        int nDone = 0;
        if (!this.isLeaf()) {
            VElement leaves = this.getLeaves(false);
            for (int i = 0; i < leaves.size(); ++i) {
                JDFIntentResource ri = (JDFIntentResource)leaves.elementAt(i);
                nDone += ri.preferredToActual(key);
            }
            return nDone;
        }
        VString vKeys = new VString();
        if (KElement.isWildCard(key)) {
            VElement v = this.getChildrenByTagName(null, null, new JDFAttributeMap("DataType", (String)null), true, true, 0);
            for (int i = 0; i < v.size(); ++i) {
                vKeys.add(v.elementAt(i).getNodeName());
            }
        } else {
            vKeys.add(key);
        }
        for (int i = 0; i < vKeys.size(); ++i) {
            JDFSpanBase base = (JDFSpanBase)this.getElement(vKeys.elementAt(i), null, 0);
            if (!base.preferredToActual()) continue;
            ++nDone;
        }
        return nDone;
    }

    public VElement getSpans() {
        VElement v = this.getChildElementVector(null, null, null, true, 0, false);
        for (int i = v.size() - 1; i >= 0; --i) {
            JDFElement e = (JDFElement)v.elementAt(i);
            if (!(e instanceof JDFComment)) continue;
            v.remove(i);
        }
        return v;
    }

    @Override
    public JDFResource.EnumResourceClass getValidClass() {
        return JDFResource.EnumResourceClass.Intent;
    }

    @Override
    public boolean init() {
        boolean b = super.init();
        this.setResourceClass(JDFResource.EnumResourceClass.Intent);
        return b;
    }

    public JDFNumberSpan getCreateNumberSpan(String strName) {
        return (JDFNumberSpan)this.getCreateSpan(strName, JDFSpanBase.EnumDataType.NumberSpan);
    }

    public JDFOptionSpan getCreateOptionSpan(String strName) {
        return (JDFOptionSpan)this.getCreateSpan(strName, JDFSpanBase.EnumDataType.OptionSpan);
    }

    public JDFIntegerSpan getCreateIntegerSpan(String strName) {
        return (JDFIntegerSpan)this.getCreateSpan(strName, JDFSpanBase.EnumDataType.IntegerSpan);
    }

    public JDFNameSpan getCreateNameSpan(String strName) {
        return (JDFNameSpan)this.getCreateSpan(strName, JDFSpanBase.EnumDataType.NameSpan);
    }

    public JDFEnumerationSpan getCreateEnumerationSpan(String strName) {
        return (JDFEnumerationSpan)this.getCreateSpan(strName, JDFSpanBase.EnumDataType.EnumerationSpan);
    }

    public JDFStringSpan getCreateStringSpan(String strName) {
        return (JDFStringSpan)this.getCreateSpan(strName, JDFSpanBase.EnumDataType.StringSpan);
    }

    public JDFDurationSpan getCreateDurationSpan(String strName) {
        return (JDFDurationSpan)this.getCreateSpan(strName, JDFSpanBase.EnumDataType.DurationSpan);
    }

    public JDFTimeSpan getCreateTimeSpan(String strName) {
        return (JDFTimeSpan)this.getCreateSpan(strName, JDFSpanBase.EnumDataType.TimeSpan);
    }

    public JDFXYPairSpan getCreateCreateXYPairSpan(String strName) {
        return (JDFXYPairSpan)this.getCreateSpan(strName, JDFSpanBase.EnumDataType.XYPairSpan);
    }

    public JDFShapeSpan getCreateCreateShapeSpan(String strName) {
        return (JDFShapeSpan)this.getCreateSpan(strName, JDFSpanBase.EnumDataType.ShapeSpan);
    }

    public JDFNumberSpan getNumberSpan(String strName) {
        return (JDFNumberSpan)this.getSpan(strName, JDFSpanBase.EnumDataType.NumberSpan);
    }

    public JDFOptionSpan getOptionSpan(String strName) {
        return (JDFOptionSpan)this.getSpan(strName, JDFSpanBase.EnumDataType.OptionSpan);
    }

    public JDFIntegerSpan getIntegerSpan(String strName) {
        return (JDFIntegerSpan)this.getSpan(strName, JDFSpanBase.EnumDataType.IntegerSpan);
    }

    public JDFNameSpan getNameSpan(String strName) {
        return (JDFNameSpan)this.getSpan(strName, JDFSpanBase.EnumDataType.NameSpan);
    }

    public JDFEnumerationSpan getEnumerationSpan(String strName) {
        return (JDFEnumerationSpan)this.getSpan(strName, JDFSpanBase.EnumDataType.EnumerationSpan);
    }

    public JDFStringSpan getStringSpan(String strName) {
        return (JDFStringSpan)this.getSpan(strName, JDFSpanBase.EnumDataType.StringSpan);
    }

    public JDFDurationSpan getDurationSpan(String strName) {
        return (JDFDurationSpan)this.getSpan(strName, JDFSpanBase.EnumDataType.DurationSpan);
    }

    public JDFTimeSpan getTimeSpan(String strName) {
        return (JDFTimeSpan)this.getSpan(strName, JDFSpanBase.EnumDataType.TimeSpan);
    }

    public JDFXYPairSpan getXYPairSpan(String strName) {
        return (JDFXYPairSpan)this.getSpan(strName, JDFSpanBase.EnumDataType.XYPairSpan);
    }

    public JDFShapeSpan getShapeSpan(String strName) {
        return (JDFShapeSpan)this.getSpan(strName, JDFSpanBase.EnumDataType.ShapeSpan);
    }

    public JDFNumberSpan appendNumberSpan(String strName) {
        return (JDFNumberSpan)this.appendSpan(strName, JDFSpanBase.EnumDataType.NumberSpan);
    }

    public JDFOptionSpan appendOptionSpan(String strName) {
        return (JDFOptionSpan)this.appendSpan(strName, JDFSpanBase.EnumDataType.OptionSpan);
    }

    public JDFIntegerSpan appendIntegerSpan(String strName) {
        return (JDFIntegerSpan)this.appendSpan(strName, JDFSpanBase.EnumDataType.IntegerSpan);
    }

    public JDFNameSpan appendNameSpan(String strName) {
        return (JDFNameSpan)this.appendSpan(strName, JDFSpanBase.EnumDataType.NameSpan);
    }

    public JDFEnumerationSpan appendEnumerationSpan(String strName) {
        return (JDFEnumerationSpan)this.appendSpan(strName, JDFSpanBase.EnumDataType.EnumerationSpan);
    }

    public JDFStringSpan appendStringSpan(String strName) {
        return (JDFStringSpan)this.appendSpan(strName, JDFSpanBase.EnumDataType.StringSpan);
    }

    public JDFDurationSpan appendDurationSpan(String strName) {
        return (JDFDurationSpan)this.appendSpan(strName, JDFSpanBase.EnumDataType.DurationSpan);
    }

    public JDFTimeSpan appendTimeSpan(String strName) {
        return (JDFTimeSpan)this.appendSpan(strName, JDFSpanBase.EnumDataType.TimeSpan);
    }

    public JDFXYPairSpan appendXYPairSpan(String strName) {
        return (JDFXYPairSpan)this.appendSpan(strName, JDFSpanBase.EnumDataType.XYPairSpan);
    }

    public JDFShapeSpan appendShapeSpan(String strName) {
        return (JDFShapeSpan)this.appendSpan(strName, JDFSpanBase.EnumDataType.ShapeSpan);
    }

    JDFSpanBase getCreateSpan(String strName, JDFSpanBase.EnumDataType nType) {
        JDFSpanBase e = (JDFSpanBase)this.getCreateElement_JDFResource(strName, "", 0);
        e.setDataType(nType);
        return e;
    }

    public JDFSpanBase getSpan(String strName, JDFSpanBase.EnumDataType nType) {
        JDFSpanBase.EnumDataType dataType;
        JDFSpanBase e = (JDFSpanBase)this.getElement(strName, "", 0);
        if (e != null && nType != null && !(dataType = e.getDataType()).equals((Object)nType)) {
            throw new JDFException("JDFIntentResource.getSpan incompatible datatypes" + e.getAttribute("DataType"));
        }
        return e;
    }

    public JDFSpanBase appendSpan(String strName, JDFSpanBase.EnumDataType nType) {
        JDFSpanBase e = (JDFSpanBase)this.appendElement(strName, "");
        if (nType != null) {
            e.setDataType(nType);
        }
        return e;
    }
}

