/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.process;

import java.util.HashSet;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoColorPool;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.resource.process.JDFColor;
import org.cip4.jdflib.util.StringUtil;
import org.w3c.dom.DOMException;

public class JDFColorPool
extends JDFAutoColorPool {
    private static final long serialVersionUID = 1L;

    public JDFColorPool(CoreDocumentImpl myOwnerDocument, String qualifiedName) throws DOMException {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFColorPool(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFColorPool(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFColorPool[  --> " + super.toString() + " ]";
    }

    public void removeColor(String strColorName) {
        VElement vElem = this.getChildElementVector("Color", null, null, true, 0, false);
        if (vElem != null) {
            int size = vElem.size();
            for (int i = 0; i < size; ++i) {
                JDFColor c = (JDFColor)vElem.elementAt(i);
                if (!strColorName.equals(c.getActualColorName())) continue;
                c.deleteNode();
            }
        }
    }

    @Override
    public boolean isValid(JDFElement.EnumValidationLevel level) {
        boolean bValid = super.isValid(level);
        if (!bValid) {
            return false;
        }
        bValid = this.getDuplicateColors() == null;
        return bValid;
    }

    @Deprecated
    public boolean hasDuplicateColors() {
        return this.getDuplicateColors() != null;
    }

    public VString getDuplicateColors() {
        VElement v = this.getChildElementVector("Color", null, null, true, 0, false);
        HashSet<String> vName = new HashSet<String>();
        int nCols = v.size();
        VString vRet = new VString();
        for (int i = 0; i < nCols; ++i) {
            String rawName;
            JDFColor color = (JDFColor)v.elementAt(i);
            String colorName = color.getName();
            if (vName.contains(colorName)) {
                vRet.appendUnique(colorName);
            }
            if (vName.contains(rawName = color.get8BitName())) {
                vRet.appendUnique(colorName);
            }
            vName.add(colorName);
            vName.add(rawName);
        }
        return vRet.size() == 0 ? null : vRet;
    }

    public JDFColor getColorWithName(String colorName) {
        JDFColor color = null;
        if (colorName == null) {
            throw new JDFException("Bad colorname:" + colorName);
        }
        VElement v = this.getChildElementVector("Color", null, null, true, 0, false);
        if (v != null) {
            int pos = -1;
            int siz = v.size();
            for (int i = 0; i < siz; ++i) {
                color = (JDFColor)v.elementAt(i);
                if (!colorName.equals(color.getName()) && !colorName.equals(color.getActualColorName())) continue;
                if (pos < 0) {
                    pos = i;
                    continue;
                }
                throw new JDFException("Multiple colors exist for:" + colorName);
            }
            color = (JDFColor)(pos == -1 ? null : v.elementAt(pos));
        }
        return color;
    }

    public JDFColor getColorWith8BitName(String rawName) {
        VElement v = this.getChildElementVector("Color", null, null, true, 0, false);
        for (int i = 0; i < v.size(); ++i) {
            JDFColor c = (JDFColor)v.elementAt(i);
            String pRawName = new String(StringUtil.getRawBytes(c.get8BitName()));
            if (!pRawName.equals(rawName)) continue;
            return c;
        }
        return null;
    }

    public JDFColor getColorWithRawName(String rawName) {
        JDFAttributeMap m = new JDFAttributeMap();
        String hexRawName = StringUtil.setHexBinaryBytes(rawName.getBytes(), -1);
        m.put("RawName", hexRawName);
        VElement v = this.getChildElementVector("Color", null, m, true, 0, false);
        if (v.size() == 0) {
            return null;
        }
        if (v.size() > 1) {
            throw new JDFException("JDFColorPool.getColorWithRawName: too many colors\n");
        }
        return (JDFColor)v.elementAt(0);
    }

    public JDFColor appendColorWithName(String colorName, String rawName) {
        JDFColor col = this.getColorWithName(colorName);
        if (col == null) {
            col = this.getColorWith8BitName(rawName);
        }
        if (col == null) {
            col = this.appendColor();
            if (rawName != null) {
                col.set8BitNames(rawName.getBytes());
            }
        } else {
            throw new JDFException("JDFColorPool::AppendColorWithName color exists: " + colorName + "/" + rawName);
        }
        col.setName(colorName);
        return col;
    }

    public JDFColor getCreateColorWithName(String colorName, String rawName) {
        JDFColor col;
        JDFColor jDFColor = col = rawName != null ? this.getColorWithRawName(rawName) : null;
        if (col != null) {
            return col;
        }
        col = this.getColorWithName(colorName);
        if (col == null) {
            col = this.appendColor();
            if (rawName != null) {
                col.set8BitNames(rawName.getBytes());
            }
            col.setName(colorName);
        } else if (col.hasAttribute("RawName") && rawName != null) {
            throw new JDFException("JDFColorPool.getCreateColorWithName color is inconsistent: " + colorName);
        }
        return col;
    }
}

