/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.process;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoPerson;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.util.StringUtil;
import org.w3c.dom.DOMException;

public class JDFPerson
extends JDFAutoPerson {
    private static final long serialVersionUID = 1L;

    public JDFPerson(CoreDocumentImpl myOwnerDocument, String qualifiedName) throws DOMException {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFPerson(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFPerson(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFPerson[  --> " + super.toString() + " ]";
    }

    @Override
    public void setFamilyName(String familyName) {
        String oldName = this.getAttribute("FamilyName", null, null);
        super.setFamilyName(familyName);
        if (familyName == null) {
            return;
        }
        String descName = this.getDescriptiveName();
        if (descName == null || descName.equals("")) {
            this.setDescriptiveName(familyName);
        } else if (descName.equals(this.getFirstName())) {
            this.setDescriptiveName(this.getFirstName() + " " + familyName);
        } else if (oldName != null && descName.endsWith(oldName)) {
            descName = StringUtil.replaceString(descName, oldName, familyName);
            this.setDescriptiveName(descName);
        }
    }

    @Override
    public void setFirstName(String firstName) {
        String oldName = this.getAttribute("FirstName", null, null);
        super.setFirstName(firstName);
        if (firstName == null) {
            return;
        }
        String descName = this.getDescriptiveName();
        if (descName == null || descName.equals("")) {
            this.setDescriptiveName(firstName);
        } else if (descName.equals(this.getFamilyName())) {
            this.setDescriptiveName(firstName + " " + this.getFamilyName());
        } else if (oldName != null && descName.startsWith(oldName)) {
            descName = StringUtil.replaceString(descName, oldName, firstName);
            this.setDescriptiveName(descName);
        }
    }

    @Override
    public KElement clone() {
        return super.clone();
    }

    @Override
    public String getDescriptiveName() {
        String s = StringUtil.getNonEmpty(super.getDescriptiveName());
        if (s == null) {
            VString vs = new VString();
            s = StringUtil.getNonEmpty(this.getNamePrefix());
            if (s != null) {
                vs.add(s);
            }
            if ((s = StringUtil.getNonEmpty(this.getFirstName())) != null) {
                vs.add(s);
            }
            if ((s = StringUtil.getNonEmpty(this.getFamilyName())) != null) {
                vs.add(s);
            }
            if ((s = StringUtil.getNonEmpty(this.getNameSuffix())) != null) {
                vs.add(s);
            }
            s = StringUtil.setvString(vs, " ", null, null);
        }
        return s;
    }
}

