/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.auto.JDFAutoSpawned;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.JDFNodeInfo;
import org.cip4.jdflib.core.JDFPartAmount;
import org.cip4.jdflib.core.JDFRefElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.node.JDFAncestor;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.node.JDFSpawned;
import org.cip4.jdflib.pool.JDFAmountPool;
import org.cip4.jdflib.pool.JDFAncestorPool;
import org.cip4.jdflib.pool.JDFAuditPool;
import org.cip4.jdflib.pool.JDFResourcePool;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.process.JDFIdentical;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;

public class JDFSpawn {
    private JDFNode node;
    private JDFNode rootOut;
    private JDFNode informativeRoot;
    private final Map<JDFNode, HashSet<String>> mapAllRefs;
    private final Map<JDFResource, VString> mapRefs;
    private final Set<String> noIdentical;
    private final Map<String, KElement> mapResources;
    private boolean idCacheFilled;
    private final Log log = LogFactory.getLog(this.getClass());
    public boolean bSpawnROPartsOnly = true;
    public boolean bSpawnRWPartsMultiple = false;
    public boolean bCopyNodeInfo = true;
    public boolean bSpawnIdentical = true;
    public boolean bCopyCustomerInfo = true;
    public boolean bCopyComments = false;
    public boolean bFixResources = true;
    public String parentURL = null;
    public String spawnURL = null;
    public VString vRWResources_in = null;
    public VJDFAttributeMap vSpawnParts = null;
    private Set<JDFAttributeMap> setSpawnParts = null;
    private boolean bInformative = false;
    public static final int exAlreadyMerged = 10001;
    public static final int exMultiSpawnRW = 10002;

    public JDFSpawn(JDFNode nodeToSpawn) {
        this.node = nodeToSpawn;
        this.informativeRoot = null;
        this.mapRefs = new HashMap<JDFResource, VString>();
        this.mapAllRefs = new HashMap<JDFNode, HashSet<String>>();
        this.mapResources = new HashMap<String, KElement>();
        this.noIdentical = new HashSet<String>();
        this.idCacheFilled = false;
    }

    public void setNode(JDFNode newNode) {
        if (!newNode.getOwnerDocument().equals(this.node.getOwnerDocument())) {
            throw new JDFException("Setting illegal node in spawn");
        }
        if (this.node != newNode) {
            this.idCacheFilled = false;
        }
        this.node = newNode;
    }

    public JDFNode spawn() {
        VString vRWResources;
        VString vString = vRWResources = this.vRWResources_in == null ? new VString() : this.vRWResources_in;
        if (!this.bSpawnRWPartsMultiple) {
            this.checkMultipleRWRes();
        }
        JDFDoc docOut = new JDFDoc("JDF");
        this.rootOut = (JDFNode)docOut.getRoot();
        this.prepareNodeInfos();
        this.rootOut.copyInto(this.node, true);
        docOut.setNSMap(this.node.getOwnerDocument_KElement());
        String spawnID = "Sp" + KElement.uniqueID(0);
        this.rootOut.setSpawnID(spawnID);
        this.rootOut.setVersion(this.node.getVersion(true));
        String nodeInfoNonAncestor = "NodeInfo:Input";
        if (!vRWResources.contains("NodeInfo:Input")) {
            vRWResources.addElement("NodeInfo:Input");
        }
        JDFNode spawnParentNode = null;
        if (this.vSpawnParts != null && !this.vSpawnParts.isEmpty()) {
            spawnParentNode = this.node;
            JDFAuditPool ap = this.rootOut.getAuditPool();
            if (ap != null) {
                this.rootOut.removeChild(ap);
                ap = this.rootOut.appendAuditPool();
            }
            JDFAncestorPool ancpool = docOut.getJDFRoot().getAncestorPool();
            VJDFAttributeMap preSpawnedParts = new VJDFAttributeMap();
            if (ancpool != null) {
                preSpawnedParts = ancpool.getPartMapVector();
            }
            if (!preSpawnedParts.isEmpty()) {
                this.vSpawnParts.overlapMap(preSpawnedParts);
            }
            if (this.vSpawnParts.isEmpty()) {
                throw new JDFException("JDFNode.Spawn attempting to spawn incompatible partitions");
            }
            this.setSpawnParts = ContainerUtil.toHashSet(this.vSpawnParts);
        } else {
            spawnParentNode = this.node.getParentJDF();
            if (spawnParentNode == null) {
                this.log.error((Object)"JDFNode.Spawn cannot spawn unpartitioned root node");
                throw new JDFException("JDFNode.Spawn cannot spawn unpartitioned root node");
            }
        }
        this.setSpawnParent(spawnParentNode);
        JDFSpawned spawnAudit = this.createSpawnAudit(spawnID, spawnParentNode);
        this.addSpawnedResources(spawnAudit);
        this.finalizeSpawn(spawnAudit);
        return this.rootOut;
    }

    private void prepareNodeInfos() {
        if (this.vSpawnParts == null) {
            return;
        }
        VElement vn = this.node.getvJDFNode(null, null, false);
        int size = vn.size();
        for (int i = 0; i < size; ++i) {
            JDFNode vnNode_i = (JDFNode)vn.elementAt(i);
            vnNode_i.prepareNodeInfo(this.vSpawnParts);
        }
    }

    private void checkMultipleRWRes() {
        Collection<JDFResource> vCheck = this.checkSpawnedResources();
        if (vCheck != null) {
            String strIDs = "JDFNode.spawn: multiply spawned rw resources: ";
            VString vBad = new VString();
            for (JDFResource check : vCheck) {
                vBad.appendUnique(check.getID());
            }
            strIDs = strIDs + StringUtil.setvString(vBad, " ", null, null);
            this.log.error((Object)strIDs);
            throw new JDFException(strIDs, 10002);
        }
    }

    public Collection<JDFResource> cleanSpawnedResources() {
        Collection<JDFResource> multi = this.checkSpawnedResources();
        if (multi != null) {
            for (JDFResource r : multi) {
                r.removeInheritedAttributes("SpawnIDs", null);
                r.removeInheritedAttributes("SpawnStatus", null);
            }
        }
        return multi;
    }

    public Collection<JDFResource> checkSpawnedResources() {
        VString vRWResources = new VString(this.vRWResources_in);
        LinkedHashSet<JDFResource> vMultiRes = new LinkedHashSet<JDFResource>();
        if (!this.idCacheFilled) {
            this.node.getOwnerDocument_JDFElement().getCreateXMLDocUserData().fillIDCache();
            this.idCacheFilled = true;
        }
        HashSet<JDFElement> vRootLinks = this.node.getAllRefs(null, true);
        for (JDFElement liRoot : vRootLinks) {
            this.checkSpawnedResource(vRWResources, vMultiRes, liRoot);
        }
        return vMultiRes.isEmpty() ? null : vMultiRes;
    }

    private void checkSpawnedResource(VString vRWResources, HashSet<JDFResource> vMultiRes, JDFElement liRoot) {
        JDFRefElement re;
        JDFResource r = null;
        boolean bResRW = false;
        if (liRoot instanceof JDFResourceLink) {
            bResRW = this.linkFitsRWRes((JDFResourceLink)liRoot, vRWResources);
            if (bResRW) {
                JDFResourceLink rl = (JDFResourceLink)liRoot;
                r = rl.getTarget();
            }
        } else if (liRoot instanceof JDFRefElement && (r = (re = (JDFRefElement)liRoot).getTarget()) != null) {
            bResRW = this.resFitsRWRes(r, vRWResources);
        }
        if (bResRW && r != null) {
            VElement vRes = this.getSpawnLeaves(r);
            for (KElement e : vRes) {
                JDFResource rTarget = (JDFResource)e;
                if (!JDFResource.EnumSpawnStatus.SpawnedRW.equals((Object)rTarget.getSpawnStatus()) || vMultiRes.contains(rTarget) || this.vSpawnParts != null && !this.vSpawnParts.overlapsMap(rTarget.getPartMap())) continue;
                vMultiRes.add(rTarget);
            }
        }
    }

    private VElement getSpawnLeaves(JDFResource r) {
        VElement vRes = new VElement();
        if (this.vSpawnParts == null || this.vSpawnParts.isEmpty()) {
            vRes = r.getLeaves(false);
        } else {
            VElement partitionVector = r.getPartitionVector(this.vSpawnParts, null);
            if (partitionVector != null) {
                for (KElement e : partitionVector) {
                    JDFResource rPart = (JDFResource)e;
                    vRes.addAll(rPart.getLeaves(false));
                }
                vRes.unify();
            }
        }
        return vRes;
    }

    private VElement prepareSpawnLinks(JDFNode node) {
        VElement vn = node.getvJDFNode(null, null, false);
        int size = vn.size();
        VElement outLinks = new VElement();
        for (int i = 0; i < size; ++i) {
            JDFNode vnNode_i = (JDFNode)vn.elementAt(i);
            outLinks.addAll(vnNode_i.getResourceLinks(null));
        }
        outLinks.unify();
        return outLinks;
    }

    private void setSpawnParent(JDFNode parent) {
        VString vs = parent.getAncestorIDs();
        JDFAncestorPool ancestorPool = parent.getJDFRoot().getAncestorPool();
        String lastAncestorID = "";
        if (!parent.equals(this.node)) {
            int numAncestors;
            this.rootOut.removeChild("AncestorPool", null, 0);
            if (parent.getJDFRoot().hasChildElement("AncestorPool", null) && (numAncestors = (ancestorPool = (JDFAncestorPool)this.rootOut.copyElement(ancestorPool, null)).numChildElements("Ancestor", null)) > 0) {
                lastAncestorID = ancestorPool.getAncestor(numAncestors - 1).getNodeID();
            }
        }
        ancestorPool = this.rootOut.getCreateAncestorPool();
        ancestorPool.setPartMapVector(this.vSpawnParts);
        int startAncestorLoop = 0;
        if (vs.size() > 0 && vs.elementAt(0).equals(lastAncestorID)) {
            startAncestorLoop = 1;
        }
        for (int i = startAncestorLoop; i < vs.size(); ++i) {
            JDFAncestor ancestor = ancestorPool.appendAncestor();
            ancestor.setNodeID(vs.elementAt(i));
            if (i != 0 || this.parentURL == null || this.parentURL.equals("")) continue;
            ancestor.setFileName(this.parentURL);
        }
        this.rootOut.setJobID(parent.getJobID(true));
        ancestorPool.copyNodeData(parent, this.bCopyNodeInfo, this.bCopyCustomerInfo, this.bCopyComments);
    }

    private JDFSpawned createSpawnAudit(String spawnID, JDFNode spawnParentNode) {
        JDFAuditPool p = spawnParentNode.getCreateAuditPool();
        JDFSpawned spawnAudit = p.addSpawned(this.rootOut, null, null, null, null);
        if (this.spawnURL != null && !this.spawnURL.equals("")) {
            if (this.spawnURL.indexOf("://") == -1) {
                spawnAudit.setURL("file://" + this.spawnURL);
            } else {
                spawnAudit.setURL(this.spawnURL);
            }
        }
        spawnAudit.setNewSpawnID(spawnID);
        return spawnAudit;
    }

    private int addSpawnedResources(JDFSpawned spawnAudit) {
        VString vRWResources = new VString(this.vRWResources_in);
        int nSpawned = 0;
        JDFResourcePool rPool = this.rootOut.getCreateResourcePool();
        JDFAncestorPool ap = this.rootOut.getAncestorPool();
        if (ap != null) {
            ap = (JDFAncestorPool)this.node.copyElement(ap, null);
        }
        if (!this.idCacheFilled) {
            this.node.getOwnerDocument_JDFElement().getCreateXMLDocUserData().fillIDCache();
            this.idCacheFilled = true;
        }
        HashSet<JDFElement> vRootLinks = this.node.getAllRefs(null, false);
        HashSet<String> allIDsCopied = this.getAllIdsCopied();
        String spawnID = spawnAudit.getNewSpawnID();
        for (int loopRORW = 0; loopRORW < 2; ++loopRORW) {
            for (JDFElement liRoot : vRootLinks) {
                boolean bRealyRW;
                if (liRoot.getDeepParent("ResourcePool", 0) != null) continue;
                String refID = liRoot.getAttribute("rRef");
                boolean bResRW = false;
                JDFResource rRoot = null;
                if (liRoot instanceof JDFResourceLink) {
                    bResRW = this.linkFitsRWRes((JDFResourceLink)liRoot, vRWResources);
                } else if (liRoot instanceof JDFRefElement) {
                    rRoot = this.getNodeResource(refID);
                    bResRW = this.resFitsRWRes(rRoot, vRWResources);
                }
                if (bResRW != (loopRORW != 0)) continue;
                boolean isThereAlready = allIDsCopied.contains(refID);
                JDFResource.EnumSpawnStatus copyStatus = bResRW ? JDFResource.EnumSpawnStatus.SpawnedRW : JDFResource.EnumSpawnStatus.SpawnedRO;
                LinkedHashSet<String> vvRO = new LinkedHashSet<String>();
                LinkedHashSet<String> vvRW = new LinkedHashSet<String>();
                if (rRoot == null) {
                    rRoot = this.getNodeResource(refID);
                }
                if (rRoot == null) continue;
                this.copySpawnedResource(rPool, rRoot, copyStatus, spawnID, vRWResources, vvRW, vvRO, allIDsCopied);
                nSpawned += vvRO.size() + vvRW.size();
                VElement vRes = new VElement();
                VElement vResRoot = new VElement();
                if (liRoot instanceof JDFResourceLink) {
                    JDFResourceLink liRootLink = (JDFResourceLink)liRoot;
                    VJDFAttributeMap vLinkMap = liRootLink.getPartMapVector();
                    JDFResourceLink dummy = (JDFResourceLink)this.rootOut.getCreateResourceLinkPool().copyElement(liRoot, null);
                    this.fixResLinks(bResRW, liRootLink, dummy);
                    liRootLink.setPartMapVector(this.vSpawnParts);
                    dummy.setPartMapVector(this.vSpawnParts);
                    vResRoot = ((JDFResourceLink)liRoot).getTargetVector(-1);
                    vRes = dummy.getTargetVector(-1);
                    dummy.deleteNode();
                    this.reduceLinkPartition(liRootLink, vLinkMap);
                } else if (liRoot instanceof JDFRefElement) {
                    vResRoot.add(((JDFRefElement)liRoot).getTarget());
                    JDFRefElement dummy = (JDFRefElement)this.rootOut.copyElement(liRoot, null);
                    vRes.add(dummy.getTarget());
                    dummy.deleteNode();
                } else {
                    this.log.error((Object)("we have a link that is neither ref nor link. Whazzup? " + liRoot == null ? " null" : liRoot.getNodeName()));
                    continue;
                }
                this.addIdentical(vResRoot);
                this.addIdentical(vRes);
                int siz = vRes.size() < vResRoot.size() ? vRes.size() : vResRoot.size();
                boolean bl = bRealyRW = this.vSpawnParts == null || this.vSpawnParts.size() == 0;
                if (!bRealyRW && siz > 0 && (bResRW || this.bSpawnROPartsOnly)) {
                    JDFResource r = (JDFResource)vRes.elementAt(0);
                    this.reducePartitions(r.getResourceRoot());
                }
                for (int resParts = 0; resParts < siz; ++resParts) {
                    JDFResource r = (JDFResource)vRes.elementAt(resParts);
                    JDFResource rRoot1 = (JDFResource)vResRoot.elementAt(resParts);
                    new PartSpawn().spawnPart(rRoot1, spawnID, copyStatus, true);
                    new PartSpawn().spawnPart(r, spawnID, copyStatus, false);
                    if (resParts != 0 || this.vSpawnParts == null || this.vSpawnParts.size() == 0 || !bResRW && !this.bSpawnROPartsOnly || !JDFResource.EnumSpawnStatus.SpawnedRW.equals((Object)rRoot1.getSpawnStatus())) continue;
                    bRealyRW = true;
                }
                if (!bRealyRW && JDFResource.EnumSpawnStatus.SpawnedRO.equals((Object)copyStatus)) {
                    bResRW = false;
                    if (!vvRO.contains(rRoot.getID()) && !vvRW.contains(rRoot.getID())) {
                        vvRO.add(rRoot.getID());
                    }
                }
                if (isThereAlready && bResRW) {
                    vvRW.add(rRoot.getID());
                }
                this.calcAuditSpawnIDs(spawnAudit, vvRO, vvRW);
            }
        }
        if (ap != null) {
            ap.deleteNode();
        }
        return nSpawned;
    }

    protected void calcAuditSpawnIDs(JDFSpawned spawnAudit, HashSet<String> vvRO, HashSet<String> vvRW) {
        VString rRefsRW = spawnAudit.getrRefsRWCopied();
        VString rRefsRO = spawnAudit.getrRefsROCopied();
        for (String s : vvRW) {
            rRefsRW.add(s);
            int ind = rRefsRO.index(s);
            if (ind < 0) continue;
            rRefsRO.remove(ind);
        }
        for (String s : vvRO) {
            rRefsRO.add(s);
        }
        rRefsRO.unify();
        rRefsRW.unify();
        if (rRefsRO.isEmpty()) {
            rRefsRO = null;
        }
        if (rRefsRW.isEmpty()) {
            rRefsRW = null;
        }
        spawnAudit.setrRefsROCopied(rRefsRO);
        spawnAudit.setrRefsRWCopied(rRefsRW);
    }

    private HashSet<String> getAllIdsCopied() {
        HashSet<String> allIDsCopied = this.mapAllRefs.get(this.node);
        if (allIDsCopied == null) {
            allIDsCopied = this.rootOut.fillHashSet("ID", null);
            this.mapAllRefs.put(this.node, allIDsCopied);
        }
        HashSet<String> hs = new HashSet<String>();
        hs.addAll(allIDsCopied);
        return hs;
    }

    private JDFResource getNodeResource(String refID) {
        KElement rRoot = this.mapResources.get(refID);
        if (rRoot == null) {
            rRoot = this.node.getJDFRoot().getTarget(refID, "ID");
            this.mapResources.put(refID, rRoot);
        }
        if (!(rRoot instanceof JDFResource)) {
            rRoot = null;
        }
        return (JDFResource)rRoot;
    }

    private void addIdentical(VElement vRes) {
        if (!this.bSpawnIdentical) {
            return;
        }
        if (vRes == null || vRes.size() == 0 || this.vSpawnParts == null || this.vSpawnParts.size() == 0) {
            return;
        }
        JDFResource root = ((JDFResource)vRes.get(0)).getResourceRoot();
        String id = root.getID();
        if (this.noIdentical.contains(id)) {
            return;
        }
        VElement identicals = root.getChildrenByTagName("Identical", null, null, false, true, -1, false);
        if (identicals == null || identicals.size() == 0) {
            this.noIdentical.add(id);
            return;
        }
        for (int i = 0; i < identicals.size(); ++i) {
            JDFIdentical ident = (JDFIdentical)identicals.get(i);
            JDFResource identParent = (JDFResource)ident.getParentNode_KElement();
            JDFAttributeMap identMap = identParent.getPartMap();
            for (int j = 0; j < this.vSpawnParts.size(); ++j) {
                JDFAttributeMap mapPart = this.vSpawnParts.elementAt(j);
                if (!mapPart.subMap(identMap)) continue;
                vRes.add(identParent);
            }
        }
    }

    private void fixResLinks(boolean bResRW, JDFResourceLink liRootLink, JDFResourceLink dummy) {
        if (this.bFixResources && this.vSpawnParts != null && this.vSpawnParts.size() != 0 && bResRW) {
            JDFResource dummyRoot;
            VString rootPartIDKeys = this.rootOut.getJDFRoot().getPartIDKeys(this.vSpawnParts.elementAt(0));
            JDFResource linkRoot = liRootLink.getLinkRoot();
            if (linkRoot != null) {
                try {
                    linkRoot.createPartitions(this.vSpawnParts, rootPartIDKeys);
                }
                catch (JDFException x) {
                    for (int i = 0; i < this.vSpawnParts.size(); ++i) {
                        this.fixSpawnPartitions(linkRoot.getPartition(this.vSpawnParts.elementAt(i), null), rootPartIDKeys);
                    }
                }
            }
            if ((dummyRoot = dummy.getLinkRoot()) != null) {
                try {
                    dummyRoot.createPartitions(this.vSpawnParts, rootPartIDKeys);
                }
                catch (JDFException x) {
                    for (int i = 0; i < this.vSpawnParts.size(); ++i) {
                        this.fixSpawnPartitions(dummyRoot.getPartition(this.vSpawnParts.elementAt(i), null), rootPartIDKeys);
                    }
                }
            }
        }
    }

    private void finalizeSpawn(JDFSpawned spawnAudit) {
        if (this.vSpawnParts != null && !this.vSpawnParts.isEmpty()) {
            VElement outLinks = this.prepareSpawnLinks(this.rootOut);
            VElement mainLinks = this.prepareSpawnLinks(this.node);
            this.finalizePartitions(spawnAudit, outLinks, mainLinks);
        }
        this.finalizeStatusAndAudits(spawnAudit);
    }

    private void finalizePartitions(JDFSpawned spawnAudit, VElement outLinks, VElement mainLinks) {
        int mainLinkLen = mainLinks.size();
        int outLinkSize = outLinks.size();
        String spawnID = spawnAudit.getNewSpawnID();
        for (int i = 0; i < outLinkSize; ++i) {
            JDFResourceLink link = (JDFResourceLink)outLinks.elementAt(i);
            JDFResource r = link.getLinkRoot();
            if (r != null) {
                VJDFAttributeMap vPartMap = this.getSpawnLinkMap(this.vSpawnParts, r);
                VJDFAttributeMap vNewMap = this.getSpawnedLinkPartMap(link, vPartMap);
                this.reduceLinkPartition(link, vNewMap);
                this.updateSpawnIDs(spawnID, link);
                String id = link.getrRef();
                link = (JDFResourceLink)mainLinks.elementAt(i);
                if (id.equals(link.getrRef())) {
                    this.updateSpawnIDsInMain(spawnID, link, vPartMap);
                    continue;
                }
                for (int ii = 0; ii < mainLinkLen; ++ii) {
                    link = (JDFResourceLink)mainLinks.elementAt(ii);
                    if (!id.equals(link.getrRef())) continue;
                    this.updateSpawnIDsInMain(spawnID, link, vPartMap);
                }
                continue;
            }
            this.log.warn((Object)("invalid link id=" + link.getrRef() + " Skipping"));
        }
    }

    private void reduceLinkPartition(JDFResourceLink link, VJDFAttributeMap vNewMap) {
        VElement partAmounts;
        link.setPartMapVector(vNewMap);
        JDFAmountPool ap = link.getAmountPool();
        if (ap != null && (partAmounts = ap.getChildElementVector("PartAmount", null)) != null) {
            for (KElement e : partAmounts) {
                JDFPartAmount pa = (JDFPartAmount)e;
                if (pa.getPartMapVector().overlapsMap(vNewMap)) continue;
                pa.deleteNode();
            }
        }
    }

    private void updateSpawnIDsInMain(String spawnID, JDFResourceLink link, VJDFAttributeMap vPartMap) {
        JDFResource rMain = link.getLinkRoot();
        if (rMain == null) {
            rMain = this.getNodeResource(link.getrRef());
            if (rMain == null) {
                return;
            }
            JDFNode parentNode = link.getParentJDF();
            parentNode.ensureValidRefsPosition(rMain);
        }
        VElement vMainPart = rMain.getPartitionVector(vPartMap, null);
        for (int kk = 0; kk < vMainPart.size(); ++kk) {
            JDFResource rMainLeaf;
            JDFResource rMainPart = (JDFResource)vMainPart.elementAt(kk);
            if (rMainPart == null) continue;
            VElement leaves = rMainPart.getLeaves(true);
            boolean bSpawnID = false;
            for (int kkk = 0; kkk < leaves.size() && !(bSpawnID = (rMainLeaf = (JDFResource)leaves.elementAt(kkk)).includesMatchingAttribute("SpawnIDs", spawnID, AttributeInfo.EnumAttributeType.NMTOKENS)); ++kkk) {
            }
            if (!(this.bSpawnIdentical || bSpawnID || vPartMap == null || vPartMap.subMap(rMainPart.getPartMap()))) {
                bSpawnID = true;
            }
            if (bSpawnID) continue;
            rMainPart.appendSpawnIDs(spawnID);
            rMainPart.setLocked(true);
            rMainPart.setSpawnStatus(JDFResource.EnumSpawnStatus.SpawnedRW);
        }
    }

    private VJDFAttributeMap getSpawnedLinkPartMap(JDFResourceLink link, VJDFAttributeMap vPartMap) {
        VJDFAttributeMap vLinkMap = link.getPartMapVector();
        VJDFAttributeMap vNewMap = new VJDFAttributeMap();
        if (vLinkMap == null) {
            vNewMap = vPartMap;
        } else {
            for (JDFAttributeMap linkMap : vLinkMap) {
                if (this.setSpawnParts.contains(linkMap)) {
                    vNewMap.add(linkMap);
                    continue;
                }
                for (JDFAttributeMap m : vPartMap) {
                    if ((m = m.clone().orMap(linkMap)).isEmpty()) continue;
                    vNewMap.add(m);
                }
            }
            vNewMap.unify();
        }
        return vNewMap;
    }

    private void updateSpawnIDs(String spawnID, JDFResourceLink link) {
        VElement vRes = link.getTargetVector(-1);
        for (int t = 0; t < vRes.size(); ++t) {
            JDFResource res = (JDFResource)vRes.elementAt(t);
            if (res.includesMatchingAttribute("SpawnIDs", spawnID, AttributeInfo.EnumAttributeType.NMTOKENS)) continue;
            res.appendSpawnIDs(spawnID);
            res.setLocked(false);
        }
    }

    private void finalizeStatusAndAudits(JDFSpawned spawnAudit) {
        spawnAudit.setPartMapVector(this.vSpawnParts);
        JDFElement.EnumNodeStatus partStatus = this.vSpawnParts != null && !this.vSpawnParts.isEmpty() ? this.node.getPartStatus(this.vSpawnParts.elementAt(0), 0) : this.node.getPartStatus(null, 0);
        if (partStatus != null) {
            spawnAudit.setStatus(partStatus);
        }
        VJDFAttributeMap vMap = this.getNIPartitions();
        this.node.setPartStatus(vMap, JDFElement.EnumNodeStatus.Spawned, null);
    }

    private VJDFAttributeMap getNIPartitions() {
        VJDFAttributeMap vMap;
        if (this.vSpawnParts != null) {
            VElement vNI;
            JDFNodeInfo nodeInfo = this.node.getNodeInfo();
            VElement vElement = vNI = nodeInfo == null ? null : nodeInfo.getPartitionVector(this.vSpawnParts, JDFResource.EnumPartUsage.Explicit);
            if (vNI != null) {
                vMap = new VJDFAttributeMap();
                for (KElement e : vNI) {
                    vMap.add(((JDFResource)e).getPartMap());
                }
            } else {
                vMap = this.vSpawnParts;
            }
        } else {
            vMap = this.vSpawnParts;
        }
        return vMap;
    }

    private VJDFAttributeMap getSpawnLinkMap(VJDFAttributeMap vLocalSpawnParts, JDFResource r) {
        VJDFAttributeMap vPartMap = new VJDFAttributeMap(vLocalSpawnParts);
        if (!JDFResource.EnumPartUsage.Implicit.equals((Object)r.getPartUsage())) {
            VString vPartKeys = r.getPartIDKeys();
            Vector<JDFResource.EnumPartIDKey> vImplicitPartitions = r.getImplicitPartitions();
            if (vImplicitPartitions != null) {
                for (int ii = 0; ii < vImplicitPartitions.size(); ++ii) {
                    JDFResource.EnumPartIDKey e = vImplicitPartitions.elementAt(ii);
                    vPartKeys.add(e.getName());
                }
            }
            vPartMap.reduceMap(vPartKeys.getSet());
        }
        return vPartMap;
    }

    private boolean linkFitsRWRes(JDFResourceLink li, VString vRWResources) {
        boolean bResRW = vRWResources.contains(li.getNamedProcessUsage());
        if (!bResRW) {
            bResRW = vRWResources.contains(li.getLinkedResourceName());
        }
        if (!bResRW) {
            bResRW = vRWResources.contains(li.getrRef());
        }
        if (!bResRW) {
            bResRW = vRWResources.contains(li.getAttribute("Usage"));
        }
        return bResRW;
    }

    private VElement reducePartitions(JDFResource r, String nodeName, String nsURI, VString partIDKeys, int partIDPos, JDFAttributeMap parentMap, VElement identical) {
        VElement bad = new VElement();
        VElement children = r.getChildElementVector_KElement(nodeName, nsURI, null, true, -1);
        if (children != null) {
            int kidSize = children.size();
            for (int i = 0; i < kidSize; ++i) {
                String val;
                JDFResource child = (JDFResource)children.elementAt(i);
                String key = partIDKeys.get(partIDPos);
                if (key == null || (val = child.getAttribute_KElement(key, null, null)) == null) continue;
                JDFAttributeMap testMap = new JDFAttributeMap(parentMap);
                testMap.put(key, val);
                if (this.overlapsPartMap(testMap)) {
                    int iii;
                    JDFIdentical id = child.getIdentical();
                    if (id != null) {
                        if (this.bSpawnIdentical) {
                            this.addIdentical(r, identical, testMap);
                        } else {
                            bad.add(child);
                        }
                    }
                    if (partIDPos + 1 < partIDKeys.size()) {
                        bad.appendUnique(this.reducePartitions(child, nodeName, nsURI, partIDKeys, partIDPos + 1, testMap, identical));
                        continue;
                    }
                    Vector<JDFIdentical> v = child.getChildrenByClass(JDFIdentical.class, true, 0);
                    if (v == null || v.size() <= 0) continue;
                    VElement v2 = new VElement();
                    for (iii = 0; iii < v.size(); ++iii) {
                        KElement parentNode_KElement = v.get(iii).getParentNode_KElement();
                        if (parentNode_KElement == child) continue;
                        v2.add(parentNode_KElement);
                    }
                    v2.unify();
                    for (iii = 0; iii < v2.size(); ++iii) {
                        JDFResource identParent = (JDFResource)v2.get(iii);
                        if (this.bSpawnIdentical) {
                            this.addIdentical(identParent, identical, identParent.getIdenticalMap());
                            continue;
                        }
                        identParent.deleteNode();
                    }
                    continue;
                }
                if (this.bSpawnIdentical) {
                    bad.addAll(child.getLeaves(true));
                    continue;
                }
                bad.add(child);
            }
            if (bad.size() >= children.size() && !this.bSpawnIdentical && !r.isResourceRoot() && bad.containsAll(children)) {
                bad.add(r);
            }
        }
        return bad;
    }

    private void addIdentical(JDFResource r, VElement identical, JDFAttributeMap testMap) {
        JDFResource resourceRoot = r.getResourceRoot();
        for (JDFResource partition = resourceRoot.getPartition(testMap, null); partition != resourceRoot; partition = (JDFResource)partition.getParentNode_KElement()) {
            identical.add(partition);
        }
    }

    private boolean overlapsPartMap(JDFAttributeMap testMap) {
        if (this.vSpawnParts == null || testMap == null) {
            return true;
        }
        if (this.setSpawnParts.contains(testMap)) {
            return true;
        }
        VString keys = testMap.getKeys();
        int ks = keys.size();
        for (int i = 0; i < this.vSpawnParts.size(); ++i) {
            boolean bOK = true;
            JDFAttributeMap map = this.vSpawnParts.elementAt(i);
            for (int j = 0; j < ks; ++j) {
                String key = keys.stringAt(j);
                String linkValue = map.get(key);
                if (linkValue == null || JDFPart.matchesPart(key, testMap.get(key), linkValue, false)) continue;
                bOK = false;
                break;
            }
            if (!bOK) continue;
            return true;
        }
        return ks <= 0;
    }

    private void reducePartitions(JDFResource r) {
        if (r == null || this.vSpawnParts == null || this.vSpawnParts.size() == 0) {
            return;
        }
        VString partIDKeys = r.getPartIDKeys();
        if (partIDKeys == null || partIDKeys.size() == 0) {
            return;
        }
        int nMax = 999;
        VElement vSubParts = r.getPartitionVector(this.vSpawnParts, JDFResource.EnumPartUsage.Implicit);
        for (int j = 0; j < vSubParts.size(); ++j) {
            int mapSize;
            JDFResource rr = (JDFResource)vSubParts.get(j);
            JDFAttributeMap partMap = rr.getPartMap(partIDKeys);
            int n = mapSize = partMap == null ? 0 : partMap.size();
            if (mapSize >= nMax || (nMax = mapSize) != 0) continue;
            return;
        }
        for (int i = partIDKeys.size() - 1; i >= nMax; --i) {
            partIDKeys.remove(i);
        }
        String nodeName = r.getLocalName();
        String nsURI = r.getNamespaceURI();
        VElement identical = new VElement();
        VElement vBad = this.reducePartitions(r, nodeName, nsURI, partIDKeys, 0, new JDFAttributeMap(), identical);
        vBad.unify();
        if (identical.size() > 0) {
            identical.unify();
            vBad.removeAll(identical);
        }
        for (int i = 0; i < vBad.size(); ++i) {
            vBad.get(i).deleteNode();
        }
    }

    private boolean resFitsRWRes(JDFResource r, VString vRWResources) {
        if (r == null) {
            return false;
        }
        boolean bResRW = vRWResources.contains(r.getLocalName());
        if (!bResRW) {
            bResRW = vRWResources.contains("*");
        }
        if (!bResRW) {
            bResRW = vRWResources.contains(r.getID());
        }
        return bResRW;
    }

    private void copySpawnedResource(JDFResourcePool p, JDFResource r, JDFResource.EnumSpawnStatus copyStatus, String spawnID, VString vRWResources, HashSet<String> vRWIDs, HashSet<String> vROIDs, HashSet<String> allIDsCopied) {
        VString vs;
        if (r == null) {
            this.log.error((Object)"attempting to copy null resource - bailing out");
            return;
        }
        boolean bRW = copyStatus == JDFResource.EnumSpawnStatus.SpawnedRW;
        String rID = r.getID();
        if (!allIDsCopied.contains(rID)) {
            JDFResource rNew = (JDFResource)p.copyElement(r, null);
            if (bRW || this.bSpawnROPartsOnly) {
                this.reducePartitions(rNew);
            }
            if (!this.bInformative) {
                new PartSpawn().spawnPart(r, spawnID, copyStatus, true);
            }
            new PartSpawn().spawnPart(rNew, spawnID, copyStatus, false);
            if (bRW) {
                vRWIDs.add(rID);
            } else {
                vROIDs.add(rID);
            }
            allIDsCopied.add(rID);
        }
        if ((vs = this.mapRefs.get(r)) == null) {
            vs = r.getHRefs(new VString(), false, false);
            this.mapRefs.put(r, vs);
        }
        int size = vs.size();
        for (int i = 0; i < size; ++i) {
            JDFResource next;
            String id = vs.elementAt(i);
            if (allIDsCopied.contains(id) || (next = this.getNodeResource(id)) == null) continue;
            if (bRW) {
                copyStatus = this.resFitsRWRes(next, vRWResources) ? JDFResource.EnumSpawnStatus.SpawnedRW : JDFResource.EnumSpawnStatus.SpawnedRO;
            }
            this.copySpawnedResource(p, next, copyStatus, spawnID, vRWResources, vRWIDs, vROIDs, allIDsCopied);
        }
    }

    private void fixSpawnPartitions(JDFResource r, VString rootPartIDKeys) {
        if (r == null) {
            return;
        }
        VString oldParts = r.getPartIDKeys();
        if (oldParts.containsAny(rootPartIDKeys)) {
            throw new JDFException("fixSpawnPartitions - adding incompatible resources");
        }
        VElement ve = r.getChildElementVector_KElement(r.getNodeName(), r.getNamespaceURI(), null, true, 9999999);
        KElement[] tmp = new KElement[ve.size()];
        for (int i = 0; i < ve.size(); ++i) {
            tmp[i] = ve.item(i).deleteNode();
        }
        r.removeAttribute("PartIDKeys");
        VElement vNew = r.getResourceRoot().createPartitions(this.vSpawnParts, rootPartIDKeys);
        for (int i = 0; i < vNew.size(); ++i) {
            for (int j = 0; j < tmp.length; ++j) {
                vNew.item(i).copyElement(tmp[j], null);
            }
        }
        VString partIDKeys = r.getPartIDKeys();
        partIDKeys.appendUnique(oldParts);
        r.setPartIDKeys(partIDKeys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JDFNode spawnInformative() {
        this.bInformative = true;
        if (this.informativeRoot == null) {
            JDFDoc docNew = new JDFDoc("JDF");
            this.informativeRoot = (JDFNode)docNew.getRoot();
            JDFNode thisRoot = this.node.getJDFRoot();
            docNew.setInitOnCreate(false);
            this.informativeRoot.copyInto(thisRoot, true);
            docNew.setInitOnCreate(true);
        }
        JDFNode copyOfThis = this.informativeRoot.getChildJDFNode(this.node.getID(), false);
        JDFNode tmp = this.node;
        this.node = copyOfThis;
        if (tmp != this.node) {
            this.mapResources.clear();
        }
        VString vRWTmp = this.vRWResources_in;
        boolean spawnMultKeep = this.bSpawnRWPartsMultiple;
        JDFNode nodeNew = null;
        try {
            this.bSpawnRWPartsMultiple = true;
            nodeNew = this.spawn();
            nodeNew.setActivation(JDFNode.EnumActivation.Informative);
        }
        finally {
            this.node = tmp;
            this.bSpawnRWPartsMultiple = spawnMultKeep;
            this.vRWResources_in = vRWTmp;
        }
        return nodeNew;
    }

    public JDFNode spawn(String _parentURL, String _spawnURL, VString _vRWResources_in, VJDFAttributeMap _vSpawnParts, boolean _bSpawnROPartsOnly, boolean _bCopyNodeInfo, boolean _bCopyCustomerInfo, boolean _bCopyComments) {
        this.bCopyComments = _bCopyComments;
        this.bCopyCustomerInfo = _bCopyCustomerInfo;
        this.bCopyNodeInfo = _bCopyNodeInfo;
        this.bSpawnROPartsOnly = _bSpawnROPartsOnly;
        this.vSpawnParts = _vSpawnParts;
        this.vRWResources_in = new VString(_vRWResources_in);
        this.spawnURL = _spawnURL;
        this.parentURL = _parentURL;
        this.bInformative = false;
        return this.spawn();
    }

    public JDFNode spawnInformative(String _parentURL, String _spawnURL, VJDFAttributeMap _vSpawnParts, boolean _bSpawnROPartsOnly, boolean _bCopyNodeInfo, boolean _bCopyCustomerInfo, boolean _bCopyComments) {
        this.bCopyComments = _bCopyComments;
        this.bCopyCustomerInfo = _bCopyCustomerInfo;
        this.bCopyNodeInfo = _bCopyNodeInfo;
        this.bSpawnROPartsOnly = _bSpawnROPartsOnly;
        this.vSpawnParts = _vSpawnParts;
        this.vRWResources_in = null;
        this.spawnURL = _spawnURL;
        this.parentURL = _parentURL;
        return this.spawnInformative();
    }

    public JDFNode unSpawn(String spawnID) {
        JDFSpawned spawnAudit;
        this.log.info((Object)("Unspawning node ID=" + spawnID));
        JDFNode nodeParent = this.findUnSpawnNode(this.node, spawnID);
        if (nodeParent != null && spawnID == null && (spawnAudit = (JDFSpawned)nodeParent.getAuditPool().getAudit(0, JDFAudit.EnumAuditType.Spawned, null, null)) != null) {
            spawnID = spawnAudit.getNewSpawnID();
            this.log.info((Object)("calculating spawnID from parent: SpawnID=" + spawnID));
        }
        return this.unSpawnNode(nodeParent, spawnID);
    }

    private JDFNode findUnSpawnNode(JDFNode myNode, String spawnID) {
        VElement vJDFNodes = myNode.getvJDFNode(null, null, false);
        JDFAttributeMap mapSpawn = new JDFAttributeMap("NewSpawnID", spawnID);
        int i = 0;
        int size = vJDFNodes.size();
        for (i = 0; i < size; ++i) {
            JDFAttributeMap mapMerge;
            JDFAudit mergedAudit;
            JDFAudit spawnAudit;
            JDFNode nodeParent = (JDFNode)vJDFNodes.elementAt(i);
            JDFAuditPool auditPool = nodeParent.getAuditPool();
            if (auditPool == null || (spawnAudit = auditPool.getAudit(0, JDFAudit.EnumAuditType.Spawned, mapSpawn, null)) == null || (mergedAudit = auditPool.getAudit(0, JDFAudit.EnumAuditType.Merged, mapMerge = new JDFAttributeMap("MergeID", spawnID), null)) != null) continue;
            return nodeParent;
        }
        JDFNode parent = myNode.getParentJDF();
        return parent == null ? null : this.findUnSpawnNode(parent, spawnID);
    }

    private JDFNode unSpawnNode(JDFNode parent, String strSpawnID) {
        if (parent == null) {
            this.log.warn((Object)"No parent to unspawn, bailing out");
            return null;
        }
        KElement spawnAudit = null;
        JDFNode localNode = null;
        if (strSpawnID != null && !strSpawnID.equals("")) {
            JDFAuditPool auditPool = parent.getAuditPool();
            if (auditPool != null) {
                VElement vn;
                JDFAttributeMap mapSpawn = new JDFAttributeMap("NewSpawnID", strSpawnID);
                spawnAudit = (JDFSpawned)auditPool.getAudit(0, JDFAudit.EnumAuditType.Spawned, mapSpawn, null);
                if (spawnAudit == null) {
                    this.log.warn((Object)"No parent audit to unspawn, bailing out");
                    return null;
                }
                VJDFAttributeMap parts = ((JDFSpawned)spawnAudit).getPartMapVector();
                VString vs = ((JDFAutoSpawned)spawnAudit).getrRefsROCopied();
                for (int i = 0; i < vs.size(); ++i) {
                    JDFResource oldRes = (JDFResource)parent.getTarget(vs.elementAt(i), "ID");
                    if (oldRes == null) continue;
                    oldRes.unSpawnPart(strSpawnID, JDFResource.EnumSpawnStatus.SpawnedRO);
                }
                VString vRWCopied = ((JDFAutoSpawned)spawnAudit).getrRefsRWCopied();
                for (int i = 0; i < vRWCopied.size(); ++i) {
                    JDFResource oldRes = (JDFResource)parent.getTarget(vRWCopied.elementAt(i), "ID");
                    if (oldRes == null) continue;
                    oldRes.unSpawnPart(strSpawnID, JDFResource.EnumSpawnStatus.SpawnedRW);
                }
                localNode = (JDFNode)parent.getTarget(((JDFAutoSpawned)spawnAudit).getjRef(), "ID");
                VElement vElement = vn = localNode == null ? null : localNode.getvJDFNode(null, null, false);
                if (vn != null) {
                    for (int nod = 0; nod < vn.size(); ++nod) {
                        JDFNode deepNode = (JDFNode)vn.elementAt(nod);
                        JDFResourcePool resPool = deepNode.getResourcePool();
                        if (resPool == null) continue;
                        VElement vRes = resPool.getPoolChildren(null, null, null);
                        for (int i = 0; i < vRes.size(); ++i) {
                            JDFResource res1 = (JDFResource)vRes.elementAt(i);
                            res1.unSpawnPart(strSpawnID, JDFResource.EnumSpawnStatus.SpawnedRW);
                        }
                    }
                }
                JDFElement.EnumNodeStatus status = JDFElement.EnumNodeStatus.Waiting;
                boolean fHasAuditStatus = spawnAudit.hasAttribute("Status");
                if (fHasAuditStatus) {
                    status = ((JDFElement)spawnAudit).getStatus();
                }
                if (parts != null) {
                    JDFElement.EnumNodeStatus parentStatus = parent.getStatus();
                    if (JDFElement.EnumNodeStatus.Pool.equals((Object)parentStatus) || JDFElement.EnumNodeStatus.Part.equals((Object)parentStatus)) {
                        for (int i = 0; i < parts.size(); ++i) {
                            if (!parent.getPartStatus(parts.elementAt(i), 0).equals((Object)JDFElement.EnumNodeStatus.Spawned) && !fHasAuditStatus) continue;
                            parent.setPartStatus(parts.elementAt(i), status, null);
                        }
                    } else if (JDFElement.EnumNodeStatus.Spawned.equals((Object)parentStatus) || spawnAudit.hasAttribute("Status")) {
                        parent.setStatus(status);
                    }
                } else if (localNode != null && (JDFElement.EnumNodeStatus.Spawned.equals((Object)localNode.getStatus()) || spawnAudit.hasAttribute("Status"))) {
                    localNode.setStatus(status);
                }
            }
            if (spawnAudit != null) {
                spawnAudit.deleteNode();
            }
        }
        return localNode;
    }

    public String toString() {
        String jpID = this.node == null ? " - " : this.node.getJobPartID(false);
        return "[JDFSpawn JobPartID=" + jpID + "\nParts: " + this.vSpawnParts + "\nRW: " + this.vRWResources_in;
    }

    private class PartSpawn {
        private PartSpawn() {
        }

        private void spawnPart(JDFResource r, String spawnID, JDFResource.EnumSpawnStatus copyStatus, boolean bStayinMain) {
            if (JDFSpawn.this.vSpawnParts != null && JDFSpawn.this.vSpawnParts.size() > 0) {
                JDFAttributeMap partMap = r.getPartMap();
                VElement vSubParts = this.getSubParts(r, partMap);
                for (int k = 0; k < vSubParts.size(); ++k) {
                    JDFResource pLeaf = (JDFResource)vSubParts.item(k);
                    if (pLeaf == null) continue;
                    if (bStayinMain) {
                        if (copyStatus == JDFResource.EnumSpawnStatus.SpawnedRW || pLeaf.getSpawnStatus() != JDFResource.EnumSpawnStatus.SpawnedRW) {
                            pLeaf.setSpawnStatus(copyStatus);
                            pLeaf.setLocked(copyStatus == JDFResource.EnumSpawnStatus.SpawnedRW);
                        }
                        pLeaf.appendSpawnIDs(spawnID);
                        continue;
                    }
                    pLeaf.setLocked(copyStatus != JDFResource.EnumSpawnStatus.SpawnedRW);
                    pLeaf.setSpawnIDs(new VString(spawnID, null));
                }
            } else {
                if (bStayinMain) {
                    if (copyStatus == JDFResource.EnumSpawnStatus.SpawnedRW || r.getSpawnStatus() != JDFResource.EnumSpawnStatus.SpawnedRW) {
                        r.setSpawnStatus(copyStatus);
                        r.setLocked(copyStatus == JDFResource.EnumSpawnStatus.SpawnedRW);
                    }
                } else {
                    r.setLocked(copyStatus != JDFResource.EnumSpawnStatus.SpawnedRW);
                }
                if (bStayinMain) {
                    r.appendSpawnIDs(spawnID);
                } else {
                    r.setSpawnIDs(new VString(spawnID, null));
                }
            }
        }

        private VElement getSubParts(JDFResource r, JDFAttributeMap partMap) {
            VElement vSubParts;
            if (JDFSpawn.this.setSpawnParts.contains(partMap)) {
                vSubParts = new VElement();
                vSubParts.add(r);
            } else {
                vSubParts = r.getPartitionVector(JDFSpawn.this.vSpawnParts, null);
                if (vSubParts == null || vSubParts.size() == 0) {
                    vSubParts = r.getPartitionVector(JDFSpawn.this.vSpawnParts, JDFResource.EnumPartUsage.Implicit);
                }
            }
            return vSubParts;
        }
    }
}

